/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.PostTradingConfigurationBankModel;
import app.cybrid.cybrid_api_bank.client.model.TradingConfigurationBankModel;
import app.cybrid.cybrid_api_bank.client.model.TradingConfigurationListBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class TradingConfigurationsBankApi {
    private ApiClient apiClient;

    public TradingConfigurationsBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public TradingConfigurationsBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createTradingConfigurationRequestCreation(PostTradingConfigurationBankModel postTradingConfigurationBankModel) throws WebClientResponseException {
        PostTradingConfigurationBankModel postBody = postTradingConfigurationBankModel;
        if (postTradingConfigurationBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postTradingConfigurationBankModel' when calling createTradingConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<TradingConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<TradingConfigurationBankModel>(){};
        return this.apiClient.invokeAPI("/api/trading_configurations", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TradingConfigurationBankModel> createTradingConfiguration(PostTradingConfigurationBankModel postTradingConfigurationBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<TradingConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<TradingConfigurationBankModel>(){};
        return this.createTradingConfigurationRequestCreation(postTradingConfigurationBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TradingConfigurationBankModel>> createTradingConfigurationWithHttpInfo(PostTradingConfigurationBankModel postTradingConfigurationBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<TradingConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<TradingConfigurationBankModel>(){};
        return this.createTradingConfigurationRequestCreation(postTradingConfigurationBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getTradingConfigurationRequestCreation(String tradingConfigurationGuid) throws WebClientResponseException {
        Object postBody = null;
        if (tradingConfigurationGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'tradingConfigurationGuid' when calling getTradingConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("trading_configuration_guid", tradingConfigurationGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<TradingConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<TradingConfigurationBankModel>(){};
        return this.apiClient.invokeAPI("/api/trading_configurations/{trading_configuration_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TradingConfigurationBankModel> getTradingConfiguration(String tradingConfigurationGuid) throws WebClientResponseException {
        ParameterizedTypeReference<TradingConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<TradingConfigurationBankModel>(){};
        return this.getTradingConfigurationRequestCreation(tradingConfigurationGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TradingConfigurationBankModel>> getTradingConfigurationWithHttpInfo(String tradingConfigurationGuid) throws WebClientResponseException {
        ParameterizedTypeReference<TradingConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<TradingConfigurationBankModel>(){};
        return this.getTradingConfigurationRequestCreation(tradingConfigurationGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listTradingConfigurationsRequestCreation(BigInteger page, BigInteger perPage) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<TradingConfigurationListBankModel> localVarReturnType = new ParameterizedTypeReference<TradingConfigurationListBankModel>(){};
        return this.apiClient.invokeAPI("/api/trading_configurations", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TradingConfigurationListBankModel> listTradingConfigurations(BigInteger page, BigInteger perPage) throws WebClientResponseException {
        ParameterizedTypeReference<TradingConfigurationListBankModel> localVarReturnType = new ParameterizedTypeReference<TradingConfigurationListBankModel>(){};
        return this.listTradingConfigurationsRequestCreation(page, perPage).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TradingConfigurationListBankModel>> listTradingConfigurationsWithHttpInfo(BigInteger page, BigInteger perPage) throws WebClientResponseException {
        ParameterizedTypeReference<TradingConfigurationListBankModel> localVarReturnType = new ParameterizedTypeReference<TradingConfigurationListBankModel>(){};
        return this.listTradingConfigurationsRequestCreation(page, perPage).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

