/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "spread_fee", "fixed_fee"})
@JsonTypeName(value="PostFee")
public class PostFeeBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SPREAD_FEE = "spread_fee";
    private BigInteger spreadFee;
    public static final String JSON_PROPERTY_FIXED_FEE = "fixed_fee";
    private BigInteger fixedFee;

    public PostFeeBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The fee's type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostFeeBankModel spreadFee(BigInteger spreadFee) {
        this.spreadFee = spreadFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage amount, in basis points, to apply when charging a fee.")
    @JsonProperty(value="spread_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getSpreadFee() {
        return this.spreadFee;
    }

    @JsonProperty(value="spread_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpreadFee(BigInteger spreadFee) {
        this.spreadFee = spreadFee;
    }

    public PostFeeBankModel fixedFee(BigInteger fixedFee) {
        this.fixedFee = fixedFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fixed amount, in the currency of the parent trading configuration, to apply when charging a fee.")
    @JsonProperty(value="fixed_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getFixedFee() {
        return this.fixedFee;
    }

    @JsonProperty(value="fixed_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFixedFee(BigInteger fixedFee) {
        this.fixedFee = fixedFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostFeeBankModel postFee = (PostFeeBankModel)o;
        return Objects.equals((Object)this.type, (Object)postFee.type) && Objects.equals(this.spreadFee, postFee.spreadFee) && Objects.equals(this.fixedFee, postFee.fixedFee);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.spreadFee, this.fixedFee});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostFeeBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    spreadFee: ").append(this.toIndentedString(this.spreadFee)).append("\n");
        sb.append("    fixedFee: ").append(this.toIndentedString(this.fixedFee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SPREAD("spread"),
        FIXED("fixed");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

