/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "method", "customer_guid", "expected_behaviours"})
@JsonTypeName(value="PostIdentityVerification")
public class PostIdentityVerificationBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_METHOD = "method";
    private MethodEnum method;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_EXPECTED_BEHAVIOURS = "expected_behaviours";
    private List<ExpectedBehavioursEnum> expectedBehaviours = null;

    public PostIdentityVerificationBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of identity verification.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostIdentityVerificationBankModel method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The identity verification method.")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MethodEnum getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public PostIdentityVerificationBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PostIdentityVerificationBankModel expectedBehaviours(List<ExpectedBehavioursEnum> expectedBehaviours) {
        this.expectedBehaviours = expectedBehaviours;
        return this;
    }

    public PostIdentityVerificationBankModel addExpectedBehavioursItem(ExpectedBehavioursEnum expectedBehavioursItem) {
        if (this.expectedBehaviours == null) {
            this.expectedBehaviours = new ArrayList<ExpectedBehavioursEnum>();
        }
        this.expectedBehaviours.add(expectedBehavioursItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional expected behaviour to simulate.")
    @JsonProperty(value="expected_behaviours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExpectedBehavioursEnum> getExpectedBehaviours() {
        return this.expectedBehaviours;
    }

    @JsonProperty(value="expected_behaviours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpectedBehaviours(List<ExpectedBehavioursEnum> expectedBehaviours) {
        this.expectedBehaviours = expectedBehaviours;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostIdentityVerificationBankModel postIdentityVerification = (PostIdentityVerificationBankModel)o;
        return Objects.equals((Object)this.type, (Object)postIdentityVerification.type) && Objects.equals((Object)this.method, (Object)postIdentityVerification.method) && Objects.equals(this.customerGuid, postIdentityVerification.customerGuid) && Objects.equals(this.expectedBehaviours, postIdentityVerification.expectedBehaviours);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.method, this.customerGuid, this.expectedBehaviours});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostIdentityVerificationBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    expectedBehaviours: ").append(this.toIndentedString(this.expectedBehaviours)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExpectedBehavioursEnum {
        PASSED_IMMEDIATELY("passed_immediately"),
        FAILED_IMMEDIATELY("failed_immediately");

        private String value;

        private ExpectedBehavioursEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExpectedBehavioursEnum fromValue(String value) {
            for (ExpectedBehavioursEnum b : ExpectedBehavioursEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MethodEnum {
        ID_AND_SELFIE("id_and_selfie");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        KYC("kyc");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

