/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "product_type", "customer_guid", "symbol", "side", "receive_amount", "deliver_amount", "fee", "issued_at", "expires_at", "asset"})
@JsonTypeName(value="Quote")
public class QuoteBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_PRODUCT_TYPE = "product_type";
    private ProductTypeEnum productType;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_SIDE = "side";
    private SideEnum side;
    public static final String JSON_PROPERTY_RECEIVE_AMOUNT = "receive_amount";
    private BigInteger receiveAmount;
    public static final String JSON_PROPERTY_DELIVER_AMOUNT = "deliver_amount";
    private BigInteger deliverAmount;
    public static final String JSON_PROPERTY_FEE = "fee";
    private BigInteger fee;
    public static final String JSON_PROPERTY_ISSUED_AT = "issued_at";
    private OffsetDateTime issuedAt;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;

    public QuoteBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the quote.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public QuoteBankModel productType(ProductTypeEnum productType) {
        this.productType = productType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of product the quote is for.")
    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProductTypeEnum getProductType() {
        return this.productType;
    }

    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductType(ProductTypeEnum productType) {
        this.productType = productType;
    }

    public QuoteBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the customer.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public QuoteBankModel symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Symbol the quote was requested for. Format is \"asset-counter_asset\" in uppercase. Populated for trade quotes.")
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public QuoteBankModel side(SideEnum side) {
        this.side = side;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The direction of the quote: either 'buy' or 'sell' for trade quotes.")
    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SideEnum getSide() {
        return this.side;
    }

    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSide(SideEnum side) {
        this.side = side;
    }

    public QuoteBankModel receiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be received in base units of the currency: currency is \"asset\" for buy and \"counter_asset\" for sell for trade quotes.")
    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getReceiveAmount() {
        return this.receiveAmount;
    }

    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public QuoteBankModel deliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be delivered in base units of the currency: currency is \"counter_asset\" for buy and \"asset\" for sell for trade quotes.")
    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getDeliverAmount() {
        return this.deliverAmount;
    }

    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public QuoteBankModel fee(BigInteger fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fee associated with the trade. Denominated in \"counter_asset\" base units for trade quotes.")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(BigInteger fee) {
        this.fee = fee;
    }

    public QuoteBankModel issuedAt(OffsetDateTime issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the quote was created at.")
    @JsonProperty(value="issued_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getIssuedAt() {
        return this.issuedAt;
    }

    @JsonProperty(value="issued_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuedAt(OffsetDateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    public QuoteBankModel expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the quote is expiring at. Populated for trading quotes.")
    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public QuoteBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code the quote was requested for. Populated for book transfer and funding quotes.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuoteBankModel quote = (QuoteBankModel)o;
        return Objects.equals(this.guid, quote.guid) && Objects.equals((Object)this.productType, (Object)quote.productType) && Objects.equals(this.customerGuid, quote.customerGuid) && Objects.equals(this.symbol, quote.symbol) && Objects.equals((Object)this.side, (Object)quote.side) && Objects.equals(this.receiveAmount, quote.receiveAmount) && Objects.equals(this.deliverAmount, quote.deliverAmount) && Objects.equals(this.fee, quote.fee) && Objects.equals(this.issuedAt, quote.issuedAt) && Objects.equals(this.expiresAt, quote.expiresAt) && Objects.equals(this.asset, quote.asset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.productType, this.customerGuid, this.symbol, this.side, this.receiveAmount, this.deliverAmount, this.fee, this.issuedAt, this.expiresAt, this.asset});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QuoteBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    productType: ").append(this.toIndentedString((Object)this.productType)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    side: ").append(this.toIndentedString((Object)this.side)).append("\n");
        sb.append("    receiveAmount: ").append(this.toIndentedString(this.receiveAmount)).append("\n");
        sb.append("    deliverAmount: ").append(this.toIndentedString(this.deliverAmount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    issuedAt: ").append(this.toIndentedString(this.issuedAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SideEnum {
        BUY("buy"),
        SELL("sell"),
        DEPOSIT("deposit"),
        WITHDRAWAL("withdrawal");

        private String value;

        private SideEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SideEnum fromValue(String value) {
            for (SideEnum b : SideEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProductTypeEnum {
        TRADING("trading"),
        FUNDING("funding"),
        BOOK_TRANSFER("book_transfer");

        private String value;

        private ProductTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProductTypeEnum fromValue(String value) {
            for (ProductTypeEnum b : ProductTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

