/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.PostRewardBankModel;
import app.cybrid.cybrid_api_bank.client.model.RewardBankModel;
import app.cybrid.cybrid_api_bank.client.model.RewardListBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class RewardsBankApi {
    private ApiClient apiClient;

    public RewardsBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public RewardsBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRewardsRequestCreation(PostRewardBankModel postRewardBankModel) throws WebClientResponseException {
        PostRewardBankModel postBody = postRewardBankModel;
        if (postRewardBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postRewardBankModel' when calling createRewards", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<RewardBankModel> localVarReturnType = new ParameterizedTypeReference<RewardBankModel>(){};
        return this.apiClient.invokeAPI("/api/rewards", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RewardBankModel> createRewards(PostRewardBankModel postRewardBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<RewardBankModel> localVarReturnType = new ParameterizedTypeReference<RewardBankModel>(){};
        return this.createRewardsRequestCreation(postRewardBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RewardBankModel>> createRewardsWithHttpInfo(PostRewardBankModel postRewardBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<RewardBankModel> localVarReturnType = new ParameterizedTypeReference<RewardBankModel>(){};
        return this.createRewardsRequestCreation(postRewardBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getRewardRequestCreation(String rewardGuid) throws WebClientResponseException {
        Object postBody = null;
        if (rewardGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'rewardGuid' when calling getReward", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("reward_guid", rewardGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<RewardBankModel> localVarReturnType = new ParameterizedTypeReference<RewardBankModel>(){};
        return this.apiClient.invokeAPI("/api/rewards/{reward_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RewardBankModel> getReward(String rewardGuid) throws WebClientResponseException {
        ParameterizedTypeReference<RewardBankModel> localVarReturnType = new ParameterizedTypeReference<RewardBankModel>(){};
        return this.getRewardRequestCreation(rewardGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RewardBankModel>> getRewardWithHttpInfo(String rewardGuid) throws WebClientResponseException {
        ParameterizedTypeReference<RewardBankModel> localVarReturnType = new ParameterizedTypeReference<RewardBankModel>(){};
        return this.getRewardRequestCreation(rewardGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listRewardsRequestCreation(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<RewardListBankModel> localVarReturnType = new ParameterizedTypeReference<RewardListBankModel>(){};
        return this.apiClient.invokeAPI("/api/rewards", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RewardListBankModel> listRewards(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<RewardListBankModel> localVarReturnType = new ParameterizedTypeReference<RewardListBankModel>(){};
        return this.listRewardsRequestCreation(page, perPage, guid, bankGuid, customerGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RewardListBankModel>> listRewardsWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<RewardListBankModel> localVarReturnType = new ParameterizedTypeReference<RewardListBankModel>(){};
        return this.listRewardsRequestCreation(page, perPage, guid, bankGuid, customerGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

