/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.DepositAddressBankModel;
import app.cybrid.cybrid_api_bank.client.model.DepositAddressListBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostDepositAddressBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class DepositAddressesBankApi {
    private ApiClient apiClient;

    public DepositAddressesBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public DepositAddressesBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createDepositAddressRequestCreation(PostDepositAddressBankModel postDepositAddressBankModel) throws WebClientResponseException {
        PostDepositAddressBankModel postBody = postDepositAddressBankModel;
        if (postDepositAddressBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postDepositAddressBankModel' when calling createDepositAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<DepositAddressBankModel> localVarReturnType = new ParameterizedTypeReference<DepositAddressBankModel>(){};
        return this.apiClient.invokeAPI("/api/deposit_addresses", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DepositAddressBankModel> createDepositAddress(PostDepositAddressBankModel postDepositAddressBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<DepositAddressBankModel> localVarReturnType = new ParameterizedTypeReference<DepositAddressBankModel>(){};
        return this.createDepositAddressRequestCreation(postDepositAddressBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DepositAddressBankModel>> createDepositAddressWithHttpInfo(PostDepositAddressBankModel postDepositAddressBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<DepositAddressBankModel> localVarReturnType = new ParameterizedTypeReference<DepositAddressBankModel>(){};
        return this.createDepositAddressRequestCreation(postDepositAddressBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getDepositAddressRequestCreation(String depositAddressGuid) throws WebClientResponseException {
        Object postBody = null;
        if (depositAddressGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'depositAddressGuid' when calling getDepositAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("deposit_address_guid", depositAddressGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<DepositAddressBankModel> localVarReturnType = new ParameterizedTypeReference<DepositAddressBankModel>(){};
        return this.apiClient.invokeAPI("/api/deposit_addresses/{deposit_address_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DepositAddressBankModel> getDepositAddress(String depositAddressGuid) throws WebClientResponseException {
        ParameterizedTypeReference<DepositAddressBankModel> localVarReturnType = new ParameterizedTypeReference<DepositAddressBankModel>(){};
        return this.getDepositAddressRequestCreation(depositAddressGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DepositAddressBankModel>> getDepositAddressWithHttpInfo(String depositAddressGuid) throws WebClientResponseException {
        ParameterizedTypeReference<DepositAddressBankModel> localVarReturnType = new ParameterizedTypeReference<DepositAddressBankModel>(){};
        return this.getDepositAddressRequestCreation(depositAddressGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listDepositAddressesRequestCreation(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<DepositAddressListBankModel> localVarReturnType = new ParameterizedTypeReference<DepositAddressListBankModel>(){};
        return this.apiClient.invokeAPI("/api/deposit_addresses", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DepositAddressListBankModel> listDepositAddresses(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<DepositAddressListBankModel> localVarReturnType = new ParameterizedTypeReference<DepositAddressListBankModel>(){};
        return this.listDepositAddressesRequestCreation(page, perPage, guid, bankGuid, customerGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DepositAddressListBankModel>> listDepositAddressesWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<DepositAddressListBankModel> localVarReturnType = new ParameterizedTypeReference<DepositAddressListBankModel>(){};
        return this.listDepositAddressesRequestCreation(page, perPage, guid, bankGuid, customerGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

