/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.FeeConfigurationBankModel;
import app.cybrid.cybrid_api_bank.client.model.FeeConfigurationListBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostFeeConfigurationBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class FeeConfigurationsBankApi {
    private ApiClient apiClient;

    public FeeConfigurationsBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public FeeConfigurationsBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createFeeConfigurationRequestCreation(PostFeeConfigurationBankModel postFeeConfigurationBankModel) throws WebClientResponseException {
        PostFeeConfigurationBankModel postBody = postFeeConfigurationBankModel;
        if (postFeeConfigurationBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postFeeConfigurationBankModel' when calling createFeeConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>(){};
        return this.apiClient.invokeAPI("/api/fee_configurations", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FeeConfigurationBankModel> createFeeConfiguration(PostFeeConfigurationBankModel postFeeConfigurationBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>(){};
        return this.createFeeConfigurationRequestCreation(postFeeConfigurationBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<FeeConfigurationBankModel>> createFeeConfigurationWithHttpInfo(PostFeeConfigurationBankModel postFeeConfigurationBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>(){};
        return this.createFeeConfigurationRequestCreation(postFeeConfigurationBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getFeeConfigurationRequestCreation(String feeConfigurationGuid) throws WebClientResponseException {
        Object postBody = null;
        if (feeConfigurationGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'feeConfigurationGuid' when calling getFeeConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("fee_configuration_guid", feeConfigurationGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>(){};
        return this.apiClient.invokeAPI("/api/fee_configurations/{fee_configuration_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FeeConfigurationBankModel> getFeeConfiguration(String feeConfigurationGuid) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>(){};
        return this.getFeeConfigurationRequestCreation(feeConfigurationGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<FeeConfigurationBankModel>> getFeeConfigurationWithHttpInfo(String feeConfigurationGuid) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>(){};
        return this.getFeeConfigurationRequestCreation(feeConfigurationGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listFeeConfigurationsRequestCreation(BigInteger page, BigInteger perPage) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<FeeConfigurationListBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationListBankModel>(){};
        return this.apiClient.invokeAPI("/api/fee_configurations", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FeeConfigurationListBankModel> listFeeConfigurations(BigInteger page, BigInteger perPage) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationListBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationListBankModel>(){};
        return this.listFeeConfigurationsRequestCreation(page, perPage).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<FeeConfigurationListBankModel>> listFeeConfigurationsWithHttpInfo(BigInteger page, BigInteger perPage) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationListBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationListBankModel>(){};
        return this.listFeeConfigurationsRequestCreation(page, perPage).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

