/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"state", "failure_code"})
@JsonTypeName(value="AttestationDetails")
public class AttestationDetailsBankModel {
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private FailureCodeEnum failureCode;

    public AttestationDetailsBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of an identity record attestation")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public AttestationDetailsBankModel failureCode(FailureCodeEnum failureCode) {
        this.failureCode = failureCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The failure code of an identity record attestation (if any)")
    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FailureCodeEnum getFailureCode() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCode(FailureCodeEnum failureCode) {
        this.failureCode = failureCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestationDetailsBankModel attestationDetails = (AttestationDetailsBankModel)o;
        return Objects.equals((Object)this.state, (Object)attestationDetails.state) && Objects.equals((Object)this.failureCode, (Object)attestationDetails.failureCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.failureCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttestationDetailsBankModel {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString((Object)this.failureCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FailureCodeEnum {
        INVALID_KEY("invalid_key"),
        INVALID_ALGORITHM("invalid_algorithm"),
        INVALID_SIGNATURE("invalid_signature"),
        INVALID_ISSUER("invalid_issuer"),
        INVALID_AUDIENCE("invalid_audience"),
        INVALID_SUBJECT("invalid_subject"),
        JWT_EXPIRED("jwt_expired"),
        MISSING_JTI("missing_jti"),
        MISSING_KEYID("missing_keyid");

        private String value;

        private FailureCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FailureCodeEnum fromValue(String value) {
            for (FailureCodeEnum b : FailureCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum StateEnum {
        STORING("storing"),
        EXPIRED("expired"),
        VERIFIED("verified"),
        FAILED("failed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

