/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"type", "algorithm", "public_key", "nonce", "signature"})
@JsonTypeName(value="PostVerificationKey")
public class PostVerificationKeyBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ALGORITHM = "algorithm";
    private AlgorithmEnum algorithm;
    public static final String JSON_PROPERTY_PUBLIC_KEY = "public_key";
    private String publicKey;
    public static final String JSON_PROPERTY_NONCE = "nonce";
    private String nonce;
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private String signature;

    public PostVerificationKeyBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The verification key's type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostVerificationKeyBankModel algorithm(AlgorithmEnum algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The verification key's algorithm.")
    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AlgorithmEnum getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAlgorithm(AlgorithmEnum algorithm) {
        this.algorithm = algorithm;
    }

    public PostVerificationKeyBankModel publicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="DER encoded public key in Base64 format.")
    @JsonProperty(value="public_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPublicKey() {
        return this.publicKey;
    }

    @JsonProperty(value="public_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public PostVerificationKeyBankModel nonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Value signed in the **signature** field.")
    @JsonProperty(value="nonce")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNonce() {
        return this.nonce;
    }

    @JsonProperty(value="nonce")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public PostVerificationKeyBankModel signature(String signature) {
        this.signature = signature;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Signature on **nonce** using PKCS1v15 padding and the SHA512 hashing algorithm in Base64 format.")
    @JsonProperty(value="signature")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSignature() {
        return this.signature;
    }

    @JsonProperty(value="signature")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostVerificationKeyBankModel postVerificationKey = (PostVerificationKeyBankModel)o;
        return Objects.equals((Object)this.type, (Object)postVerificationKey.type) && Objects.equals((Object)this.algorithm, (Object)postVerificationKey.algorithm) && Objects.equals(this.publicKey, postVerificationKey.publicKey) && Objects.equals(this.nonce, postVerificationKey.nonce) && Objects.equals(this.signature, postVerificationKey.signature);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.algorithm, this.publicKey, this.nonce, this.signature});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostVerificationKeyBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    algorithm: ").append(this.toIndentedString((Object)this.algorithm)).append("\n");
        sb.append("    publicKey: ").append(this.toIndentedString(this.publicKey)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AlgorithmEnum {
        RS512("RS512");

        private String value;

        private AlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AlgorithmEnum fromValue(String value) {
            for (AlgorithmEnum b : AlgorithmEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        ATTESTATION("attestation");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

