/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.AccountBankModel;
import app.cybrid.cybrid_api_bank.client.model.AccountListBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostAccountBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class AccountsBankApi {
    private ApiClient apiClient;

    public AccountsBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountsBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAccountRequestCreation(PostAccountBankModel postAccountBankModel) throws WebClientResponseException {
        PostAccountBankModel postBody = postAccountBankModel;
        if (postAccountBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postAccountBankModel' when calling createAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<AccountBankModel> localVarReturnType = new ParameterizedTypeReference<AccountBankModel>(){};
        return this.apiClient.invokeAPI("/api/accounts", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AccountBankModel> createAccount(PostAccountBankModel postAccountBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<AccountBankModel> localVarReturnType = new ParameterizedTypeReference<AccountBankModel>(){};
        return this.createAccountRequestCreation(postAccountBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AccountBankModel>> createAccountWithHttpInfo(PostAccountBankModel postAccountBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<AccountBankModel> localVarReturnType = new ParameterizedTypeReference<AccountBankModel>(){};
        return this.createAccountRequestCreation(postAccountBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getAccountRequestCreation(String accountGuid) throws WebClientResponseException {
        Object postBody = null;
        if (accountGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountGuid' when calling getAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("account_guid", accountGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<AccountBankModel> localVarReturnType = new ParameterizedTypeReference<AccountBankModel>(){};
        return this.apiClient.invokeAPI("/api/accounts/{account_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AccountBankModel> getAccount(String accountGuid) throws WebClientResponseException {
        ParameterizedTypeReference<AccountBankModel> localVarReturnType = new ParameterizedTypeReference<AccountBankModel>(){};
        return this.getAccountRequestCreation(accountGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AccountBankModel>> getAccountWithHttpInfo(String accountGuid) throws WebClientResponseException {
        ParameterizedTypeReference<AccountBankModel> localVarReturnType = new ParameterizedTypeReference<AccountBankModel>(){};
        return this.getAccountRequestCreation(accountGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listAccountsRequestCreation(BigInteger page, BigInteger perPage, String guid, String type, String bankGuid, String customerGuid) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<AccountListBankModel> localVarReturnType = new ParameterizedTypeReference<AccountListBankModel>(){};
        return this.apiClient.invokeAPI("/api/accounts", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AccountListBankModel> listAccounts(BigInteger page, BigInteger perPage, String guid, String type, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<AccountListBankModel> localVarReturnType = new ParameterizedTypeReference<AccountListBankModel>(){};
        return this.listAccountsRequestCreation(page, perPage, guid, type, bankGuid, customerGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AccountListBankModel>> listAccountsWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String type, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<AccountListBankModel> localVarReturnType = new ParameterizedTypeReference<AccountListBankModel>(){};
        return this.listAccountsRequestCreation(page, perPage, guid, type, bankGuid, customerGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

