/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "bank_guid", "customer_guid", "account_guid", "created_at", "asset", "state", "address", "format", "tag"})
@JsonTypeName(value="DepositAddress")
public class DepositAddressBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private String bankGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_ACCOUNT_GUID = "account_guid";
    private String accountGuid;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address;
    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format;
    public static final String JSON_PROPERTY_TAG = "tag";
    private String tag;

    public DepositAddressBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Auto-generated unique identifier for the identity verification.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public DepositAddressBankModel bankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The address' bank identifier.")
    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBankGuid() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
    }

    public DepositAddressBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The address' customer identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public DepositAddressBankModel accountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The address' account identifier.")
    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountGuid() {
        return this.accountGuid;
    }

    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
    }

    public DepositAddressBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ISO8601 datetime the address was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DepositAddressBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The asset the transfer is related to, e.g., USD.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public DepositAddressBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The state of the address.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public DepositAddressBankModel address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The blockchain address.")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(String address) {
        this.address = address;
    }

    public DepositAddressBankModel format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The blockchain address format.")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public DepositAddressBankModel tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The blockchain address tag.")
    @JsonProperty(value="tag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTag() {
        return this.tag;
    }

    @JsonProperty(value="tag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepositAddressBankModel depositAddress = (DepositAddressBankModel)o;
        return Objects.equals(this.guid, depositAddress.guid) && Objects.equals(this.bankGuid, depositAddress.bankGuid) && Objects.equals(this.customerGuid, depositAddress.customerGuid) && Objects.equals(this.accountGuid, depositAddress.accountGuid) && Objects.equals(this.createdAt, depositAddress.createdAt) && Objects.equals(this.asset, depositAddress.asset) && Objects.equals((Object)this.state, (Object)depositAddress.state) && Objects.equals(this.address, depositAddress.address) && Objects.equals((Object)this.format, (Object)depositAddress.format) && Objects.equals(this.tag, depositAddress.tag);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.bankGuid, this.customerGuid, this.accountGuid, this.createdAt, this.asset, this.state, this.address, this.format, this.tag});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositAddressBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    accountGuid: ").append(this.toIndentedString(this.accountGuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FormatEnum {
        STANDARD("standard"),
        LEGACY("legacy");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StateEnum {
        STORING("storing"),
        CREATED("created");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

