/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.PostQuoteBankModel;
import app.cybrid.cybrid_api_bank.client.model.QuoteBankModel;
import app.cybrid.cybrid_api_bank.client.model.QuoteListBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class QuotesBankApi {
    private ApiClient apiClient;

    public QuotesBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public QuotesBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createQuoteRequestCreation(PostQuoteBankModel postQuoteBankModel) throws WebClientResponseException {
        PostQuoteBankModel postBody = postQuoteBankModel;
        if (postQuoteBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postQuoteBankModel' when calling createQuote", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<QuoteBankModel> localVarReturnType = new ParameterizedTypeReference<QuoteBankModel>(){};
        return this.apiClient.invokeAPI("/api/quotes", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<QuoteBankModel> createQuote(PostQuoteBankModel postQuoteBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteBankModel> localVarReturnType = new ParameterizedTypeReference<QuoteBankModel>(){};
        return this.createQuoteRequestCreation(postQuoteBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<QuoteBankModel>> createQuoteWithHttpInfo(PostQuoteBankModel postQuoteBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteBankModel> localVarReturnType = new ParameterizedTypeReference<QuoteBankModel>(){};
        return this.createQuoteRequestCreation(postQuoteBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getQuoteRequestCreation(String quoteGuid) throws WebClientResponseException {
        Object postBody = null;
        if (quoteGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'quoteGuid' when calling getQuote", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("quote_guid", quoteGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<QuoteBankModel> localVarReturnType = new ParameterizedTypeReference<QuoteBankModel>(){};
        return this.apiClient.invokeAPI("/api/quotes/{quote_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<QuoteBankModel> getQuote(String quoteGuid) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteBankModel> localVarReturnType = new ParameterizedTypeReference<QuoteBankModel>(){};
        return this.getQuoteRequestCreation(quoteGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<QuoteBankModel>> getQuoteWithHttpInfo(String quoteGuid) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteBankModel> localVarReturnType = new ParameterizedTypeReference<QuoteBankModel>(){};
        return this.getQuoteRequestCreation(quoteGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listQuotesRequestCreation(BigInteger page, BigInteger perPage, String guid, String productType, String bankGuid, String customerGuid) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "product_type", productType));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<QuoteListBankModel> localVarReturnType = new ParameterizedTypeReference<QuoteListBankModel>(){};
        return this.apiClient.invokeAPI("/api/quotes", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<QuoteListBankModel> listQuotes(BigInteger page, BigInteger perPage, String guid, String productType, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteListBankModel> localVarReturnType = new ParameterizedTypeReference<QuoteListBankModel>(){};
        return this.listQuotesRequestCreation(page, perPage, guid, productType, bankGuid, customerGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<QuoteListBankModel>> listQuotesWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String productType, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteListBankModel> localVarReturnType = new ParameterizedTypeReference<QuoteListBankModel>(){};
        return this.listQuotesRequestCreation(page, perPage, guid, productType, bankGuid, customerGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

