/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "customer_guid", "type", "method", "created_at", "state", "outcome", "failure_codes", "persona_inquiry_id", "persona_state", "external_bank_account_guid"})
@JsonTypeName(value="IdentityVerificationWithDetails")
public class IdentityVerificationWithDetailsBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_METHOD = "method";
    private MethodEnum method;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_OUTCOME = "outcome";
    private OutcomeEnum outcome;
    public static final String JSON_PROPERTY_FAILURE_CODES = "failure_codes";
    private List<FailureCodesEnum> failureCodes = null;
    public static final String JSON_PROPERTY_PERSONA_INQUIRY_ID = "persona_inquiry_id";
    private String personaInquiryId;
    public static final String JSON_PROPERTY_PERSONA_STATE = "persona_state";
    private PersonaStateEnum personaState;
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private String externalBankAccountGuid;

    public IdentityVerificationWithDetailsBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the identity verification.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public IdentityVerificationWithDetailsBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public IdentityVerificationWithDetailsBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of identity verification.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public IdentityVerificationWithDetailsBankModel method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification method.")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MethodEnum getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public IdentityVerificationWithDetailsBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the customer was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public IdentityVerificationWithDetailsBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the verification process.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public IdentityVerificationWithDetailsBankModel outcome(OutcomeEnum outcome) {
        this.outcome = outcome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The outcome of the verification process.")
    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OutcomeEnum getOutcome() {
        return this.outcome;
    }

    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutcome(OutcomeEnum outcome) {
        this.outcome = outcome;
    }

    public IdentityVerificationWithDetailsBankModel failureCodes(List<FailureCodesEnum> failureCodes) {
        this.failureCodes = failureCodes;
        return this;
    }

    public IdentityVerificationWithDetailsBankModel addFailureCodesItem(FailureCodesEnum failureCodesItem) {
        if (this.failureCodes == null) {
            this.failureCodes = new ArrayList<FailureCodesEnum>();
        }
        this.failureCodes.add(failureCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason codes explaining the outcome.")
    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FailureCodesEnum> getFailureCodes() {
        return this.failureCodes;
    }

    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCodes(List<FailureCodesEnum> failureCodes) {
        this.failureCodes = failureCodes;
    }

    public IdentityVerificationWithDetailsBankModel personaInquiryId(String personaInquiryId) {
        this.personaInquiryId = personaInquiryId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Persona identifier of the backing inquiry.")
    @JsonProperty(value="persona_inquiry_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPersonaInquiryId() {
        return this.personaInquiryId;
    }

    @JsonProperty(value="persona_inquiry_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPersonaInquiryId(String personaInquiryId) {
        this.personaInquiryId = personaInquiryId;
    }

    public IdentityVerificationWithDetailsBankModel personaState(PersonaStateEnum personaState) {
        this.personaState = personaState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Persona state of the backing inquiry.")
    @JsonProperty(value="persona_state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PersonaStateEnum getPersonaState() {
        return this.personaState;
    }

    @JsonProperty(value="persona_state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPersonaState(PersonaStateEnum personaState) {
        this.personaState = personaState;
    }

    public IdentityVerificationWithDetailsBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The external bank account's identifier.")
    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalBankAccountGuid() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationWithDetailsBankModel identityVerificationWithDetails = (IdentityVerificationWithDetailsBankModel)o;
        return Objects.equals(this.guid, identityVerificationWithDetails.guid) && Objects.equals(this.customerGuid, identityVerificationWithDetails.customerGuid) && Objects.equals((Object)this.type, (Object)identityVerificationWithDetails.type) && Objects.equals((Object)this.method, (Object)identityVerificationWithDetails.method) && Objects.equals(this.createdAt, identityVerificationWithDetails.createdAt) && Objects.equals((Object)this.state, (Object)identityVerificationWithDetails.state) && Objects.equals((Object)this.outcome, (Object)identityVerificationWithDetails.outcome) && Objects.equals(this.failureCodes, identityVerificationWithDetails.failureCodes) && Objects.equals(this.personaInquiryId, identityVerificationWithDetails.personaInquiryId) && Objects.equals((Object)this.personaState, (Object)identityVerificationWithDetails.personaState) && Objects.equals(this.externalBankAccountGuid, identityVerificationWithDetails.externalBankAccountGuid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.customerGuid, this.type, this.method, this.createdAt, this.state, this.outcome, this.failureCodes, this.personaInquiryId, this.personaState, this.externalBankAccountGuid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationWithDetailsBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    outcome: ").append(this.toIndentedString((Object)this.outcome)).append("\n");
        sb.append("    failureCodes: ").append(this.toIndentedString(this.failureCodes)).append("\n");
        sb.append("    personaInquiryId: ").append(this.toIndentedString(this.personaInquiryId)).append("\n");
        sb.append("    personaState: ").append(this.toIndentedString((Object)this.personaState)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PersonaStateEnum {
        WAITING("waiting"),
        PENDING("pending"),
        REVIEWING("reviewing"),
        PROCESSING("processing"),
        EXPIRED("expired"),
        COMPLETED("completed"),
        UNKNOWN("unknown");

        private String value;

        private PersonaStateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PersonaStateEnum fromValue(String value) {
            for (PersonaStateEnum b : PersonaStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum FailureCodesEnum {
        REQUESTED_FAILURE("requested_failure"),
        ID_CHECK_FAILURE("id_check_failure"),
        DATABASE_CHECK_FAILURE("database_check_failure"),
        SELFIE_FAILURE("selfie_failure"),
        PEP_CHECK_FAILURE("pep_check_failure"),
        MEDIA_CHECK_FAILURE("media_check_failure"),
        WATCHLIST_CHECK_FAILURE("watchlist_check_failure"),
        NAME_CHECK_FAILURE("name_check_failure"),
        ADDRESS_CHECK_FAILURE("address_check_failure"),
        DOB_CHECK_FAILURE("dob_check_failure"),
        ID_NUMBER_CHECK_FAILURE("id_number_check_failure"),
        PHONE_NUMBER_CHECK_FAILURE("phone_number_check_failure"),
        EMAIL_ADDRESS_CHECK_FAILURE("email_address_check_failure"),
        DECISION_TIMEOUT("decision_timeout"),
        PLAID_FAILURE("plaid_failure");

        private String value;

        private FailureCodesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FailureCodesEnum fromValue(String value) {
            for (FailureCodesEnum b : FailureCodesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OutcomeEnum {
        PASSED("passed"),
        FAILED("failed");

        private String value;

        private OutcomeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OutcomeEnum fromValue(String value) {
            for (OutcomeEnum b : OutcomeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum StateEnum {
        STORING("storing"),
        WAITING("waiting"),
        EXPIRED("expired"),
        COMPLETED("completed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MethodEnum {
        ID_AND_SELFIE("id_and_selfie"),
        ATTESTED("attested"),
        PLAID_IDENTITY_MATCH("plaid_identity_match");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        KYC("kyc"),
        BANK_ACCOUNT("bank_account");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

