/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_organization.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "organization_guid", "name", "type", "url", "signing_key", "deliveries_failing_since", "environment", "state", "failure_code", "created_at", "updated_at"})
@JsonTypeName(value="Subscription")
public class SubscriptionOrganizationModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_ORGANIZATION_GUID = "organization_guid";
    private String organizationGuid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_SIGNING_KEY = "signing_key";
    private String signingKey;
    public static final String JSON_PROPERTY_DELIVERIES_FAILING_SINCE = "deliveries_failing_since";
    private OffsetDateTime deliveriesFailingSince;
    public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
    private String environment;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private String failureCode;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    public SubscriptionOrganizationModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Auto-generated unique identifier for the subscription.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public SubscriptionOrganizationModel organizationGuid(String organizationGuid) {
        this.organizationGuid = organizationGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization guid for the subscription.")
    @JsonProperty(value="organization_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrganizationGuid() {
        return this.organizationGuid;
    }

    @JsonProperty(value="organization_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrganizationGuid(String organizationGuid) {
        this.organizationGuid = organizationGuid;
    }

    public SubscriptionOrganizationModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name provided for the subscription.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public SubscriptionOrganizationModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of subscription.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SubscriptionOrganizationModel url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The url for the subscription.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public SubscriptionOrganizationModel signingKey(String signingKey) {
        this.signingKey = signingKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subscription private signing key.")
    @JsonProperty(value="signing_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSigningKey() {
        return this.signingKey;
    }

    @JsonProperty(value="signing_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    public SubscriptionOrganizationModel deliveriesFailingSince(OffsetDateTime deliveriesFailingSince) {
        this.deliveriesFailingSince = deliveriesFailingSince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the deliveries started failing.")
    @JsonProperty(value="deliveries_failing_since")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDeliveriesFailingSince() {
        return this.deliveriesFailingSince;
    }

    @JsonProperty(value="deliveries_failing_since")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveriesFailingSince(OffsetDateTime deliveriesFailingSince) {
        this.deliveriesFailingSince = deliveriesFailingSince;
    }

    public SubscriptionOrganizationModel environment(String environment) {
        this.environment = environment;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The environment that the subscription is configured for; one of sandbox or production.")
    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public SubscriptionOrganizationModel state(String state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The state of the subscription; one of storing, completed, or failed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(String state) {
        this.state = state;
    }

    public SubscriptionOrganizationModel failureCode(String failureCode) {
        this.failureCode = failureCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The failure code of a subscription (if any)")
    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFailureCode() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public SubscriptionOrganizationModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public SubscriptionOrganizationModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionOrganizationModel subscription = (SubscriptionOrganizationModel)o;
        return Objects.equals(this.guid, subscription.guid) && Objects.equals(this.organizationGuid, subscription.organizationGuid) && Objects.equals(this.name, subscription.name) && Objects.equals((Object)this.type, (Object)subscription.type) && Objects.equals(this.url, subscription.url) && Objects.equals(this.signingKey, subscription.signingKey) && Objects.equals(this.deliveriesFailingSince, subscription.deliveriesFailingSince) && Objects.equals(this.environment, subscription.environment) && Objects.equals(this.state, subscription.state) && Objects.equals(this.failureCode, subscription.failureCode) && Objects.equals(this.createdAt, subscription.createdAt) && Objects.equals(this.updatedAt, subscription.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.organizationGuid, this.name, this.type, this.url, this.signingKey, this.deliveriesFailingSince, this.environment, this.state, this.failureCode, this.createdAt, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionOrganizationModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    organizationGuid: ").append(this.toIndentedString(this.organizationGuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    signingKey: ").append(this.toIndentedString(this.signingKey)).append("\n");
        sb.append("    deliveriesFailingSince: ").append(this.toIndentedString(this.deliveriesFailingSince)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        WEBHOOK("webhook");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

