/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_organization.client.auth;

import app.cybrid.cybrid_api_organization.client.auth.OAuthFlow;
import app.cybrid.cybrid_api_organization.client.auth.OAuthOkHttpClient;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.token.BasicOAuthToken;
import org.apache.oltu.oauth2.common.token.OAuthToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001)B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bB\u0015\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010'\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010\bR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u0004\u00a8\u0006*"}, d2={"Lapp/cybrid/cybrid_api_organization/client/auth/OAuth;", "Lokhttp3/Interceptor;", "requestBuilder", "Lorg/apache/oltu/oauth2/client/request/OAuthClientRequest$TokenRequestBuilder;", "(Lorg/apache/oltu/oauth2/client/request/OAuthClientRequest$TokenRequestBuilder;)V", "flow", "Lapp/cybrid/cybrid_api_organization/client/auth/OAuthFlow;", "authorizationUrl", "", "tokenUrl", "scopes", "(Lapp/cybrid/cybrid_api_organization/client/auth/OAuthFlow;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "client", "Lokhttp3/OkHttpClient;", "tokenRequestBuilder", "(Lokhttp3/OkHttpClient;Lorg/apache/oltu/oauth2/client/request/OAuthClientRequest$TokenRequestBuilder;)V", "accessToken", "accessTokenListener", "Lapp/cybrid/cybrid_api_organization/client/auth/OAuth$AccessTokenListener;", "authenticationRequestBuilder", "Lorg/apache/oltu/oauth2/client/request/OAuthClientRequest$AuthenticationRequestBuilder;", "getAuthenticationRequestBuilder", "()Lorg/apache/oltu/oauth2/client/request/OAuthClientRequest$AuthenticationRequestBuilder;", "setAuthenticationRequestBuilder", "(Lorg/apache/oltu/oauth2/client/request/OAuthClientRequest$AuthenticationRequestBuilder;)V", "oauthClient", "Lorg/apache/oltu/oauth2/client/OAuthClient;", "getTokenRequestBuilder", "()Lorg/apache/oltu/oauth2/client/request/OAuthClientRequest$TokenRequestBuilder;", "setTokenRequestBuilder", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "retryingIntercept", "updateTokenAndRetryOnAuthorizationFailure", "", "setFlow", "", "updateAccessToken", "requestAccessToken", "AccessTokenListener", "cybrid-api-organization-kotlin"})
public final class OAuth
implements Interceptor {
    @NotNull
    private OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder;
    @NotNull
    private OAuthClient oauthClient;
    @Nullable
    private volatile String accessToken;
    @Nullable
    private OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder;
    @Nullable
    private AccessTokenListener accessTokenListener;

    public OAuth(@NotNull OkHttpClient client, @NotNull OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)tokenRequestBuilder, (String)"tokenRequestBuilder");
        this.tokenRequestBuilder = tokenRequestBuilder;
        this.oauthClient = new OAuthClient((HttpClient)new OAuthOkHttpClient(client));
    }

    @NotNull
    public final OAuthClientRequest.TokenRequestBuilder getTokenRequestBuilder() {
        return this.tokenRequestBuilder;
    }

    public final void setTokenRequestBuilder(@NotNull OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        Intrinsics.checkNotNullParameter((Object)tokenRequestBuilder, (String)"<set-?>");
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    @Nullable
    public final OAuthClientRequest.AuthenticationRequestBuilder getAuthenticationRequestBuilder() {
        return this.authenticationRequestBuilder;
    }

    public final void setAuthenticationRequestBuilder(@Nullable OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder) {
        this.authenticationRequestBuilder = authenticationRequestBuilder;
    }

    public OAuth(@NotNull OAuthClientRequest.TokenRequestBuilder requestBuilder) {
        Intrinsics.checkNotNullParameter((Object)requestBuilder, (String)"requestBuilder");
        this(new OkHttpClient(), requestBuilder);
    }

    public OAuth(@NotNull OAuthFlow flow, @NotNull String authorizationUrl, @NotNull String tokenUrl, @NotNull String scopes) {
        Intrinsics.checkNotNullParameter((Object)((Object)flow), (String)"flow");
        Intrinsics.checkNotNullParameter((Object)authorizationUrl, (String)"authorizationUrl");
        Intrinsics.checkNotNullParameter((Object)tokenUrl, (String)"tokenUrl");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder = OAuthClientRequest.tokenLocation((String)tokenUrl).setScope(scopes);
        Intrinsics.checkNotNullExpressionValue((Object)tokenRequestBuilder, (String)"tokenLocation(tokenUrl).setScope(scopes)");
        this(tokenRequestBuilder);
        this.setFlow(flow);
        this.authenticationRequestBuilder = OAuthClientRequest.authorizationLocation((String)authorizationUrl);
    }

    public final void setFlow(@NotNull OAuthFlow flow) {
        Intrinsics.checkNotNullParameter((Object)((Object)flow), (String)"flow");
        OAuthFlow oAuthFlow = flow;
        int n = WhenMappings.$EnumSwitchMapping$0[oAuthFlow.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                this.tokenRequestBuilder.setGrantType(GrantType.AUTHORIZATION_CODE);
                break;
            }
            case 3: {
                this.tokenRequestBuilder.setGrantType(GrantType.PASSWORD);
                break;
            }
            case 4: {
                this.tokenRequestBuilder.setGrantType(GrantType.CLIENT_CREDENTIALS);
            }
        }
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        return this.retryingIntercept(chain, true);
    }

    private final Response retryingIntercept(Interceptor.Chain chain, boolean updateTokenAndRetryOnAuthorizationFailure) throws IOException {
        Request request = chain.request();
        if (request.header("Authorization") != null) {
            return chain.proceed(request);
        }
        OAuthClientRequest oAuthRequest = null;
        if (this.accessToken == null) {
            this.updateAccessToken(null);
        }
        if (this.accessToken != null) {
            Request.Builder rb = request.newBuilder();
            String requestAccessToken = this.accessToken;
            try {
                OAuthClientRequest oAuthClientRequest = new OAuthBearerClientRequest(request.url().toString()).setAccessToken(requestAccessToken).buildHeaderMessage();
                Intrinsics.checkNotNullExpressionValue((Object)oAuthClientRequest, (String)"OAuthBearerClientRequest(request.url.toString())\n                        .setAccessToken(requestAccessToken)\n                        .buildHeaderMessage()");
                oAuthRequest = oAuthClientRequest;
            }
            catch (OAuthSystemException e) {
                throw new IOException(e);
            }
            Object $this$forEach$iv = oAuthRequest.getHeaders().entrySet();
            boolean $i$f$forEach2 = false;
            ResponseBody responseBody = $this$forEach$iv.iterator();
            while (responseBody.hasNext()) {
                Object element$iv = responseBody.next();
                Map.Entry header = (Map.Entry)element$iv;
                boolean bl = false;
                Object object = header.getKey();
                Intrinsics.checkNotNullExpressionValue(object, (String)"header.key");
                String string = (String)object;
                object = header.getValue();
                Intrinsics.checkNotNullExpressionValue(object, (String)"header.value");
                rb.addHeader(string, (String)object);
            }
            $this$forEach$iv = oAuthRequest.getLocationUri();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"oAuthRequest.locationUri");
            rb.url((String)$this$forEach$iv);
            Response response = chain.proceed(rb.build());
            if ((response.code() == 401 || response.code() == 403) && updateTokenAndRetryOnAuthorizationFailure) {
                try {
                    if (this.updateAccessToken(requestAccessToken)) {
                        ResponseBody $i$f$forEach2 = response.body();
                        if ($i$f$forEach2 != null) {
                            $i$f$forEach2.close();
                        }
                        return this.retryingIntercept(chain, false);
                    }
                }
                catch (Exception e) {
                    responseBody = response.body();
                    if (responseBody != null) {
                        responseBody.close();
                    }
                    throw e;
                }
            }
            return response;
        }
        return chain.proceed(chain.request());
    }

    public final synchronized boolean updateAccessToken(@Nullable String requestAccessToken) throws IOException {
        if (this.accessToken == null || StringsKt.equals$default((String)this.accessToken, (String)requestAccessToken, (boolean)false, (int)2, null)) {
            boolean bl;
            try {
                boolean bl2;
                OAuthJSONAccessTokenResponse accessTokenResponse = this.oauthClient.accessToken(this.tokenRequestBuilder.buildBodyMessage());
                if (accessTokenResponse != null && accessTokenResponse.getAccessToken() != null) {
                    this.accessToken = accessTokenResponse.getAccessToken();
                    AccessTokenListener accessTokenListener = this.accessTokenListener;
                    if (accessTokenListener != null) {
                        OAuthToken oAuthToken = accessTokenResponse.getOAuthToken();
                        if (oAuthToken == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.apache.oltu.oauth2.common.token.BasicOAuthToken");
                        }
                        accessTokenListener.notify((BasicOAuthToken)oAuthToken);
                    }
                    bl2 = !StringsKt.equals$default((String)this.accessToken, (String)requestAccessToken, (boolean)false, (int)2, null);
                } else {
                    bl2 = false;
                }
                bl = bl2;
            }
            catch (OAuthSystemException e) {
                throw new IOException(e);
            }
            catch (OAuthProblemException e) {
                throw new IOException(e);
            }
            return bl;
        }
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lapp/cybrid/cybrid_api_organization/client/auth/OAuth$AccessTokenListener;", "", "notify", "", "token", "Lorg/apache/oltu/oauth2/common/token/BasicOAuthToken;", "cybrid-api-organization-kotlin"})
    public static interface AccessTokenListener {
        public void notify(@NotNull BasicOAuthToken var1);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OAuthFlow.values().length];
            nArray[OAuthFlow.accessCode.ordinal()] = 1;
            nArray[OAuthFlow.implicit.ordinal()] = 2;
            nArray[OAuthFlow.password.ordinal()] = 3;
            nArray[OAuthFlow.application.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

