/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import com.google.crypto.tink.subtle.X25519;
import com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import com.nimbusds.jose.crypto.impl.ECDH1PU;
import com.nimbusds.jose.jwk.OctetKeyPair;
import fmgp.crypto.Curve;
import fmgp.crypto.ECDH_AuthCryptoProvider;
import fmgp.crypto.ECDH_AuthCryptoProvider$;
import fmgp.crypto.ECDH_UtilsOKP;
import fmgp.crypto.JWERecipient;
import fmgp.crypto.OKPKey;
import fmgp.crypto.OKPPublicKey;
import fmgp.crypto.OKPPublicKey$;
import fmgp.crypto.PublicKey;
import fmgp.crypto.UtilsJVM$;
import fmgp.crypto.UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$;
import fmgp.crypto.UtilsJVM$package$given_Conversion_Base64_Base64URL$;
import fmgp.crypto.error.CryptoErrorCollection$;
import fmgp.crypto.error.CryptoFailToParse$;
import fmgp.crypto.error.CryptoFailed;
import fmgp.crypto.error.KeyMissingEpkJWEHeader$;
import fmgp.crypto.error.SomeThrowable$;
import fmgp.did.VerificationMethodReferenced;
import fmgp.did.comm.AuthHeaderBuilder;
import fmgp.did.comm.AuthProtectedHeader;
import fmgp.did.comm.EncryptedMessageGeneric;
import fmgp.did.comm.ProtectedHeader;
import fmgp.util.Base64;
import fmgp.util.Base64$package$;
import fmgp.util.Base64Obj;
import java.io.Serializable;
import java.security.InvalidKeyException;
import javax.crypto.SecretKey;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.Tuple6;
import scala.Tuple6$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.json.package;

public final class ECDH_AuthOKP$
implements ECDH_UtilsOKP,
Serializable {
    public static final ECDH_AuthOKP$ MODULE$ = new ECDH_AuthOKP$();

    private ECDH_AuthOKP$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ECDH_AuthOKP$.class);
    }

    public Either<CryptoFailed, EncryptedMessageGeneric> encrypt(OKPKey sender, Seq<Tuple2<VerificationMethodReferenced, OKPKey>> okpRecipientsKeys, AuthHeaderBuilder header, byte[] clearText) {
        return this.getCurve((Seq)okpRecipientsKeys).map((Function1 & Serializable)_$6 -> UtilsJVM$.MODULE$.toJWKCurve((Curve)_$6)).map((Function1 & Serializable)curve -> {
            ECDH_AuthCryptoProvider myProvider = ECDH_AuthCryptoProvider$.MODULE$.apply((com.nimbusds.jose.jwk.Curve)curve);
            byte[] ephemeralPrivateKeyBytes = X25519.generatePrivateKey();
            byte[] ephemeralPublicKeyBytes = (byte[])Try$.MODULE$.apply(() -> this.$anonfun$3(ephemeralPrivateKeyBytes)).recover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable instanceof InvalidKeyException) {
                        InvalidKeyException ex = (InvalidKeyException)throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof InvalidKeyException) {
                        InvalidKeyException ex = (InvalidKeyException)throwable;
                        throw ex;
                    }
                    return function1.apply((Object)x);
                }
            }).get();
            Base64$package$ base64$package$ = Base64$package$.MODULE$;
            Base64.package.Base64$ Base64$_this = Base64.package.Base64$.MODULE$;
            Base64$package$ Base64$package$_this = base64$package$;
            Base64$package$ base64$package$2 = Base64$package$.MODULE$;
            Base64.package.Base64$ Base64$_this2 = Base64.package.Base64$.MODULE$;
            Base64$package$ Base64$package$_this2 = base64$package$2;
            OctetKeyPair ephemeralPrivateKey = new OctetKeyPair.Builder(curve, UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Predef$.MODULE$.wrapByteArray(Base64$_this.urlEncoder().encode(ephemeralPublicKeyBytes)).toVector())).d(UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Predef$.MODULE$.wrapByteArray(Base64$_this2.urlEncoder().encode(ephemeralPrivateKeyBytes)).toVector())).build();
            OctetKeyPair ephemeralPublicKey = ephemeralPrivateKey.toPublicJWK();
            return Tuple6$.MODULE$.apply(curve, (Object)myProvider, (Object)ephemeralPrivateKeyBytes, (Object)ephemeralPublicKeyBytes, (Object)ephemeralPrivateKey, (Object)ephemeralPublicKey);
        }).flatMap((Function1 & Serializable)x$12 -> {
            Tuple6 tuple6 = x$12;
            if (tuple6 != null) {
                byte[] byArray = (byte[])tuple6._3();
                byte[] byArray2 = (byte[])tuple6._4();
                OctetKeyPair octetKeyPair = (OctetKeyPair)tuple6._5();
                OctetKeyPair octetKeyPair2 = (OctetKeyPair)tuple6._6();
                com.nimbusds.jose.jwk.Curve curve = (com.nimbusds.jose.jwk.Curve)tuple6._1();
                ECDH_AuthCryptoProvider myProvider = (ECDH_AuthCryptoProvider)tuple6._2();
                if (byArray instanceof byte[]) {
                    byte[] ephemeralPrivateKeyBytes = byArray;
                    if (byArray2 instanceof byte[]) {
                        byte[] ephemeralPublicKeyBytes = byArray2;
                        if (octetKeyPair != null) {
                            OctetKeyPair ephemeralPrivateKey = octetKeyPair;
                            if (octetKeyPair2 != null) {
                                OctetKeyPair ephemeralPublicKey = octetKeyPair2;
                                return package.DecoderOps$.MODULE$.fromJson$extension(zio.json.package$.MODULE$.DecoderOps((CharSequence)ephemeralPublicKey.toJSONString()), OKPPublicKey$.MODULE$.decoder()).left().map((Function1 & Serializable)_$7 -> CryptoFailToParse$.MODULE$.apply(_$7)).map((Function1 & Serializable)okpKeyEphemeral -> {
                                    AuthProtectedHeader updatedHeader = header.buildWithKey((PublicKey)okpKeyEphemeral);
                                    Seq sharedSecrets = (Seq)okpRecipientsKeys.map((Function1 & Serializable)x$1 -> {
                                        Tuple2 tuple2 = x$1;
                                        if (tuple2 != null) {
                                            VerificationMethodReferenced vmr = (VerificationMethodReferenced)tuple2._1();
                                            OKPKey key = (OKPKey)tuple2._2();
                                            return Tuple2$.MODULE$.apply((Object)vmr, (Object)ECDH1PU.deriveSenderZ((OctetKeyPair)UtilsJVM$.MODULE$.toJWK(sender), (OctetKeyPair)UtilsJVM$.MODULE$.toJWK(key), (OctetKeyPair)ephemeralPrivateKey));
                                        }
                                        throw new MatchError((Object)tuple2);
                                    });
                                    EncryptedMessageGeneric ret = myProvider.encryptAUX((ProtectedHeader)updatedHeader, (Seq<Tuple2<VerificationMethodReferenced, SecretKey>>)sharedSecrets, clearText);
                                    return Tuple4$.MODULE$.apply(okpKeyEphemeral, (Object)updatedHeader, (Object)sharedSecrets, (Object)ret);
                                }).map((Function1 & Serializable)x$1 -> {
                                    Tuple4 tuple4 = x$1;
                                    if (tuple4 != null) {
                                        OKPPublicKey okpKeyEphemeral = (OKPPublicKey)tuple4._1();
                                        AuthProtectedHeader updatedHeader = (AuthProtectedHeader)tuple4._2();
                                        Seq sharedSecrets = (Seq)tuple4._3();
                                        EncryptedMessageGeneric ret = (EncryptedMessageGeneric)tuple4._4();
                                        return ret;
                                    }
                                    throw new MatchError((Object)tuple4);
                                });
                            }
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple6);
        });
    }

    public Either<CryptoFailed, byte[]> decrypt(OKPKey sender, Seq<Tuple2<VerificationMethodReferenced, OKPKey>> okpRecipientsKeys, Base64Obj<ProtectedHeader> header, Seq<JWERecipient> recipients, String iv, String cipherText, String authTag) {
        return this.getCurve((Seq)okpRecipientsKeys).map((Function1 & Serializable)_$8 -> UtilsJVM$.MODULE$.toJWKCurve((Curve)_$8)).map((Function1 & Serializable)curve -> {
            ECDH_AuthCryptoProvider myProvider = ECDH_AuthCryptoProvider$.MODULE$.apply((com.nimbusds.jose.jwk.Curve)curve);
            CriticalHeaderParamsDeferral aux = new CriticalHeaderParamsDeferral();
            aux.ensureHeaderPasses(UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$.MODULE$.apply(header));
            CriticalHeaderParamsDeferral critPolicy = aux;
            return Tuple3$.MODULE$.apply(curve, (Object)myProvider, (Object)critPolicy);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                CriticalHeaderParamsDeferral criticalHeaderParamsDeferral = (CriticalHeaderParamsDeferral)tuple3._3();
                com.nimbusds.jose.jwk.Curve curve = (com.nimbusds.jose.jwk.Curve)tuple3._1();
                ECDH_AuthCryptoProvider myProvider = (ECDH_AuthCryptoProvider)tuple3._2();
                if (criticalHeaderParamsDeferral != null) {
                    CriticalHeaderParamsDeferral critPolicy = criticalHeaderParamsDeferral;
                    return Option$.MODULE$.apply((Object)UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$.MODULE$.apply(header).getEphemeralPublicKey()).map((Function1 & Serializable)_$9 -> (OctetKeyPair)_$9).toRight(this::decrypt$$anonfun$6$$anonfun$2).flatMap((Function1 & Serializable)ephemeralPublicKey -> CryptoErrorCollection$.MODULE$.unfold((Seq)okpRecipientsKeys.map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 instanceof Tuple2) {
                            Tuple2 recipient = tuple2;
                            OctetKeyPair recipientKey = UtilsJVM$.MODULE$.toJWK((OKPKey)recipient._2());
                            Either either = Try$.MODULE$.apply(() -> this.decrypt$$anonfun$6$$anonfun$3$$anonfun$1$$anonfun$1(sender, ephemeralPublicKey, recipientKey)).toEither();
                            if (either instanceof Left) {
                                Throwable ex = (Throwable)((Left)either).value();
                                return package$.MODULE$.Left().apply((Object)SomeThrowable$.MODULE$.apply(ex));
                            }
                            if (either instanceof Right) {
                                SecretKey z = (SecretKey)((Right)either).value();
                                return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply(recipient._1(), (Object)z));
                            }
                            throw new MatchError((Object)either);
                        }
                        throw new MatchError((Object)tuple2);
                    })).flatMap((Function1 & Serializable)sharedSecrets -> myProvider.decryptAUX(header, (Seq<Tuple2<VerificationMethodReferenced, SecretKey>>)sharedSecrets, recipients, iv, cipherText, authTag).map((Function1 & Serializable)ret -> ret)));
                }
            }
            throw new MatchError((Object)tuple3);
        });
    }

    private final byte[] $anonfun$3(byte[] ephemeralPrivateKeyBytes$2) {
        return X25519.publicFromPrivate((byte[])ephemeralPrivateKeyBytes$2);
    }

    private final KeyMissingEpkJWEHeader$ decrypt$$anonfun$6$$anonfun$2() {
        return KeyMissingEpkJWEHeader$.MODULE$;
    }

    private final SecretKey decrypt$$anonfun$6$$anonfun$3$$anonfun$1$$anonfun$1(OKPKey sender$6, OctetKeyPair ephemeralPublicKey$3, OctetKeyPair recipientKey$2) {
        return ECDH1PU.deriveRecipientZ((OctetKeyPair)recipientKey$2, (OctetKeyPair)UtilsJVM$.MODULE$.toJWK(sender$6).toPublicJWK(), (OctetKeyPair)ephemeralPublicKey$3);
    }
}

