package fmgp.typings.jose

import fmgp.typings.jose.typesMod.JWTPayload
import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

object produceMod {
  
  @JSImport("jose/dist/types/jwt/produce", "ProduceJWT")
  @js.native
  /** @param payload The JWT Claims Set object. Defaults to an empty object. */
  open class ProduceJWT () extends StObject {
    def this(payload: JWTPayload) = this()
    
    /* protected */ var _payload: JWTPayload = js.native
    
    /**
      * Set the "aud" (Audience) Claim.
      *
      * @param audience "aud" (Audience) Claim value to set on the JWT Claims Set.
      */
    def setAudience(audience: String): this.type = js.native
    def setAudience(audience: js.Array[String]): this.type = js.native
    
    def setExpirationTime(input: String): this.type = js.native
    def setExpirationTime(input: js.Date): this.type = js.native
    /**
      * Set the "exp" (Expiration Time) Claim.
      *
      * - If a `number` is passed as an argument it is used as the claim directly.
      * - If a `Date` instance is passed as an argument it is converted to unix timestamp and used as the
      *   claim.
      * - If a `string` is passed as an argument it is resolved to a time span, and then added to the
      *   current unix timestamp and used as the claim.
      *
      * Format used for time span should be a number followed by a unit, such as "5 minutes" or "1
      * day".
      *
      * Valid units are: "sec", "secs", "second", "seconds", "s", "minute", "minutes", "min", "mins",
      * "m", "hour", "hours", "hr", "hrs", "h", "day", "days", "d", "week", "weeks", "w", "year",
      * "years", "yr", "yrs", and "y". It is not possible to specify months. 365.25 days is used as an
      * alias for a year.
      *
      * If the string is suffixed with "ago", or prefixed with a "-", the resulting time span gets
      * subtracted from the current unix timestamp. A "from now" suffix can also be used for
      * readability when adding to the current unix timestamp.
      *
      * @param input "exp" (Expiration Time) Claim value to set on the JWT Claims Set.
      */
    def setExpirationTime(input: Double): this.type = js.native
    
    /**
      * Set the "iat" (Issued At) Claim.
      *
      * - If no argument is used the current unix timestamp is used as the claim.
      * - If a `number` is passed as an argument it is used as the claim directly.
      * - If a `Date` instance is passed as an argument it is converted to unix timestamp and used as the
      *   claim.
      * - If a `string` is passed as an argument it is resolved to a time span, and then added to the
      *   current unix timestamp and used as the claim.
      *
      * Format used for time span should be a number followed by a unit, such as "5 minutes" or "1
      * day".
      *
      * Valid units are: "sec", "secs", "second", "seconds", "s", "minute", "minutes", "min", "mins",
      * "m", "hour", "hours", "hr", "hrs", "h", "day", "days", "d", "week", "weeks", "w", "year",
      * "years", "yr", "yrs", and "y". It is not possible to specify months. 365.25 days is used as an
      * alias for a year.
      *
      * If the string is suffixed with "ago", or prefixed with a "-", the resulting time span gets
      * subtracted from the current unix timestamp. A "from now" suffix can also be used for
      * readability when adding to the current unix timestamp.
      *
      * @param input "iat" (Expiration Time) Claim value to set on the JWT Claims Set.
      */
    def setIssuedAt(): this.type = js.native
    def setIssuedAt(input: String): this.type = js.native
    def setIssuedAt(input: js.Date): this.type = js.native
    def setIssuedAt(input: Double): this.type = js.native
    
    /**
      * Set the "iss" (Issuer) Claim.
      *
      * @param issuer "Issuer" Claim value to set on the JWT Claims Set.
      */
    def setIssuer(issuer: String): this.type = js.native
    
    /**
      * Set the "jti" (JWT ID) Claim.
      *
      * @param jwtId "jti" (JWT ID) Claim value to set on the JWT Claims Set.
      */
    def setJti(jwtId: String): this.type = js.native
    
    def setNotBefore(input: String): this.type = js.native
    def setNotBefore(input: js.Date): this.type = js.native
    /**
      * Set the "nbf" (Not Before) Claim.
      *
      * - If a `number` is passed as an argument it is used as the claim directly.
      * - If a `Date` instance is passed as an argument it is converted to unix timestamp and used as the
      *   claim.
      * - If a `string` is passed as an argument it is resolved to a time span, and then added to the
      *   current unix timestamp and used as the claim.
      *
      * Format used for time span should be a number followed by a unit, such as "5 minutes" or "1
      * day".
      *
      * Valid units are: "sec", "secs", "second", "seconds", "s", "minute", "minutes", "min", "mins",
      * "m", "hour", "hours", "hr", "hrs", "h", "day", "days", "d", "week", "weeks", "w", "year",
      * "years", "yr", "yrs", and "y". It is not possible to specify months. 365.25 days is used as an
      * alias for a year.
      *
      * If the string is suffixed with "ago", or prefixed with a "-", the resulting time span gets
      * subtracted from the current unix timestamp. A "from now" suffix can also be used for
      * readability when adding to the current unix timestamp.
      *
      * @param input "nbf" (Not Before) Claim value to set on the JWT Claims Set.
      */
    def setNotBefore(input: Double): this.type = js.native
    
    /**
      * Set the "sub" (Subject) Claim.
      *
      * @param subject "sub" (Subject) Claim value to set on the JWT Claims Set.
      */
    def setSubject(subject: String): this.type = js.native
  }
}
