/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray.junit.customjunitxml;

import app.getxray.xray.junit.customjunitxml.XmlReportData;
import app.getxray.xray.junit.customjunitxml.XmlReportWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class EnhancedLegacyXmlReportGeneratingListener
implements TestExecutionListener {
    private static final String DEFAULT_REPORTS_DIR = "./target";
    private static final Logger logger = LoggerFactory.getLogger(EnhancedLegacyXmlReportGeneratingListener.class);
    private Path propertiesFile;
    private Path reportsDir;
    private final PrintWriter out;
    private final Clock clock;
    private String reportFilename = null;
    boolean addTimestampToReportFilename = false;
    boolean reportOnlyAnnotatedTests = false;
    boolean reportsPerClass = false;
    private XmlReportData reportData;

    public EnhancedLegacyXmlReportGeneratingListener(Path reportsDir, PrintWriter out, Clock clock) {
        this(reportsDir, null, out, clock);
    }

    public EnhancedLegacyXmlReportGeneratingListener(Path reportsDir, Path propertiesFile, PrintWriter out, Clock clock) {
        this.reportsDir = reportsDir;
        this.propertiesFile = propertiesFile;
        this.out = out;
        this.clock = clock;
        try (InputStream stream = propertiesFile == null ? this.getClass().getClassLoader().getResourceAsStream("xray-junit-extensions.properties") : Files.newInputStream(propertiesFile, new OpenOption[0]);){
            if (stream != null) {
                String customReportsDirectory;
                Properties properties = new Properties();
                properties.load(stream);
                String customReportFilename = properties.getProperty("report_filename");
                if (customReportFilename != null) {
                    this.reportFilename = customReportFilename;
                }
                if ((customReportsDirectory = properties.getProperty("report_directory")) != null) {
                    this.reportsDir = FileSystems.getDefault().getPath(customReportsDirectory, new String[0]);
                }
                this.addTimestampToReportFilename = "true".equals(properties.getProperty("add_timestamp_to_report_filename"));
                this.reportOnlyAnnotatedTests = "true".equals(properties.getProperty("report_only_annotated_tests", "false"));
                this.reportsPerClass = "true".equals(properties.getProperty("reports_per_class", "false"));
            } else if (reportsDir == null) {
                this.reportsDir = FileSystems.getDefault().getPath(DEFAULT_REPORTS_DIR, new String[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EnhancedLegacyXmlReportGeneratingListener() {
        this(FileSystems.getDefault().getPath(DEFAULT_REPORTS_DIR, new String[0]), new PrintWriter(System.out, true), Clock.systemDefaultZone());
    }

    public EnhancedLegacyXmlReportGeneratingListener(Path reportsDir, PrintWriter out) {
        this(reportsDir, out, Clock.systemDefaultZone());
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.reportData = new XmlReportData(testPlan, this.clock);
        try {
            Files.createDirectories(this.reportsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.printException("Could not create reports directory: " + this.reportsDir, e);
            logger.error((Throwable)e, () -> "Could not create reports directory: " + this.reportsDir);
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.reportData = null;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.reportData.markSkipped(testIdentifier, reason);
        this.writeXmlReportInCaseOfRoot(testIdentifier);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.reportData.markStarted(testIdentifier);
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.reportData.addReportEntry(testIdentifier, entry);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult result) {
        this.reportData.markFinished(testIdentifier, result);
        this.writeXmlReportInCaseOfRoot(testIdentifier);
    }

    private void writeXmlReportInCaseOfRoot(TestIdentifier testIdentifier) {
        if (this.isRoot(testIdentifier)) {
            String rootName = this.reportsPerClass ? testIdentifier.getLegacyReportingName() : ((UniqueId.Segment)UniqueId.parse((String)testIdentifier.getUniqueId()).getSegments().get(0)).getValue();
            this.writeXmlReportSafely(testIdentifier, rootName);
        }
    }

    private void writeXmlReportSafely(TestIdentifier testIdentifier, String rootName) {
        String fileName = this.reportFilename != null && !"".equals(this.reportFilename) ? this.reportFilename : "TEST-" + rootName;
        if (this.addTimestampToReportFilename) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy_MM_dd-HH_mm_ss_SSS");
            fileName = fileName + "-" + LocalDateTime.now(this.clock).format(formatter);
        }
        fileName = fileName + ".xml";
        Path xmlFile = this.reportsDir.resolve(fileName);
        try (BufferedWriter fileWriter = Files.newBufferedWriter(xmlFile, new OpenOption[0]);){
            new XmlReportWriter(this.reportData, this.reportOnlyAnnotatedTests).writeXmlReport(testIdentifier, fileWriter);
        }
        catch (IOException | XMLStreamException e) {
            this.printException("Could not write XML report: " + xmlFile, e);
            logger.error((Throwable)e, () -> "Could not write XML report: " + xmlFile);
        }
    }

    private boolean isRoot(TestIdentifier testIdentifier) {
        if (this.reportsPerClass) {
            return testIdentifier.getParentId().isPresent() && ((UniqueId)testIdentifier.getParentIdObject().get()).getSegments().size() == 1;
        }
        return !testIdentifier.getParentId().isPresent();
    }

    private void printException(String message, Exception exception) {
        this.out.println(message);
        exception.printStackTrace(this.out);
    }
}

