/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray.junit.customjunitxml;

import app.getxray.xray.junit.customjunitxml.EnhancedLegacyXmlReportGeneratingListener;
import app.getxray.xray.junit.customjunitxml.XmlReportData;
import app.getxray.xray.junit.customjunitxml.XrayTestMetadataReader;
import app.getxray.xray.junit.customjunitxml.annotations.Requirement;
import app.getxray.xray.junit.customjunitxml.annotations.XrayTest;
import java.io.File;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.reporting.legacy.LegacyReportingUtils;

class XmlReportWriter {
    private static final Pattern CDATA_SPLIT_PATTERN = Pattern.compile("(?<=]])(?=>)");
    private static final Logger logger = LoggerFactory.getLogger(EnhancedLegacyXmlReportGeneratingListener.class);
    private final XmlReportData reportData;
    private final boolean reportOnlyAnnotatedTests;
    private final XrayTestMetadataReader xrayTestMetadataReader;

    XmlReportWriter(XmlReportData reportData, boolean reportOnlyAnnotatedTests, XrayTestMetadataReader xrayTestMetadataReader) {
        this.reportData = reportData;
        this.reportOnlyAnnotatedTests = reportOnlyAnnotatedTests;
        this.xrayTestMetadataReader = xrayTestMetadataReader;
    }

    void writeXmlReport(TestIdentifier rootDescriptor, Writer out) throws XMLStreamException {
        TestPlan testPlan = this.reportData.getTestPlan();
        Map<TestIdentifier, AggregatedTestResult> tests = testPlan.getDescendants(rootDescriptor).stream().filter(testIdentifier -> this.shouldInclude(testPlan, (TestIdentifier)testIdentifier)).collect(Collectors.toMap(Function.identity(), this::toAggregatedResult));
        this.writeXmlReport(rootDescriptor, tests, out);
    }

    private AggregatedTestResult toAggregatedResult(TestIdentifier testIdentifier) {
        if (this.reportData.wasSkipped(testIdentifier)) {
            return AggregatedTestResult.skipped();
        }
        return AggregatedTestResult.nonSkipped(this.reportData.getResults(testIdentifier));
    }

    private boolean shouldInclude(TestPlan testPlan, TestIdentifier testIdentifier) {
        return testIdentifier.isTest() || testPlan.getChildren(testIdentifier).isEmpty();
    }

    private void writeXmlReport(TestIdentifier testIdentifier, Map<TestIdentifier, AggregatedTestResult> tests, Writer out) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlWriter = factory.createXMLStreamWriter(out);
        xmlWriter.writeStartDocument("UTF-8", "1.0");
        this.newLine(xmlWriter);
        this.writeTestsuite(testIdentifier, tests, xmlWriter);
        xmlWriter.writeEndDocument();
        xmlWriter.flush();
        xmlWriter.close();
    }

    private void writeTestsuite(TestIdentifier testIdentifier, Map<TestIdentifier, AggregatedTestResult> tests, XMLStreamWriter writer) throws XMLStreamException {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        writer.writeStartElement("testsuite");
        this.writeSuiteAttributes(testIdentifier, tests.values(), numberFormat, writer);
        this.newLine(writer);
        this.writeSystemProperties(writer);
        for (Map.Entry<TestIdentifier, AggregatedTestResult> entry : tests.entrySet()) {
            this.writeTestcase(entry.getKey(), entry.getValue(), numberFormat, writer);
        }
        this.writeOutputElement("system-out", this.formatNonStandardAttributesAsString(testIdentifier), writer);
        writer.writeEndElement();
        this.newLine(writer);
    }

    private void writeSuiteAttributes(TestIdentifier testIdentifier, Collection<AggregatedTestResult> testResults, NumberFormat numberFormat, XMLStreamWriter writer) throws XMLStreamException {
        this.writeAttributeSafely(writer, "name", testIdentifier.getDisplayName());
        this.writeTestCounts(testResults, writer);
        this.writeAttributeSafely(writer, "time", this.getTime(testIdentifier, numberFormat));
        this.writeAttributeSafely(writer, "hostname", this.getHostname().orElse("<unknown host>"));
        this.writeAttributeSafely(writer, "timestamp", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.getCurrentDateTime()));
    }

    private void writeTestCounts(Collection<AggregatedTestResult> testResults, XMLStreamWriter writer) throws XMLStreamException {
        Map counts = testResults.stream().map(it -> ((AggregatedTestResult)it).type).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        long total = counts.values().stream().mapToLong(Long::longValue).sum();
        this.writeAttributeSafely(writer, "tests", String.valueOf(total));
        this.writeAttributeSafely(writer, "skipped", counts.getOrDefault((Object)AggregatedTestResult.Type.SKIPPED, 0L).toString());
        this.writeAttributeSafely(writer, "failures", counts.getOrDefault((Object)AggregatedTestResult.Type.FAILURE, 0L).toString());
        this.writeAttributeSafely(writer, "errors", counts.getOrDefault((Object)AggregatedTestResult.Type.ERROR, 0L).toString());
    }

    private void writeSystemProperties(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("properties");
        this.newLine(writer);
        Properties systemProperties = System.getProperties();
        for (String propertyName : new TreeSet<String>(systemProperties.stringPropertyNames())) {
            writer.writeEmptyElement("property");
            this.writeAttributeSafely(writer, "name", propertyName);
            this.writeAttributeSafely(writer, "value", systemProperties.getProperty(propertyName));
            this.newLine(writer);
        }
        writer.writeEndElement();
        this.newLine(writer);
    }

    private Optional<Method> getTestMethod(TestSource source) {
        if (source instanceof MethodSource) {
            return this.getTestMethod((MethodSource)source);
        }
        return Optional.empty();
    }

    private Optional<Method> getTestMethod(MethodSource source) {
        try {
            Class<?> aClass = Class.forName(source.getClassName());
            return Stream.of(aClass.getDeclaredMethods()).filter(method -> MethodSource.from((Method)method).equals((Object)source)).findAny();
        }
        catch (ClassNotFoundException e) {
            logger.error((Throwable)e, () -> "Could not get test method from method source " + source);
            return Optional.empty();
        }
    }

    private Map<String, String> getTestRunCustomFields(List<ReportEntry> entries) {
        HashMap<String, String> testRunCustomFields = new HashMap<String, String>();
        if (!entries.isEmpty()) {
            for (ReportEntry reportEntry : entries) {
                Map<String, String> entryTestRunCustomFields = reportEntry.getKeyValuePairs().entrySet().stream().filter(mapItem -> ((String)mapItem.getKey()).startsWith("xray:testrun_customfield:")).collect(Collectors.toMap(map -> ((String)map.getKey()).substring(25), Map.Entry::getValue));
                testRunCustomFields.putAll(entryTestRunCustomFields);
            }
        }
        return testRunCustomFields;
    }

    private void writeTestcase(TestIdentifier testIdentifier, AggregatedTestResult testResult, NumberFormat numberFormat, XMLStreamWriter writer) throws XMLStreamException {
        List<ReportEntry> entries;
        Map<String, String> testrunCustomFields;
        List tags;
        Optional<String> testSummaryOpt;
        Optional<String> testDescriptionOpt;
        Optional<String> testIdOpt;
        Optional<String> testKeyOpt;
        List<String> requirements;
        Optional testSource = testIdentifier.getSource();
        Optional testMethod = testSource.flatMap(this::getTestMethod);
        Optional xrayTest = AnnotationSupport.findAnnotation(testMethod, XrayTest.class);
        Optional requirement = AnnotationSupport.findAnnotation(testMethod, Requirement.class);
        if (this.reportOnlyAnnotatedTests && !requirement.isPresent() && !xrayTest.isPresent()) {
            return;
        }
        writer.writeStartElement("testcase");
        this.writeAttributeSafely(writer, "name", this.getName(testIdentifier));
        this.writeAttributeSafely(writer, "classname", this.getClassName(testIdentifier));
        this.writeAttributeSafely(writer, "time", this.getTime(testIdentifier, numberFormat));
        DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
        this.writeAttributeSafely(writer, "started-at", this.getStartedAt(testIdentifier, dateFormatter));
        this.writeAttributeSafely(writer, "finished-at", this.getFinishedAt(testIdentifier, dateFormatter));
        this.newLine(writer);
        this.writeSkippedOrErrorOrFailureElement(testIdentifier, testResult, writer);
        ArrayList<String> systemOutElements = new ArrayList<String>();
        ArrayList<String> systemErrElements = new ArrayList<String>();
        systemOutElements.add(this.formatNonStandardAttributesAsString(testIdentifier));
        this.collectReportEntries(testIdentifier, systemOutElements, systemErrElements);
        this.writeOutputElements("system-out", systemOutElements, writer);
        this.writeOutputElements("system-err", systemErrElements, writer);
        StringBuilder testrunComment = new StringBuilder();
        ArrayList<String> testrunComments = new ArrayList<String>();
        this.collectReportEntriesFor(testIdentifier, "xray:comment", testrunComments);
        testrunComments.forEach(comment -> testrunComment.append(MessageFormat.format("{0}\n", comment.trim())));
        writer.writeStartElement("properties");
        this.newLine(writer);
        if (testrunComment.length() > 0) {
            this.addPropertyWithInnerContent(writer, "testrun_comment", testrunComment.toString().trim());
            this.newLine(writer);
        }
        if (!(requirements = this.xrayTestMetadataReader.getRequirements(testIdentifier)).isEmpty()) {
            this.addProperty(writer, "requirements", String.join((CharSequence)",", requirements));
        }
        if ((testKeyOpt = this.xrayTestMetadataReader.getKey(testIdentifier)).isPresent()) {
            this.addProperty(writer, "test_key", testKeyOpt.get());
        }
        if ((testIdOpt = this.xrayTestMetadataReader.getId(testIdentifier)).isPresent()) {
            this.addProperty(writer, "test_id", testIdOpt.get());
        }
        if ((testDescriptionOpt = this.xrayTestMetadataReader.getDescription(testIdentifier)).isPresent()) {
            this.addPropertyWithInnerContent(writer, "test_description", testDescriptionOpt.get());
        }
        if ((testSummaryOpt = this.xrayTestMetadataReader.getSummary(testIdentifier)).isPresent()) {
            this.addProperty(writer, "test_summary", testSummaryOpt.get());
        }
        if (!(tags = testIdentifier.getTags().stream().map(TestTag::getName).map(String::trim).collect(Collectors.toList())).isEmpty()) {
            this.addProperty(writer, "tags", String.join((CharSequence)",", tags));
        }
        if (!(testrunCustomFields = this.getTestRunCustomFields(entries = this.reportData.getReportEntries(testIdentifier))).isEmpty()) {
            writer.writeStartElement("property");
            this.writeAttributeSafely(writer, "name", "testrun_customfields");
            this.newLine(writer);
            for (Map.Entry<String, String> customField : testrunCustomFields.entrySet()) {
                this.addItem(writer, customField.getKey(), customField.getValue());
            }
            writer.writeEndElement();
            this.newLine(writer);
        }
        if (!entries.isEmpty()) {
            writer.writeStartElement("property");
            this.writeAttributeSafely(writer, "name", "testrun_evidence");
            this.newLine(writer);
            for (ReportEntry reportEntry : entries) {
                List files = reportEntry.getKeyValuePairs().entrySet().stream().filter(mapItem -> ((String)mapItem.getKey()).equals("xray:evidence")).map(Map.Entry::getValue).collect(Collectors.toList());
                Base64.Encoder enc = Base64.getEncoder();
                for (String file : files) {
                    try {
                        byte[] fileContent = Files.readAllBytes(Paths.get(file, new String[0]));
                        byte[] encoded = enc.encode(fileContent);
                        String encodedStr = new String(encoded, "UTF-8");
                        this.addItem(writer, new File(file).getName(), encodedStr);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e, () -> "error encoding evidence " + file);
                    }
                }
            }
            writer.writeEndElement();
            this.newLine(writer);
        }
        this.addProperty(writer, "_dummy_", "");
        writer.writeEndElement();
        this.newLine(writer);
        writer.writeEndElement();
        this.newLine(writer);
    }

    private void addProperty(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
        writer.writeEmptyElement("property");
        this.writeAttributeSafely(writer, "name", name);
        this.writeAttributeSafely(writer, "value", value);
        this.newLine(writer);
    }

    private void addPropertyWithInnerContent(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
        writer.writeStartElement("property");
        this.writeAttributeSafely(writer, "name", name);
        this.writeCDataSafely(writer, value);
        writer.writeEndElement();
        this.newLine(writer);
    }

    private void addItem(XMLStreamWriter writer, String name, String content) throws XMLStreamException {
        writer.writeStartElement("item");
        this.writeAttributeSafely(writer, "name", name);
        writer.writeCharacters(content);
        writer.writeEndElement();
        this.newLine(writer);
    }

    private String getName(TestIdentifier testIdentifier) {
        String legacyName = testIdentifier.getLegacyReportingName();
        int pos = legacyName.indexOf(40);
        if (pos > 0) {
            return legacyName.substring(0, pos);
        }
        return legacyName;
    }

    private String getClassName(TestIdentifier testIdentifier) {
        return LegacyReportingUtils.getClassName((TestPlan)this.reportData.getTestPlan(), (TestIdentifier)testIdentifier);
    }

    private void writeSkippedOrErrorOrFailureElement(TestIdentifier testIdentifier, AggregatedTestResult testResult, XMLStreamWriter writer) throws XMLStreamException {
        if (testResult.type == AggregatedTestResult.Type.SKIPPED) {
            this.writeSkippedElement(this.reportData.getSkipReason(testIdentifier), writer);
        } else {
            Map<AggregatedTestResult.Type, List<Optional<Throwable>>> throwablesByType = testResult.getThrowablesByType();
            for (AggregatedTestResult.Type type : EnumSet.of(AggregatedTestResult.Type.FAILURE, AggregatedTestResult.Type.ERROR)) {
                for (Optional throwable : throwablesByType.getOrDefault((Object)type, Collections.emptyList())) {
                    this.writeErrorOrFailureElement(type, throwable.orElse(null), writer);
                }
            }
        }
    }

    private void writeSkippedElement(String reason, XMLStreamWriter writer) throws XMLStreamException {
        if (StringUtils.isNotBlank((String)reason)) {
            writer.writeStartElement("skipped");
            this.writeCDataSafely(writer, reason);
            writer.writeEndElement();
        } else {
            writer.writeEmptyElement("skipped");
        }
        this.newLine(writer);
    }

    private void writeErrorOrFailureElement(AggregatedTestResult.Type type, Throwable throwable, XMLStreamWriter writer) throws XMLStreamException {
        String elementName;
        String string = elementName = type == AggregatedTestResult.Type.FAILURE ? "failure" : "error";
        if (throwable != null) {
            writer.writeStartElement(elementName);
            this.writeFailureAttributesAndContent(throwable, writer);
            writer.writeEndElement();
        } else {
            writer.writeEmptyElement(elementName);
        }
        this.newLine(writer);
    }

    private void writeFailureAttributesAndContent(Throwable throwable, XMLStreamWriter writer) throws XMLStreamException {
        if (throwable.getMessage() != null) {
            this.writeAttributeSafely(writer, "message", throwable.getMessage());
        }
        this.writeAttributeSafely(writer, "type", throwable.getClass().getName());
        this.writeCDataSafely(writer, ExceptionUtils.readStackTrace((Throwable)throwable));
    }

    private void collectReportEntries(TestIdentifier testIdentifier, List<String> systemOutElements, List<String> systemErrElements) {
        List<ReportEntry> entries = this.reportData.getReportEntries(testIdentifier);
        if (!entries.isEmpty()) {
            ArrayList<String> systemOutElementsForCapturedOutput = new ArrayList<String>();
            StringBuilder formattedReportEntries = new StringBuilder();
            for (int i = 0; i < entries.size(); ++i) {
                ReportEntry reportEntry = entries.get(i);
                LinkedHashMap<String, String> keyValuePairs = new LinkedHashMap<String, String>(reportEntry.getKeyValuePairs());
                this.removeIfPresentAndAddAsSeparateElement(keyValuePairs, "stdout", systemOutElementsForCapturedOutput);
                this.removeIfPresentAndAddAsSeparateElement(keyValuePairs, "stderr", systemErrElements);
                this.removeXrayKeys(keyValuePairs);
                if (keyValuePairs.isEmpty()) continue;
                this.buildReportEntryDescription(reportEntry.getTimestamp(), keyValuePairs, i + 1, formattedReportEntries);
            }
            systemOutElements.add(formattedReportEntries.toString().trim());
            systemOutElements.addAll(systemOutElementsForCapturedOutput);
        }
    }

    private void collectReportEntriesFor(TestIdentifier testIdentifier, String entryName, List<String> elements) {
        List<ReportEntry> entries = this.reportData.getReportEntries(testIdentifier);
        if (!entries.isEmpty()) {
            for (ReportEntry reportEntry : entries) {
                List tempComments = reportEntry.getKeyValuePairs().entrySet().stream().filter(mapItem -> ((String)mapItem.getKey()).equals(entryName)).map(Map.Entry::getValue).collect(Collectors.toList());
                elements.addAll(tempComments);
            }
        }
    }

    private void removeXrayKeys(Map<String, String> keyValuePairs) {
        keyValuePairs.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith("xray:"));
    }

    private void removeIfPresentAndAddAsSeparateElement(Map<String, String> keyValuePairs, String key, List<String> elements) {
        String value = keyValuePairs.remove(key);
        if (value != null) {
            elements.add(value);
        }
    }

    private void buildReportEntryDescription(LocalDateTime timestamp, Map<String, String> keyValuePairs, int entryNumber, StringBuilder result) {
        result.append(MessageFormat.format("Report Entry #{0} (timestamp: {1})\n", entryNumber, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(timestamp)));
        keyValuePairs.forEach((key, value) -> result.append(MessageFormat.format("\t- {0}: {1}\n", key, value)));
    }

    private String getTime(TestIdentifier testIdentifier, NumberFormat numberFormat) {
        return numberFormat.format(this.reportData.getDurationInSeconds(testIdentifier));
    }

    private String getStartedAt(TestIdentifier testIdentifier, DateTimeFormatter dateFormatter) {
        return dateFormatter.format(this.reportData.getStartInstant(testIdentifier));
    }

    private String getFinishedAt(TestIdentifier testIdentifier, DateTimeFormatter dateFormatter) {
        return dateFormatter.format(this.reportData.getEndInstant(testIdentifier));
    }

    private Optional<String> getHostname() {
        try {
            return Optional.ofNullable(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            return Optional.empty();
        }
    }

    private LocalDateTime getCurrentDateTime() {
        return LocalDateTime.now(this.reportData.getClock()).withNano(0);
    }

    private String formatNonStandardAttributesAsString(TestIdentifier testIdentifier) {
        return "unique-id: " + testIdentifier.getUniqueId() + "\ndisplay-name: " + testIdentifier.getDisplayName();
    }

    private void writeOutputElements(String elementName, List<String> elements, XMLStreamWriter writer) throws XMLStreamException {
        for (String content : elements) {
            this.writeOutputElement(elementName, content, writer);
        }
    }

    private void writeOutputElement(String elementName, String content, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(elementName);
        this.writeCDataSafely(writer, "\n" + content + "\n");
        writer.writeEndElement();
        this.newLine(writer);
    }

    private void writeAttributeSafely(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
        writer.writeAttribute(name, XmlReportWriter.escapeIllegalChars(value));
    }

    private void writeCDataSafely(XMLStreamWriter writer, String data) throws XMLStreamException {
        for (String safeDataPart : CDATA_SPLIT_PATTERN.split(XmlReportWriter.escapeIllegalChars(data))) {
            writer.writeCData(safeDataPart);
        }
    }

    static String escapeIllegalChars(String text) {
        if (text.codePoints().allMatch(XmlReportWriter::isAllowedXmlCharacter)) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length() * 2);
        text.codePoints().forEach(codePoint -> {
            if (XmlReportWriter.isAllowedXmlCharacter(codePoint)) {
                result.appendCodePoint(codePoint);
            } else {
                result.append("&#").append(codePoint).append(';');
            }
        });
        return result.toString();
    }

    private static boolean isAllowedXmlCharacter(int codePoint) {
        return codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    private void newLine(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeCharacters("\n");
    }

    private static boolean isFailure(TestExecutionResult result) {
        Optional throwable = result.getThrowable();
        return throwable.isPresent() && throwable.get() instanceof AssertionError;
    }

    static class AggregatedTestResult {
        private static final AggregatedTestResult SKIPPED_RESULT = new AggregatedTestResult(Type.SKIPPED, Collections.emptyList());
        private final Type type;
        private final List<TestExecutionResult> executionResults;

        public static AggregatedTestResult skipped() {
            return SKIPPED_RESULT;
        }

        public static AggregatedTestResult nonSkipped(List<TestExecutionResult> executionResults) {
            Type type = executionResults.stream().map(x$0 -> Type.from(x$0)).max(Comparator.naturalOrder()).orElse(Type.SUCCESS);
            return new AggregatedTestResult(type, executionResults);
        }

        private AggregatedTestResult(Type type, List<TestExecutionResult> executionResults) {
            this.type = type;
            this.executionResults = executionResults;
        }

        public Map<Type, List<Optional<Throwable>>> getThrowablesByType() {
            return this.executionResults.stream().collect(Collectors.groupingBy(x$0 -> Type.from(x$0), Collectors.mapping(TestExecutionResult::getThrowable, Collectors.toList())));
        }

        static enum Type {
            SUCCESS,
            SKIPPED,
            FAILURE,
            ERROR;


            private static Type from(TestExecutionResult executionResult) {
                if (executionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                    return XmlReportWriter.isFailure(executionResult) ? FAILURE : ERROR;
                }
                return SUCCESS;
            }
        }
    }
}

