/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray;

import app.getxray.xray.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class XrayFeaturesImporter {
    private final MediaType MEDIA_TYPE_ZIP = MediaType.parse((String)"application/zip");
    private final MediaType MEDIA_TYPE_FOR_FEATURE_FILES = MediaType.parse((String)"text/plain");
    private final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    private final String xrayCloudApiBaseUrl = "https://xray.cloud.getxray.app/api/v2";
    private final String xrayCloudAuthenticateUrl = "https://xray.cloud.getxray.app/api/v2/authenticate";
    private String jiraBaseUrl;
    private String jiraUsername;
    private String jiraPassword;
    private String jiraPersonalAccessToken;
    private String clientId;
    private String clientSecret;
    private String projectKey;
    private String projectId;
    private String source;
    private Boolean updateRepository = false;
    private Boolean ignoreSslErrors = false;
    private Boolean useInternalTestProxy = false;
    private Integer timeout = 50;

    private XrayFeaturesImporter(ServerDCBuilder builder) {
        this.jiraBaseUrl = builder.jiraBaseUrl;
        this.jiraUsername = builder.jiraUsername;
        this.jiraPassword = builder.jiraPassword;
        this.jiraPersonalAccessToken = builder.jiraPersonalAccessToken;
        this.projectKey = builder.projectKey;
        this.projectId = builder.projectId;
        this.source = builder.source;
        this.updateRepository = builder.updateRepository;
        this.ignoreSslErrors = builder.ignoreSslErrors;
        this.useInternalTestProxy = builder.useInternalTestProxy;
        this.timeout = builder.timeout;
    }

    private XrayFeaturesImporter(CloudBuilder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.projectKey = builder.projectKey;
        this.projectId = builder.projectId;
        this.source = builder.source;
        this.ignoreSslErrors = builder.ignoreSslErrors;
        this.useInternalTestProxy = builder.useInternalTestProxy;
        this.timeout = builder.timeout;
    }

    public JSONArray importFrom(String inputPath) throws Exception {
        if (this.clientId != null) {
            return this.importCloud(inputPath, null, null);
        }
        return this.importServerDC(inputPath, null, null);
    }

    public JSONArray importFrom(String inputPath, JSONObject testInfo) throws Exception {
        if (this.clientId != null) {
            return this.importCloud(inputPath, testInfo, null);
        }
        return this.importServerDC(inputPath, testInfo, null);
    }

    public JSONArray importFrom(String inputPath, JSONObject testInfo, JSONObject precondInfo) throws Exception {
        if (this.clientId != null) {
            return this.importCloud(inputPath, testInfo, precondInfo);
        }
        return this.importServerDC(inputPath, testInfo, precondInfo);
    }

    public JSONArray importServerDC(String inputPath, JSONObject testInfo, JSONObject precondInfo) throws Exception {
        MediaType mediaType;
        OkHttpClient client = CommonUtils.getHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        File inputFile = new File(inputPath);
        String credentials = this.jiraPersonalAccessToken != null ? "Bearer " + this.jiraPersonalAccessToken : Credentials.basic((String)this.jiraUsername, (String)this.jiraPassword);
        String endpointUrl = this.jiraBaseUrl + "/rest/raven/2.0/import/feature";
        Response response = null;
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        MultipartBody requestBody = null;
        if (this.projectKey != null) {
            builder.addQueryParameter("projectKey", this.projectKey);
        }
        if (this.updateRepository != null) {
            builder.addQueryParameter("updateRepository", this.updateRepository.toString());
        }
        if (inputPath.toLowerCase().endsWith(".zip")) {
            mediaType = this.MEDIA_TYPE_ZIP;
        } else if (inputPath.toLowerCase().endsWith(".feature")) {
            mediaType = this.MEDIA_TYPE_FOR_FEATURE_FILES;
        } else {
            mediaType = this.MEDIA_TYPE_ZIP;
            if (inputFile.isDirectory()) {
                Path tempZip = Files.createTempFile("dummy", ".zip", new FileAttribute[0]);
                XrayFeaturesImporter.zipDirectory(inputPath, tempZip.toFile().getAbsolutePath());
                inputFile = tempZip.toFile();
            }
        }
        String partName = "file";
        try {
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(partName, inputFile.getName(), RequestBody.create((File)inputFile, (MediaType)mediaType));
            if (testInfo != null) {
                requestBodyBuilder = requestBodyBuilder.addFormDataPart("testInfo", "testinfo.json", RequestBody.create((String)testInfo.toString(), (MediaType)this.MEDIA_TYPE_JSON));
            }
            if (precondInfo != null) {
                requestBodyBuilder = requestBodyBuilder.addFormDataPart("preCondInfo", "precondinfo.json", RequestBody.create((String)precondInfo.toString(), (MediaType)this.MEDIA_TYPE_JSON));
            }
            requestBody = requestBodyBuilder.build();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        Request request = new Request.Builder().url(builder.build()).post((RequestBody)requestBody).addHeader("Authorization", credentials).build();
        try {
            response = client.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                JSONArray responseObj = new JSONArray(responseBody);
                return responseObj;
            }
            throw new IOException("Unexpected HTTP code " + response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public JSONArray importCloud(String inputPath, JSONObject testInfo, JSONObject precondInfo) throws Exception {
        MediaType mediaType;
        OkHttpClient client = CommonUtils.getHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        File inputFile = new File(inputPath);
        String authenticationPayload = "{ \"client_id\": \"" + this.clientId + "\", \"client_secret\": \"" + this.clientSecret + "\" }";
        RequestBody body = RequestBody.create((String)authenticationPayload, (MediaType)this.MEDIA_TYPE_JSON);
        Request request = new Request.Builder().url("https://xray.cloud.getxray.app/api/v2/authenticate").post(body).build();
        Response response = null;
        String authToken = null;
        try {
            response = client.newCall(request).execute();
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                throw new IOException("failed to authenticate " + response);
            }
            authToken = responseBody.replace("\"", "");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        String credentials = "Bearer " + authToken;
        String endpointUrl = "https://xray.cloud.getxray.app/api/v2/import/feature";
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        MultipartBody requestBody = null;
        if (this.projectKey != null) {
            builder.addQueryParameter("projectKey", this.projectKey);
        }
        if (this.projectId != null) {
            builder.addQueryParameter("projectId", this.projectId);
        }
        if (this.source != null) {
            builder.addQueryParameter("source", this.source);
        }
        if (inputPath.toLowerCase().endsWith(".zip")) {
            mediaType = this.MEDIA_TYPE_ZIP;
        } else if (inputPath.toLowerCase().endsWith(".feature")) {
            mediaType = this.MEDIA_TYPE_FOR_FEATURE_FILES;
        } else {
            mediaType = this.MEDIA_TYPE_ZIP;
            if (inputFile.isDirectory()) {
                Path tempZip = Files.createTempFile("dummy", ".zip", new FileAttribute[0]);
                XrayFeaturesImporter.zipDirectory(inputPath, tempZip.toFile().getAbsolutePath());
                inputFile = tempZip.toFile();
            }
        }
        String partName = "file";
        try {
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(partName, inputFile.getName(), RequestBody.create((File)inputFile, (MediaType)mediaType));
            if (testInfo != null) {
                requestBodyBuilder = requestBodyBuilder.addFormDataPart("testInfo", "testinfo.json", RequestBody.create((String)testInfo.toString(), (MediaType)this.MEDIA_TYPE_JSON));
            }
            if (precondInfo != null) {
                requestBodyBuilder = requestBodyBuilder.addFormDataPart("precondInfo", "precondinfo.json", RequestBody.create((String)precondInfo.toString(), (MediaType)this.MEDIA_TYPE_JSON));
            }
            requestBody = requestBodyBuilder.build();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        request = new Request.Builder().url(builder.build()).post((RequestBody)requestBody).addHeader("Authorization", credentials).build();
        try {
            response = client.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                JSONArray responseObj = new JSONArray();
                responseObj.put((Object)new JSONObject(responseBody));
                return responseObj;
            }
            throw new IOException("Unexpected HTTP code " + response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void zipDirectory(String sourceDir, String outputZip) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputZip);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        File fileToZip = new File(sourceDir);
        XrayFeaturesImporter.zipFile(fileToZip, fileToZip.getName(), zipOut, false);
        zipOut.close();
        fos.close();
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut, boolean createDir) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (createDir) {
                if (fileName.endsWith("/")) {
                    zipOut.putNextEntry(new ZipEntry(fileName));
                } else {
                    zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                }
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                if (!childFile.isDirectory() && !childFile.getName().toLowerCase().endsWith(".feature")) continue;
                if (createDir) {
                    XrayFeaturesImporter.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut, true);
                    continue;
                }
                XrayFeaturesImporter.zipFile(childFile, childFile.getName(), zipOut, true);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    public static class CloudBuilder {
        private final String clientId;
        private final String clientSecret;
        private String projectKey;
        private String projectId;
        private String source;
        private Boolean ignoreSslErrors = false;
        private Boolean useInternalTestProxy = false;
        private Integer timeout = 50;

        public CloudBuilder(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        public CloudBuilder withIgnoreSslErrors(Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        public CloudBuilder withInternalTestProxy(Boolean useInternalTestProxy) {
            this.useInternalTestProxy = useInternalTestProxy;
            return this;
        }

        public CloudBuilder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public CloudBuilder withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public CloudBuilder withProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public CloudBuilder withSource(String source) {
            this.source = source;
            return this;
        }

        public XrayFeaturesImporter build() {
            return new XrayFeaturesImporter(this);
        }
    }

    public static class ServerDCBuilder {
        private final String jiraBaseUrl;
        private String jiraUsername;
        private String jiraPassword;
        private String jiraPersonalAccessToken;
        private String projectKey;
        private String projectId;
        private String source;
        private Boolean updateRepository = false;
        private Boolean ignoreSslErrors = false;
        private Boolean useInternalTestProxy = false;
        private Integer timeout = 50;

        public ServerDCBuilder(String jiraBaseUrl, String jiraUsername, String jiraPassword) {
            this.jiraBaseUrl = jiraBaseUrl;
            this.jiraUsername = jiraUsername;
            this.jiraPassword = jiraPassword;
        }

        public ServerDCBuilder(String jiraBaseUrl, String jiraPersonalAccessToken) {
            this.jiraBaseUrl = jiraBaseUrl;
            this.jiraPersonalAccessToken = jiraPersonalAccessToken;
        }

        public ServerDCBuilder withIgnoreSslErrors(Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        public ServerDCBuilder withInternalTestProxy(Boolean useInternalTestProxy) {
            this.useInternalTestProxy = useInternalTestProxy;
            return this;
        }

        public ServerDCBuilder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public ServerDCBuilder withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public ServerDCBuilder withupdateRepository(Boolean updateRepository) {
            this.updateRepository = updateRepository;
            return this;
        }

        public XrayFeaturesImporter build() {
            return new XrayFeaturesImporter(this);
        }
    }
}

