/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.maven.plugin.xray;

import app.getxray.xray.CommonUtils;
import app.getxray.xray.XrayResultsImporter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.json.JSONObject;

@Mojo(name="import-results", defaultPhase=LifecyclePhase.COMPILE)
public class ImportResultsMojo
extends AbstractMojo {
    @Parameter(property="xray.jiraBaseUrl", required=false)
    private String jiraBaseUrl;
    @Parameter(property="xray.jiraUsername", required=false)
    private String jiraUsername;
    @Parameter(property="xray.jiraPassword", required=false)
    private String jiraPassword;
    @Parameter(property="xray.jiraToken", required=false)
    private String jiraToken;
    @Parameter(property="xray.clientId", required=false)
    private String clientId;
    @Parameter(property="xray.clientSecret", required=false)
    private String clientSecret;
    @Parameter(property="xray.cloud", required=true)
    private Boolean cloud;
    @Parameter(property="xray.reportFile", required=true)
    private String reportFile;
    @Parameter(property="xray.reportFormat", required=true)
    private String reportFormat;
    @Parameter(property="xray.projectKey", required=false)
    private String projectKey;
    @Parameter(property="xray.testPlanKey", required=false)
    private String testPlanKey;
    @Parameter(property="xray.testExecKey", required=false)
    private String testExecKey;
    @Parameter(property="xray.version", required=false)
    private String version;
    @Parameter(property="xray.revision", required=false)
    private String revision;
    @Parameter(property="xray.testEnvironment", required=false)
    private String testEnvironment;
    @Parameter(property="xray.testInfoJson", required=false)
    private String testInfoJson;
    @Parameter(property="xray.testExecInfoJson", required=false)
    private String testExecInfoJson;
    @Parameter(property="xray.abortOnError", required=false)
    private Boolean abortOnError;
    @Parameter(property="xray.useInternalTestProxy", required=false)
    private Boolean useInternalTestProxy;
    @Parameter(property="xray.ignoreSslErrors", required=false)
    private Boolean ignoreSslErrors;
    @Parameter(property="xray.timeout", required=false, defaultValue="50")
    private Integer timeout;
    @Parameter(property="xray.verbose", required=false)
    private Boolean verbose;
    @Parameter(property="scope")
    String scope;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;

    private void abortWithError(String message) {
        this.getLog().error((CharSequence)message);
        System.err.println(message);
        System.exit(1);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        int i;
        DirectoryScanner scanner;
        String[] reportFiles;
        JSONObject testExecInfo = null;
        JSONObject testInfo = null;
        File tempReportFile = new File(this.reportFile);
        if (tempReportFile.isFile()) {
            reportFiles = new String[]{this.reportFile};
        } else if (tempReportFile.isDirectory()) {
            scanner = new DirectoryScanner();
            scanner.setIncludes(new String[]{"*.xml"});
            scanner.setBasedir(this.reportFile);
            scanner.setCaseSensitive(false);
            scanner.scan();
            reportFiles = scanner.getIncludedFiles();
            for (i = 0; i < reportFiles.length; ++i) {
                reportFiles[i] = scanner.getBasedir() + File.separator + reportFiles[i];
                this.getLog().debug((CharSequence)reportFiles[i]);
            }
        } else {
            scanner = new DirectoryScanner();
            scanner.setIncludes(new String[]{this.reportFile});
            scanner.setBasedir(".");
            scanner.setCaseSensitive(false);
            scanner.scan();
            reportFiles = scanner.getIncludedFiles();
            for (i = 0; i < reportFiles.length; ++i) {
                reportFiles[i] = scanner.getBasedir() + File.separator + reportFiles[i];
                this.getLog().debug((CharSequence)reportFiles[i]);
            }
        }
        if (reportFiles.length == 0) {
            this.abortWithError("no test report file(s) found: " + this.reportFile);
        }
        String response = null;
        for (i = 0; i < reportFiles.length; ++i) {
            String reportFile = reportFiles[i];
            try {
                XrayResultsImporter xrayImporter;
                Object xrayImporterBuilder;
                this.getLog().debug((CharSequence)("cloud from config: " + this.cloud));
                this.getLog().debug((CharSequence)("jiraBaseUrl from config: " + this.jiraBaseUrl));
                this.getLog().debug((CharSequence)("reportFile: " + reportFile));
                this.getLog().debug((CharSequence)("testInfoJson from config: " + this.testInfoJson));
                this.getLog().debug((CharSequence)("useInternalTestProxy from config: " + this.useInternalTestProxy));
                if (this.cloud.booleanValue()) {
                    xrayImporterBuilder = new XrayResultsImporter.CloudBuilder(this.clientId, this.clientSecret).withInternalTestProxy(this.useInternalTestProxy).withIgnoreSslErrors(this.ignoreSslErrors).withTimeout(this.timeout).withLogger(this.getLog()).withVerbose(this.verbose);
                    if (this.testInfoJson == null && this.testExecInfoJson == null) {
                        xrayImporter = "xray".equals(this.reportFormat) || "cucumber".equals(this.reportFormat) || "behave".equals(this.reportFormat) ? ((XrayResultsImporter.CloudBuilder)xrayImporterBuilder).build() : ((XrayResultsImporter.CloudBuilder)xrayImporterBuilder).withProjectKey(this.projectKey).withVersion(this.version).withRevision(this.revision).withTestPlanKey(this.testPlanKey).withTestExecKey(this.testExecKey).withTestEnvironment(this.testEnvironment).build();
                        response = xrayImporter.submit(this.reportFormat, reportFile);
                    } else {
                        if (this.testInfoJson != null) {
                            if (new File(this.testInfoJson).isFile()) {
                                testInfo = new JSONObject(new String(Files.readAllBytes(Paths.get(this.testInfoJson, new String[0]))));
                            } else {
                                this.abortWithError("file doesnt exist: " + this.testInfoJson);
                            }
                        } else {
                            testInfo = new JSONObject();
                        }
                        if (this.testExecInfoJson != null) {
                            if (new File(this.testExecInfoJson).isFile()) {
                                testExecInfo = new JSONObject(new String(Files.readAllBytes(Paths.get(this.testExecInfoJson, new String[0]))));
                            } else {
                                this.abortWithError("file doesnt exist: " + this.testExecInfoJson);
                            }
                        } else {
                            testExecInfo = new JSONObject();
                        }
                        response = ((XrayResultsImporter.CloudBuilder)xrayImporterBuilder).build().submitMultipartCloud(this.reportFormat, reportFile, testExecInfo, testInfo);
                    }
                } else {
                    xrayImporterBuilder = this.jiraToken != null ? new XrayResultsImporter.ServerDCBuilder(this.jiraBaseUrl, this.jiraToken).withInternalTestProxy(this.useInternalTestProxy).withIgnoreSslErrors(this.ignoreSslErrors).withTimeout(this.timeout).withLogger(this.getLog()).withVerbose(this.verbose) : new XrayResultsImporter.ServerDCBuilder(this.jiraBaseUrl, this.jiraUsername, this.jiraPassword).withInternalTestProxy(this.useInternalTestProxy).withIgnoreSslErrors(this.ignoreSslErrors).withTimeout(this.timeout).withLogger(this.getLog()).withVerbose(this.verbose);
                    if (this.testInfoJson == null && this.testExecInfoJson == null) {
                        xrayImporter = "xray".equals(this.reportFormat) || "cucumber".equals(this.reportFormat) || "behave".equals(this.reportFormat) ? ((XrayResultsImporter.ServerDCBuilder)xrayImporterBuilder).build() : ((XrayResultsImporter.ServerDCBuilder)xrayImporterBuilder).withProjectKey(this.projectKey).withVersion(this.version).withRevision(this.revision).withTestPlanKey(this.testPlanKey).withTestExecKey(this.testExecKey).withTestEnvironment(this.testEnvironment).build();
                        response = xrayImporter.submit(this.reportFormat, reportFile);
                    } else {
                        if (this.testInfoJson != null) {
                            if (new File(this.testInfoJson).isFile()) {
                                testInfo = new JSONObject(new String(Files.readAllBytes(Paths.get(this.testInfoJson, new String[0]))));
                            } else {
                                this.abortWithError("file doesnt exist: " + this.testInfoJson);
                            }
                        } else {
                            testInfo = new JSONObject();
                        }
                        if (this.testExecInfoJson != null) {
                            if (new File(this.testExecInfoJson).isFile()) {
                                testExecInfo = new JSONObject(new String(Files.readAllBytes(Paths.get(this.testExecInfoJson, new String[0]))));
                            } else {
                                this.abortWithError("file doesnt exist: " + this.testExecInfoJson);
                            }
                        } else {
                            testExecInfo = new JSONObject();
                        }
                        response = ((XrayResultsImporter.ServerDCBuilder)xrayImporterBuilder).build().submitMultipartServerDC(this.reportFormat, reportFile, testExecInfo, testInfo);
                    }
                }
                this.getLog().info((CharSequence)("response: " + response));
                continue;
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)ex.getMessage());
                ex.printStackTrace();
                if (!CommonUtils.isTrue(this.abortOnError)) continue;
                System.exit(1);
            }
        }
    }
}

