/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.maven.plugin.logging.Log;

public class CommonUtils {
    public static void logRequest(Log logger, Request request) {
        if (logger != null) {
            logger.debug((CharSequence)("REQUEST_URL: " + request.url().toString()));
            logger.debug((CharSequence)("REQUEST_METHOD: " + request.method()));
            Request copy = request.newBuilder().build();
            RequestBody body = copy.body();
            if (body != null) {
                logger.debug((CharSequence)("REQUEST_CONTENT_TYPE: " + body.contentType().toString()));
            }
        }
    }

    public static void logResponse(Log logger, Response response) {
        CommonUtils.logResponse(logger, response, true);
    }

    public static void logResponse(Log logger, Response response, boolean logBody) {
        if (logger != null) {
            logger.debug((CharSequence)("RESPONSE_CONTENT_TYPE:" + response.header("Content-Type")));
            logger.debug((CharSequence)("RESPONSE_HTTP_STATUS: " + response.code()));
            if (logBody) {
                logger.debug((CharSequence)"RESPONSE_BODY:");
                logger.debug((CharSequence)"=======================");
                try (ResponseBody responseBody = response.peekBody(0x100000L);){
                    logger.debug((CharSequence)responseBody.string());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isTrue(Boolean bool) {
        return bool != null && bool != false;
    }

    public static OkHttpClient getHttpClient(Boolean useInternalTestProxy, Boolean ignoreSslErrors, Integer timeout) throws Exception {
        OkHttpClient client;
        OkHttpClient.Builder newBuilder = new OkHttpClient.Builder();
        if (CommonUtils.isTrue(ignoreSslErrors) || CommonUtils.isTrue(useInternalTestProxy)) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            newBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]);
            newBuilder.hostnameVerifier((host, session) -> true);
        }
        if (CommonUtils.isTrue(useInternalTestProxy)) {
            String hostname = "localhost";
            int port = 18080;
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
            client = newBuilder.connectTimeout((long)timeout.intValue(), TimeUnit.SECONDS).readTimeout((long)timeout.intValue(), TimeUnit.SECONDS).writeTimeout((long)timeout.intValue(), TimeUnit.SECONDS).callTimeout((long)timeout.intValue(), TimeUnit.SECONDS).proxy(proxy).build();
        } else {
            client = newBuilder.connectTimeout((long)timeout.intValue(), TimeUnit.SECONDS).readTimeout((long)timeout.intValue(), TimeUnit.SECONDS).writeTimeout((long)timeout.intValue(), TimeUnit.SECONDS).callTimeout((long)timeout.intValue(), TimeUnit.SECONDS).build();
        }
        return client;
    }
}

