/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray;

import app.getxray.xray.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.maven.plugin.logging.Log;
import org.json.JSONObject;

public class XrayResultsImporter {
    private final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    private final MediaType MEDIA_TYPE_XML = MediaType.parse((String)"application/xml");
    private final String xrayCloudApiBaseUrl = "https://xray.cloud.getxray.app/api/v2";
    private final String xrayCloudAuthenticateUrl = "https://xray.cloud.getxray.app/api/v2/authenticate";
    public static final String XRAY_FORMAT = "xray";
    public static final String JUNIT_FORMAT = "junit";
    public static final String TESTNG_FORMAT = "testng";
    public static final String ROBOT_FORMAT = "robot";
    public static final String XUNIT_FORMAT = "xunit";
    public static final String NUNIT_FORMAT = "nunit";
    public static final String CUCUMBER_FORMAT = "cucumber";
    public static final String BEHAVE_FORMAT = "behave";
    private String jiraBaseUrl;
    private String jiraUsername;
    private String jiraPassword;
    private String jiraPersonalAccessToken;
    private String clientId;
    private String clientSecret;
    private String projectKey;
    private String fixVersion;
    private String revision;
    private String testPlanKey;
    private String testExecKey;
    private String testEnvironment;
    private Boolean ignoreSslErrors = false;
    private Boolean useInternalTestProxy = false;
    private Integer timeout = 50;
    private Boolean verbose = false;
    private Log logger;

    private XrayResultsImporter(ServerDCBuilder builder) {
        this.jiraBaseUrl = builder.jiraBaseUrl;
        this.jiraUsername = builder.jiraUsername;
        this.jiraPassword = builder.jiraPassword;
        this.jiraPersonalAccessToken = builder.jiraPersonalAccessToken;
        this.projectKey = builder.projectKey;
        this.fixVersion = builder.fixVersion;
        this.revision = builder.revision;
        this.testPlanKey = builder.testPlanKey;
        this.testExecKey = builder.testExecKey;
        this.testEnvironment = builder.testEnvironment;
        this.ignoreSslErrors = builder.ignoreSslErrors;
        this.useInternalTestProxy = builder.useInternalTestProxy;
        this.timeout = builder.timeout;
        this.verbose = builder.verbose;
        this.logger = builder.logger;
    }

    private XrayResultsImporter(CloudBuilder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.projectKey = builder.projectKey;
        this.fixVersion = builder.fixVersion;
        this.revision = builder.revision;
        this.testPlanKey = builder.testPlanKey;
        this.testExecKey = builder.testExecKey;
        this.testEnvironment = builder.testEnvironment;
        this.ignoreSslErrors = builder.ignoreSslErrors;
        this.useInternalTestProxy = builder.useInternalTestProxy;
        this.timeout = builder.timeout;
        this.verbose = builder.verbose;
        this.logger = builder.logger;
    }

    public String submit(String format, String reportFile) throws Exception {
        if (this.clientId != null) {
            return this.submitStandardCloud(format, reportFile);
        }
        return this.submitStandardServerDC(format, reportFile);
    }

    public String submitMultipartServerDC(String format, String reportFile, JSONObject testExecInfo, JSONObject testInfo) throws Exception {
        OkHttpClient client = CommonUtils.getHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String credentials = this.jiraPersonalAccessToken != null ? "Bearer " + this.jiraPersonalAccessToken : Credentials.basic((String)this.jiraUsername, (String)this.jiraPassword);
        String[] supportedFormats = new String[]{XRAY_FORMAT, JUNIT_FORMAT, TESTNG_FORMAT, ROBOT_FORMAT, NUNIT_FORMAT, XUNIT_FORMAT, CUCUMBER_FORMAT, BEHAVE_FORMAT};
        if (!Arrays.asList(supportedFormats).contains(format)) {
            throw new Exception("unsupported report format: " + format);
        }
        String[] xmlBasedFormats = new String[]{JUNIT_FORMAT, TESTNG_FORMAT, ROBOT_FORMAT, NUNIT_FORMAT, XUNIT_FORMAT};
        MediaType mediaType = Arrays.asList(xmlBasedFormats).contains(format) ? this.MEDIA_TYPE_XML : this.MEDIA_TYPE_JSON;
        String endpointUrl = XRAY_FORMAT.equals(format) ? this.jiraBaseUrl + "/rest/raven/2.0/import/execution/multipart" : this.jiraBaseUrl + "/rest/raven/2.0/import/execution/" + format + "/multipart";
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        MultipartBody requestBody = null;
        String partName = XRAY_FORMAT.equals(format) || CUCUMBER_FORMAT.equals(format) || BEHAVE_FORMAT.equals(format) ? "result" : "file";
        try {
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(partName, reportFile, RequestBody.create((File)new File(reportFile), (MediaType)mediaType)).addFormDataPart("info", "info.json", RequestBody.create((String)testExecInfo.toString(), (MediaType)this.MEDIA_TYPE_JSON));
            if (testInfo != null) {
                requestBodyBuilder.addFormDataPart("testInfo", "testInfo.json", RequestBody.create((String)testInfo.toString(), (MediaType)this.MEDIA_TYPE_JSON));
            }
            requestBody = requestBodyBuilder.build();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        Request request = new Request.Builder().url(builder.build()).post((RequestBody)requestBody).addHeader("Authorization", credentials).build();
        CommonUtils.logRequest(this.logger, request);
        Response response = null;
        try {
            response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response);
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                JSONObject responseObj = new JSONObject(responseBody);
                return responseBody;
            }
            throw new IOException("Unexpected HTTP code " + response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String submitMultipartCloud(String format, String reportFile, JSONObject testExecInfo, JSONObject testInfo) throws Exception {
        OkHttpClient client = CommonUtils.getHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String authenticationPayload = "{ \"client_id\": \"" + this.clientId + "\", \"client_secret\": \"" + this.clientSecret + "\" }";
        RequestBody body = RequestBody.create((String)authenticationPayload, (MediaType)this.MEDIA_TYPE_JSON);
        Request request = new Request.Builder().url("https://xray.cloud.getxray.app/api/v2/authenticate").post(body).build();
        CommonUtils.logRequest(this.logger, request);
        Response response = null;
        String authToken = null;
        try {
            response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response, false);
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                throw new IOException("failed to authenticate " + response);
            }
            authToken = responseBody.replace("\"", "");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        String credentials = "Bearer " + authToken;
        String[] supportedFormats = new String[]{XRAY_FORMAT, JUNIT_FORMAT, TESTNG_FORMAT, ROBOT_FORMAT, NUNIT_FORMAT, XUNIT_FORMAT, CUCUMBER_FORMAT, BEHAVE_FORMAT};
        if (!Arrays.asList(supportedFormats).contains(format)) {
            throw new Exception("unsupported report format: " + format);
        }
        String[] xmlBasedFormats = new String[]{JUNIT_FORMAT, TESTNG_FORMAT, ROBOT_FORMAT, NUNIT_FORMAT, XUNIT_FORMAT};
        MediaType mediaType = Arrays.asList(xmlBasedFormats).contains(format) ? this.MEDIA_TYPE_XML : this.MEDIA_TYPE_JSON;
        String endpointUrl = XRAY_FORMAT.equals(format) ? "https://xray.cloud.getxray.app/api/v2/import/execution/multipart" : "https://xray.cloud.getxray.app/api/v2/import/execution/" + format + "/multipart";
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        MultipartBody requestBody = null;
        try {
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("results", reportFile, RequestBody.create((File)new File(reportFile), (MediaType)mediaType)).addFormDataPart("info", "info.json", RequestBody.create((String)testExecInfo.toString(), (MediaType)this.MEDIA_TYPE_JSON));
            if (testInfo != null) {
                requestBodyBuilder.addFormDataPart("testInfo", "testInfo.json", RequestBody.create((String)testInfo.toString(), (MediaType)this.MEDIA_TYPE_JSON));
            }
            requestBody = requestBodyBuilder.build();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        request = new Request.Builder().url(builder.build()).post((RequestBody)requestBody).addHeader("Authorization", credentials).build();
        CommonUtils.logRequest(this.logger, request);
        response = null;
        try {
            response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response);
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                JSONObject responseObj = new JSONObject(responseBody);
                return responseBody;
            }
            throw new IOException("Unexpected HTTP code " + response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String submitStandardServerDC(String format, String reportFile) throws Exception {
        Request request;
        OkHttpClient client = CommonUtils.getHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String credentials = this.jiraPersonalAccessToken != null ? "Bearer " + this.jiraPersonalAccessToken : Credentials.basic((String)this.jiraUsername, (String)this.jiraPassword);
        String[] supportedFormats = new String[]{XRAY_FORMAT, JUNIT_FORMAT, TESTNG_FORMAT, ROBOT_FORMAT, NUNIT_FORMAT, XUNIT_FORMAT, CUCUMBER_FORMAT, BEHAVE_FORMAT};
        if (!Arrays.asList(supportedFormats).contains(format)) {
            throw new Exception("unsupported report format: " + format);
        }
        String[] xmlBasedFormats = new String[]{JUNIT_FORMAT, TESTNG_FORMAT, ROBOT_FORMAT, NUNIT_FORMAT, XUNIT_FORMAT};
        MediaType mediaType = Arrays.asList(xmlBasedFormats).contains(format) ? this.MEDIA_TYPE_XML : this.MEDIA_TYPE_JSON;
        String endpointUrl = XRAY_FORMAT.equals(format) ? this.jiraBaseUrl + "/rest/raven/2.0/import/execution" : this.jiraBaseUrl + "/rest/raven/2.0/import/execution/" + format;
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        try {
            if (XRAY_FORMAT.equals(format) || CUCUMBER_FORMAT.equals(format) || BEHAVE_FORMAT.equals(format)) {
                String reportContent = new String(Files.readAllBytes(Paths.get(reportFile, new String[0])));
                RequestBody requestBody = RequestBody.create((String)reportContent, (MediaType)mediaType);
                request = new Request.Builder().url(builder.build()).post(requestBody).addHeader("Authorization", credentials).build();
            } else {
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", reportFile, RequestBody.create((File)new File(reportFile), (MediaType)mediaType)).build();
                if (this.projectKey != null) {
                    builder.addQueryParameter("projectKey", this.projectKey);
                }
                if (this.fixVersion != null) {
                    builder.addQueryParameter("fixVersion", this.fixVersion);
                }
                if (this.revision != null) {
                    builder.addQueryParameter("revision", this.revision);
                }
                if (this.testPlanKey != null) {
                    builder.addQueryParameter("testPlanKey", this.testPlanKey);
                }
                if (this.testExecKey != null) {
                    builder.addQueryParameter("testExecKey", this.testExecKey);
                }
                if (this.testEnvironment != null) {
                    builder.addQueryParameter("testEnvironments", this.testEnvironment);
                }
                request = new Request.Builder().url(builder.build()).post((RequestBody)requestBody).addHeader("Authorization", credentials).build();
            }
            CommonUtils.logRequest(this.logger, request);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        Response response = null;
        try {
            response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response);
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                JSONObject responseObj = new JSONObject(responseBody);
                return responseBody;
            }
            throw new IOException("Unexpected HTTP code " + response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String submitStandardCloud(String format, String reportFile) throws Exception {
        OkHttpClient client = CommonUtils.getHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String authenticationPayload = "{ \"client_id\": \"" + this.clientId + "\", \"client_secret\": \"" + this.clientSecret + "\" }";
        RequestBody body = RequestBody.create((String)authenticationPayload, (MediaType)this.MEDIA_TYPE_JSON);
        Request request = new Request.Builder().url("https://xray.cloud.getxray.app/api/v2/authenticate").post(body).build();
        CommonUtils.logRequest(this.logger, request);
        Response response = null;
        String authToken = null;
        try {
            response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response, false);
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                throw new IOException("failed to authenticate " + response);
            }
            authToken = responseBody.replace("\"", "");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        String credentials = "Bearer " + authToken;
        String[] supportedFormats = new String[]{XRAY_FORMAT, JUNIT_FORMAT, TESTNG_FORMAT, ROBOT_FORMAT, NUNIT_FORMAT, XUNIT_FORMAT, CUCUMBER_FORMAT, BEHAVE_FORMAT};
        if (!Arrays.asList(supportedFormats).contains(format)) {
            throw new Exception("unsupported report format: " + format);
        }
        String[] xmlBasedFormats = new String[]{JUNIT_FORMAT, TESTNG_FORMAT, ROBOT_FORMAT, NUNIT_FORMAT, XUNIT_FORMAT};
        MediaType mediaType = Arrays.asList(xmlBasedFormats).contains(format) ? this.MEDIA_TYPE_XML : this.MEDIA_TYPE_JSON;
        String endpointUrl = XRAY_FORMAT.equals(format) ? "https://xray.cloud.getxray.app/api/v2/import/execution" : "https://xray.cloud.getxray.app/api/v2/import/execution/" + format;
        RequestBody requestBody = null;
        try {
            String reportContent = new String(Files.readAllBytes(Paths.get(reportFile, new String[0])));
            requestBody = RequestBody.create((String)reportContent, (MediaType)mediaType);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        if (this.projectKey != null) {
            builder.addQueryParameter("projectKey", this.projectKey);
        }
        if (this.fixVersion != null) {
            builder.addQueryParameter("fixVersion", this.fixVersion);
        }
        if (this.revision != null) {
            builder.addQueryParameter("revision", this.revision);
        }
        if (this.testPlanKey != null) {
            builder.addQueryParameter("testPlanKey", this.testPlanKey);
        }
        if (this.testExecKey != null) {
            builder.addQueryParameter("testExecKey", this.testExecKey);
        }
        if (this.testEnvironment != null) {
            builder.addQueryParameter("testEnvironments", this.testEnvironment);
        }
        request = new Request.Builder().url(builder.build()).post(requestBody).addHeader("Authorization", credentials).build();
        CommonUtils.logRequest(this.logger, request);
        try {
            response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response);
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                JSONObject responseObj = new JSONObject(responseBody);
                return responseBody;
            }
            throw new IOException("Unexpected HTTP code " + response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static class CloudBuilder {
        private final String clientId;
        private final String clientSecret;
        private String projectKey;
        private String fixVersion;
        private String revision;
        private String testPlanKey;
        private String testExecKey;
        private String testEnvironment;
        private Boolean ignoreSslErrors = false;
        private Boolean useInternalTestProxy = false;
        private Integer timeout = 50;
        private Boolean verbose = false;
        private Log logger;

        public CloudBuilder(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        public CloudBuilder withIgnoreSslErrors(Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        public CloudBuilder withInternalTestProxy(Boolean useInternalTestProxy) {
            this.useInternalTestProxy = useInternalTestProxy;
            return this;
        }

        public CloudBuilder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public CloudBuilder withVerbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public CloudBuilder withLogger(Log logger) {
            this.logger = logger;
            return this;
        }

        public CloudBuilder withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public CloudBuilder withVersion(String fixVersion) {
            this.fixVersion = fixVersion;
            return this;
        }

        public CloudBuilder withRevision(String revision) {
            this.revision = revision;
            return this;
        }

        public CloudBuilder withTestPlanKey(String testPlanKey) {
            this.testPlanKey = testPlanKey;
            return this;
        }

        public CloudBuilder withTestExecKey(String testExecKey) {
            this.testExecKey = testExecKey;
            return this;
        }

        public CloudBuilder withTestEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public XrayResultsImporter build() {
            return new XrayResultsImporter(this);
        }
    }

    public static class ServerDCBuilder {
        private final String jiraBaseUrl;
        private String jiraUsername;
        private String jiraPassword;
        private String jiraPersonalAccessToken;
        private String projectKey;
        private String fixVersion;
        private String revision;
        private String testPlanKey;
        private String testExecKey;
        private String testEnvironment;
        private Boolean ignoreSslErrors = false;
        private Boolean useInternalTestProxy = false;
        private Integer timeout = 50;
        private Boolean verbose = false;
        private Log logger;

        public ServerDCBuilder(String jiraBaseUrl, String jiraUsername, String jiraPassword) {
            this.jiraBaseUrl = jiraBaseUrl;
            this.jiraUsername = jiraUsername;
            this.jiraPassword = jiraPassword;
        }

        public ServerDCBuilder(String jiraBaseUrl, String jiraPersonalAccessToken) {
            this.jiraBaseUrl = jiraBaseUrl;
            this.jiraPersonalAccessToken = jiraPersonalAccessToken;
        }

        public ServerDCBuilder withIgnoreSslErrors(Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        public ServerDCBuilder withInternalTestProxy(Boolean useInternalTestProxy) {
            this.useInternalTestProxy = useInternalTestProxy;
            return this;
        }

        public ServerDCBuilder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public ServerDCBuilder withVerbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public ServerDCBuilder withLogger(Log logger) {
            this.logger = logger;
            return this;
        }

        public ServerDCBuilder withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public ServerDCBuilder withVersion(String fixVersion) {
            this.fixVersion = fixVersion;
            return this;
        }

        public ServerDCBuilder withRevision(String revision) {
            this.revision = revision;
            return this;
        }

        public ServerDCBuilder withTestPlanKey(String testPlanKey) {
            this.testPlanKey = testPlanKey;
            return this;
        }

        public ServerDCBuilder withTestExecKey(String testExecKey) {
            this.testExecKey = testExecKey;
            return this;
        }

        public ServerDCBuilder withTestEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public XrayResultsImporter build() {
            return new XrayResultsImporter(this);
        }
    }
}

