/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.maven.plugin.xray;

import app.getxray.xray.XrayFeaturesImporter;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.json.JSONArray;
import org.json.JSONObject;

@Mojo(name="import-features", defaultPhase=LifecyclePhase.COMPILE)
public class ImportFeaturesMojo
extends AbstractMojo {
    @Parameter(property="xray.jiraBaseUrl", required=false)
    private String jiraBaseUrl;
    @Parameter(property="xray.jiraUsername", required=false)
    private String jiraUsername;
    @Parameter(property="xray.jiraPassword", required=false)
    private String jiraPassword;
    @Parameter(property="xray.jiraToken", required=false)
    private String jiraToken;
    @Parameter(property="xray.clientId", required=false)
    private String clientId;
    @Parameter(property="xray.clientSecret", required=false)
    private String clientSecret;
    @Parameter(property="xray.cloud", required=true, defaultValue="false")
    private Boolean cloud;
    @Parameter(property="xray.projectKey", required=false)
    private String projectKey;
    @Parameter(property="xray.projectId", required=false)
    private String projectId;
    @Parameter(property="xray.source", required=false)
    private String source;
    @Parameter(property="xray.testInfoJson", required=false)
    private String testInfoJson;
    @Parameter(property="xray.precondInfoJson", required=false)
    private String precondInfoJson;
    @Parameter(property="xray.inputFeatures", required=false)
    private String inputFeatures;
    @Parameter(property="xray.updateRepository", required=false, defaultValue="false")
    private Boolean updateRepository;
    @Parameter(property="xray.abortOnError", required=false, defaultValue="true")
    private Boolean abortOnError;
    @Parameter(property="xray.useInternalTestProxy", required=false, defaultValue="false")
    private Boolean useInternalTestProxy;
    @Parameter(property="xray.ignoreSslErrors", required=false, defaultValue="false")
    private Boolean ignoreSslErrors;
    @Parameter(property="xray.timeout", required=false, defaultValue="50")
    private Integer timeout;
    @Parameter(property="xray.verbose", required=false, defaultValue="false")
    private Boolean verbose;
    @Parameter(property="scope")
    String scope;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block6: {
            JSONObject testInfo = null;
            JSONObject precondInfo = null;
            JSONArray response = null;
            try {
                this.getLog().debug((CharSequence)("cloud from config: " + this.cloud));
                this.getLog().debug((CharSequence)("projectKey from config: " + this.projectKey));
                this.getLog().debug((CharSequence)("projectId from config: " + this.projectId));
                this.getLog().debug((CharSequence)("source from config: " + this.source));
                this.getLog().debug((CharSequence)("inputFeatures from config: " + this.inputFeatures));
                this.getLog().debug((CharSequence)("updateRepository from config: " + this.updateRepository));
                if (this.testInfoJson != null) {
                    testInfo = new JSONObject(new String(Files.readAllBytes(Paths.get(this.testInfoJson, new String[0]))));
                }
                if (this.precondInfoJson != null) {
                    precondInfo = new JSONObject(new String(Files.readAllBytes(Paths.get(this.precondInfoJson, new String[0]))));
                }
                if (this.cloud.booleanValue()) {
                    XrayFeaturesImporter xrayFeaturesImporter = new XrayFeaturesImporter.CloudBuilder(this.clientId, this.clientSecret).withInternalTestProxy(this.useInternalTestProxy).withIgnoreSslErrors(this.ignoreSslErrors).withTimeout(this.timeout).withLogger(this.getLog()).withVerbose(this.verbose).withProjectKey(this.projectKey).withProjectId(this.projectId).withSource(this.source).build();
                    response = xrayFeaturesImporter.importFrom(this.inputFeatures, testInfo, precondInfo);
                } else {
                    XrayFeaturesImporter xrayFeaturesImporter = this.jiraToken != null ? new XrayFeaturesImporter.ServerDCBuilder(this.jiraBaseUrl, this.jiraToken).withInternalTestProxy(this.useInternalTestProxy).withIgnoreSslErrors(this.ignoreSslErrors).withTimeout(this.timeout).withLogger(this.getLog()).withVerbose(this.verbose).withProjectKey(this.projectKey).withupdateRepository(this.updateRepository).build() : new XrayFeaturesImporter.ServerDCBuilder(this.jiraBaseUrl, this.jiraUsername, this.jiraPassword).withInternalTestProxy(this.useInternalTestProxy).withIgnoreSslErrors(this.ignoreSslErrors).withTimeout(this.timeout).withLogger(this.getLog()).withVerbose(this.verbose).withProjectKey(this.projectKey).withupdateRepository(this.updateRepository).build();
                    response = xrayFeaturesImporter.importFrom(this.inputFeatures, testInfo, precondInfo);
                }
                this.getLog().info((CharSequence)("response: " + response));
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)ex.getMessage());
                if (!this.abortOnError.booleanValue()) break block6;
                System.exit(1);
            }
        }
    }
}

