/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray;

import app.getxray.xray.CommonUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.maven.plugin.logging.Log;

public class XrayFeaturesExporter {
    private final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    private final String xrayCloudApiBaseUrl = "https://xray.cloud.getxray.app/api/v2";
    private final String xrayCloudAuthenticateUrl = "https://xray.cloud.getxray.app/api/v2/authenticate";
    private String jiraBaseUrl;
    private String jiraUsername;
    private String jiraPassword;
    private String jiraPersonalAccessToken;
    private String clientId;
    private String clientSecret;
    private String issueKeys;
    private String filterId;
    private Boolean ignoreSslErrors = false;
    private Boolean useInternalTestProxy = false;
    private Integer timeout = 50;
    private Boolean verbose = false;
    private Log logger;

    private XrayFeaturesExporter(ServerDCBuilder builder) {
        this.jiraBaseUrl = builder.jiraBaseUrl;
        this.jiraUsername = builder.jiraUsername;
        this.jiraPassword = builder.jiraPassword;
        this.jiraPersonalAccessToken = builder.jiraPersonalAccessToken;
        this.issueKeys = builder.issueKeys;
        this.filterId = builder.filterId;
        this.ignoreSslErrors = builder.ignoreSslErrors;
        this.useInternalTestProxy = builder.useInternalTestProxy;
        this.timeout = builder.timeout;
        this.verbose = builder.verbose;
        this.logger = builder.logger;
    }

    private XrayFeaturesExporter(CloudBuilder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.issueKeys = builder.issueKeys;
        this.filterId = builder.filterId;
        this.ignoreSslErrors = builder.ignoreSslErrors;
        this.useInternalTestProxy = builder.useInternalTestProxy;
        this.timeout = builder.timeout;
        this.verbose = builder.verbose;
        this.logger = builder.logger;
    }

    public String submit(String outputPath) throws Exception {
        if (this.clientId != null) {
            return this.submitStandardCloud(outputPath);
        }
        return this.submitStandardServerDC(outputPath);
    }

    public String submitStandardServerDC(String outputPath) throws Exception {
        OkHttpClient client = CommonUtils.getHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String credentials = this.jiraPersonalAccessToken != null ? "Bearer " + this.jiraPersonalAccessToken : Credentials.basic((String)this.jiraUsername, (String)this.jiraPassword);
        String endpointUrl = this.jiraBaseUrl + "/rest/raven/2.0/export/test";
        Response response = null;
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        builder.addQueryParameter("fz", "true");
        if (this.issueKeys != null) {
            builder.addQueryParameter("keys", this.issueKeys);
        }
        if (this.filterId != null) {
            builder.addQueryParameter("filter", this.filterId);
        }
        Request request = new Request.Builder().url(builder.build()).get().addHeader("Authorization", credentials).build();
        CommonUtils.logRequest(this.logger, request);
        try {
            response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response);
            if (response.isSuccessful()) {
                this.unzipContentsToFolder(response.body().byteStream(), outputPath);
                return "ok";
            }
            throw new IOException("Unexpected HTTP code " + response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String submitStandardCloud(String outputPath) throws Exception {
        OkHttpClient client = CommonUtils.getHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String authenticationPayload = "{ \"client_id\": \"" + this.clientId + "\", \"client_secret\": \"" + this.clientSecret + "\" }";
        RequestBody body = RequestBody.create((String)authenticationPayload, (MediaType)this.MEDIA_TYPE_JSON);
        Request request = new Request.Builder().url("https://xray.cloud.getxray.app/api/v2/authenticate").post(body).build();
        CommonUtils.logRequest(this.logger, request);
        Response response = null;
        String authToken = null;
        try {
            response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response, false);
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                throw new IOException("failed to authenticate " + response);
            }
            authToken = responseBody.replace("\"", "");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        String credentials = "Bearer " + authToken;
        String endpointUrl = "https://xray.cloud.getxray.app/api/v2/export/cucumber";
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        if (this.issueKeys != null) {
            builder.addQueryParameter("keys", this.issueKeys);
        }
        if (this.filterId != null) {
            builder.addQueryParameter("filter", this.filterId);
        }
        request = new Request.Builder().url(builder.build()).get().addHeader("Authorization", credentials).build();
        CommonUtils.logRequest(this.logger, request);
        try {
            response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response);
            if (response.isSuccessful()) {
                this.unzipContentsToFolder(response.body().byteStream(), outputPath);
                return "ok";
            }
            throw new IOException("Unexpected HTTP code " + response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void unzipContentsToFolder(InputStream zippedContents, String outputFolder) throws Exception {
        ZipEntry zipEntry;
        File destDir = new File(outputFolder);
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(zippedContents));
        while ((zipEntry = zis.getNextEntry()) != null) {
            File newFile = XrayFeaturesExporter.newFile(destDir, zipEntry);
            if (zipEntry.isDirectory()) {
                if (newFile.isDirectory() || newFile.mkdirs()) continue;
                throw new IOException("Failed to create directory " + newFile);
            }
            File parent = newFile.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("Failed to create directory " + parent);
            }
            try (FileOutputStream fos = new FileOutputStream(newFile);){
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
            }
        }
        zis.closeEntry();
        zis.close();
    }

    private static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    public static class CloudBuilder {
        private final String clientId;
        private final String clientSecret;
        private String issueKeys;
        private String filterId;
        private Boolean ignoreSslErrors = false;
        private Boolean useInternalTestProxy = false;
        private Integer timeout = 50;
        private Boolean verbose = false;
        private Log logger;

        public CloudBuilder(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        public CloudBuilder withInternalTestProxy(Boolean useInternalTestProxy) {
            this.useInternalTestProxy = useInternalTestProxy;
            return this;
        }

        public CloudBuilder withIgnoreSslErrors(Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        public CloudBuilder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public CloudBuilder withVerbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public CloudBuilder withLogger(Log logger) {
            this.logger = logger;
            return this;
        }

        public CloudBuilder withIssueKeys(String issueKeys) {
            this.issueKeys = issueKeys;
            return this;
        }

        public CloudBuilder withFilterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public XrayFeaturesExporter build() {
            return new XrayFeaturesExporter(this);
        }
    }

    public static class ServerDCBuilder {
        private final String jiraBaseUrl;
        private String jiraUsername;
        private String jiraPassword;
        private String jiraPersonalAccessToken;
        private String issueKeys;
        private String filterId;
        private Boolean useInternalTestProxy = false;
        private Boolean ignoreSslErrors = false;
        private Integer timeout = 50;
        private Boolean verbose = false;
        private Log logger;

        public ServerDCBuilder(String jiraBaseUrl, String jiraUsername, String jiraPassword) {
            this.jiraBaseUrl = jiraBaseUrl;
            this.jiraUsername = jiraUsername;
            this.jiraPassword = jiraPassword;
        }

        public ServerDCBuilder(String jiraBaseUrl, String jiraPersonalAccessToken) {
            this.jiraBaseUrl = jiraBaseUrl;
            this.jiraPersonalAccessToken = jiraPersonalAccessToken;
        }

        public ServerDCBuilder withInternalTestProxy(Boolean useInternalTestProxy) {
            this.useInternalTestProxy = useInternalTestProxy;
            return this;
        }

        public ServerDCBuilder withIgnoreSslErrors(Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        public ServerDCBuilder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public ServerDCBuilder withVerbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public ServerDCBuilder withLogger(Log logger) {
            this.logger = logger;
            return this;
        }

        public ServerDCBuilder withIssueKeys(String issueKeys) {
            this.issueKeys = issueKeys;
            return this;
        }

        public ServerDCBuilder withFilterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public XrayFeaturesExporter build() {
            return new XrayFeaturesExporter(this);
        }
    }
}

