/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.maven.plugin.xray;

import app.getxray.xray.CommonUtils;
import app.getxray.xray.XrayFeaturesExporter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="export-features", defaultPhase=LifecyclePhase.COMPILE)
public class ExportFeaturesMojo
extends AbstractMojo {
    @Parameter(property="xray.jiraBaseUrl", required=false)
    private String jiraBaseUrl;
    @Parameter(property="xray.jiraUsername", required=false)
    private String jiraUsername;
    @Parameter(property="xray.jiraPassword", required=false)
    private String jiraPassword;
    @Parameter(property="xray.jiraToken", required=false)
    private String jiraToken;
    @Parameter(property="xray.clientId", required=false)
    private String clientId;
    @Parameter(property="xray.clientSecret", required=false)
    private String clientSecret;
    @Parameter(property="xray.cloudApiBaseUrl", required=false, defaultValue="https://xray.cloud.getxray.app/api/v2")
    private String cloudApiBaseUrl;
    @Parameter(property="xray.cloud", required=true, defaultValue="false")
    private Boolean cloud;
    @Parameter(property="xray.issueKeys", required=false)
    private String issueKeys;
    @Parameter(property="xray.filterId", required=false)
    private String filterId;
    @Parameter(property="xray.outputDir", required=false)
    private String outputDir;
    @Parameter(property="xray.abortOnError", required=false, defaultValue="true")
    private Boolean abortOnError;
    @Parameter(property="xray.useInternalTestProxy", required=false, defaultValue="false")
    private Boolean useInternalTestProxy;
    @Parameter(property="xray.ignoreSslErrors", required=false, defaultValue="false")
    private Boolean ignoreSslErrors;
    @Parameter(property="xray.timeout", required=false, defaultValue="50")
    private Integer timeout;
    @Parameter(property="xray.verbose", required=false, defaultValue="false")
    private Boolean verbose;
    @Parameter(property="scope")
    String scope;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block4: {
            String response = null;
            try {
                this.getLog().debug((CharSequence)("cloud from config: " + this.cloud));
                this.getLog().debug((CharSequence)("issueKeys from config: " + this.issueKeys));
                this.getLog().debug((CharSequence)("filterId from config: " + this.filterId));
                if (CommonUtils.isTrue(this.cloud)) {
                    XrayFeaturesExporter xrayFeaturesExporter = new XrayFeaturesExporter.CloudBuilder(this.clientId, this.clientSecret, this.cloudApiBaseUrl).withInternalTestProxy(this.useInternalTestProxy).withIgnoreSslErrors(this.ignoreSslErrors).withTimeout(this.timeout).withLogger(this.getLog()).withVerbose(this.verbose).withIssueKeys(this.issueKeys).withFilterId(this.filterId).build();
                    response = xrayFeaturesExporter.submit(this.outputDir);
                } else {
                    XrayFeaturesExporter xrayFeaturesExporter = this.jiraToken != null ? new XrayFeaturesExporter.ServerDCBuilder(this.jiraBaseUrl, this.jiraToken).withInternalTestProxy(this.useInternalTestProxy).withIgnoreSslErrors(this.ignoreSslErrors).withTimeout(this.timeout).withLogger(this.getLog()).withVerbose(this.verbose).withIssueKeys(this.issueKeys).withFilterId(this.filterId).build() : new XrayFeaturesExporter.ServerDCBuilder(this.jiraBaseUrl, this.jiraUsername, this.jiraPassword).withInternalTestProxy(this.useInternalTestProxy).withIgnoreSslErrors(this.ignoreSslErrors).withTimeout(this.timeout).withLogger(this.getLog()).withVerbose(this.verbose).withIssueKeys(this.issueKeys).withFilterId(this.filterId).build();
                    response = xrayFeaturesExporter.submit(this.outputDir);
                }
                this.getLog().info((CharSequence)("response: " + response));
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)ex.getMessage());
                if (!CommonUtils.isTrue(this.abortOnError)) break block4;
                System.exit(1);
            }
        }
    }
}

