/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray;

import app.getxray.xray.CommonUtils;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.maven.plugin.logging.Log;

public class CommonCloud {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    public static final String XRAY_CLOUD_API_BASE_URL = "https://xray.cloud.getxray.app/api/v2";

    private CommonCloud() {
        throw new IllegalStateException("Utility class");
    }

    public static String authenticateXrayAPIKeyCredentials(Log logger, boolean verbose, OkHttpClient client, String clientId, String clientSecret, String cloudApiBaseUrl) throws IOException {
        String authenticationPayload = "{ \"client_id\": \"" + clientId + "\", \"client_secret\": \"" + clientSecret + "\" }";
        RequestBody body = RequestBody.create((String)authenticationPayload, (MediaType)MEDIA_TYPE_JSON);
        String xrayCloudAuthenticateUrl = cloudApiBaseUrl + "/authenticate";
        Request request = new Request.Builder().url(xrayCloudAuthenticateUrl).post(body).build();
        CommonUtils.logRequest(logger, request, verbose);
        try (Response response = client.newCall(request).execute();){
            CommonUtils.logResponse(logger, response, false);
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                String string = responseBody.replace("\"", "");
                return string;
            }
            throw new IOException("failed to authenticate " + response);
        }
    }
}

