package app.iapush.models.redirections

import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IChildModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class Redirection(
    @Schema("Id of the Redirection", "abc123")
    override val id: UUID,
    @Schema("Id of the App that owns the Redirection", "123abc")
    val appId: UUID,
    @Schema("Name of the Redirection", "Example redirection")
    val name: String,
    @Schema("Target URL of the Redirection", "https://example.com")
    val url: String,
    @Schema("Type of the Redirection", "AS_SOURCE")
    val type: RedirectionType,
) : IChildModel<UUID, CreateRedirectionPayload, UpdateRedirectionPayload, UUID> {

    override val parentId: UUID
        get() = appId

}
