package app.iapush.repositories.redirections

import app.iapush.client.IIAPushClient
import app.iapush.models.apps.App
import app.iapush.models.redirections.CreateRedirectionPayload
import app.iapush.models.redirections.Redirection
import app.iapush.models.redirections.UpdateRedirectionPayload
import app.iapush.models.users.User
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.APIChildModelRemoteRepository
import dev.kaccelero.repositories.IAPIChildModelRemoteRepository
import io.ktor.util.reflect.*

class RedirectionRemoteRepository(
    client: IIAPushClient,
    parentRepository: IAPIChildModelRemoteRepository<App, UUID, *, *, *>,
) : APIChildModelRemoteRepository<Redirection, UUID, CreateRedirectionPayload, UpdateRedirectionPayload, UUID>(
    typeInfo<Redirection>(),
    typeInfo<CreateRedirectionPayload>(),
    typeInfo<UpdateRedirectionPayload>(),
    typeInfo<List<Redirection>>(),
    client,
    parentRepository,
    prefix = "/api/v1"
), IRedirectionRemoteRepository {

    override suspend fun list(appId: UUID, userId: UUID): List<Redirection> =
        list(RecursiveId<App, UUID, UUID>(appId, RecursiveId<User, UUID, Unit>(userId)), null)

    override suspend fun get(id: UUID, appId: UUID, userId: UUID): Redirection? =
        get(id, RecursiveId<App, UUID, UUID>(appId, RecursiveId<User, UUID, Unit>(userId)), null)

    override suspend fun create(payload: CreateRedirectionPayload, appId: UUID, userId: UUID): Redirection? =
        create(payload, RecursiveId<App, UUID, UUID>(appId, RecursiveId<User, UUID, Unit>(userId)), null)

    override suspend fun update(id: UUID, appId: UUID, payload: UpdateRedirectionPayload, userId: UUID): Redirection? =
        update(id, payload, RecursiveId<App, UUID, UUID>(appId, RecursiveId<User, UUID, Unit>(userId)), null)

    override suspend fun delete(id: UUID, appId: UUID, userId: UUID): Boolean =
        delete(id, RecursiveId<App, UUID, UUID>(appId, RecursiveId<User, UUID, Unit>(userId)), null)

}
