package app.iapush.usecases.currency

import app.iapush.models.currency.CurrencyExchange
import app.iapush.repositories.currency.ICurrencyRemoteRepository

class ConvertCurrencyUseCase(
    private val currencyRemoteRepository: ICurrencyRemoteRepository,
) : IConvertCurrencyUseCase {

    override suspend fun invoke(input1: Double, input2: CurrencyExchange): Double {
        val rates = currencyRemoteRepository.list().usd
        val rate = rates[input2.destination.lowercase()]!! / rates[input2.origin.lowercase()]!!
        return input1 * rate
    }

}
