package app.iapush.models.leaderboard

import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IChildModel
import dev.kaccelero.models.UUID
import kotlinx.datetime.Instant
import kotlinx.serialization.Serializable

@Serializable
data class LeaderboardEntry(
    @Schema("Id of the entry", "abc123")
    override val id: UUID,
    @Schema("Id of the user", "abc123")
    val userId: UUID,
    @Schema("Date and time when the user sold an item", "2021-01-01T00:00:00Z")
    val soldAt: Instant,
    @Schema("Amount of the item sold", "100.00")
    val amount: Double,
) : IChildModel<UUID, CreateLeaderboardEntryPayload, Unit, UUID> {

    override val parentId: UUID
        get() = userId

}
