package app.iapush.models.leaderboard

import kotlinx.datetime.*
import kotlinx.serialization.Serializable
import kotlin.time.Duration.Companion.days
import kotlin.time.Duration.Companion.hours

@Serializable
enum class LeaderboardPeriod {

    LAST_24H, LAST_7D, LAST_30D, THIS_MONTH;

    val instantIntervals: Triple<Instant, Instant, Instant>
        get() {
            val now = Clock.System.now()

            val periodDuration = when (this) {
                LAST_24H -> 24.hours
                LAST_7D -> 7.days
                LAST_30D -> 30.days
                THIS_MONTH -> now.toLocalDateTime(TimeZone.UTC)
                    .let { now.minus(LocalDate(it.year, it.month, 1).atStartOfDayIn(TimeZone.UTC)) }
            }
            val start = now.minus(periodDuration)

            val comparedDuration = when (this) {
                THIS_MONTH -> start.minus(start.minus(1, DateTimeUnit.MONTH, TimeZone.UTC))
                else -> periodDuration
            }
            val compared = start.minus(comparedDuration)

            return Triple(start, now, compared)
        }

}
