package app.iapush.client

import app.iapush.repositories.apps.IAppsRemoteRepository
import app.iapush.repositories.auth.IAuthAPIRemoteRepository
import app.iapush.repositories.leaderboard.ILeaderboardRemoteRepository
import app.iapush.repositories.notifications.INotificationTokensRemoteRepository
import app.iapush.repositories.redirections.IRedirectionRemoteRepository
import app.iapush.repositories.users.IUsersRemoteRepository
import dev.kaccelero.client.IAPIClient

interface IIAPushClient : IAPIClient {

    val auth: IAuthAPIRemoteRepository
    val users: IUsersRemoteRepository
    val apps: IAppsRemoteRepository
    val redirections: IRedirectionRemoteRepository
    val leaderboard: ILeaderboardRemoteRepository
    val notificationTokens: INotificationTokensRemoteRepository

}
