package app.iapush.models.apps

import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IChildModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class App(
    @Schema("Id of the App", "com.example.app")
    val bundleId: String,
    @Schema("Id of the User that owns the App", "123abc")
    val userId: UUID,
    @Schema("Name of the App", "Example app")
    val name: String,
) : IChildModel<String, CreateAppPayload, UpdateAppPayload, UUID> {

    override val id: String
        get() = bundleId

    override val parentId: UUID
        get() = userId

}
