package app.iapush.repositories.leaderboard

import app.iapush.client.IIAPushClient
import app.iapush.models.leaderboard.CreateLeaderboardMembershipPayload
import app.iapush.models.leaderboard.LeaderboardMembership
import app.iapush.models.leaderboard.LeaderboardPaginationOptions
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.APIModelRemoteRepository
import dev.kaccelero.repositories.IPaginationOptions
import dev.kaccelero.repositories.Pagination
import io.ktor.client.request.*
import io.ktor.util.reflect.*

class LeaderboardRemoteRepository(
    client: IIAPushClient,
) : APIModelRemoteRepository<LeaderboardMembership, UUID, CreateLeaderboardMembershipPayload, Unit>(
    typeInfo<LeaderboardMembership>(),
    typeInfo<CreateLeaderboardMembershipPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<LeaderboardMembership>>(),
    client,
    route = "leaderboard",
    prefix = "/api/v1"
), ILeaderboardRemoteRepository {

    override fun encodePaginationOptions(options: IPaginationOptions, builder: HttpRequestBuilder) = when (options) {
        is LeaderboardPaginationOptions -> builder.parameter("period", options.period)
        else -> super.encodePaginationOptions(options, builder)
    }

    override suspend fun list(pagination: Pagination): List<LeaderboardMembership> =
        list(pagination, null)

    override suspend fun create(payload: CreateLeaderboardMembershipPayload): LeaderboardMembership? =
        create(payload, null)

    override suspend fun delete(id: UUID): Boolean =
        delete(id, null)

}
