package app.iapush.models.apps

import dev.kaccelero.annotations.Schema
import dev.kaccelero.annotations.StringPropertyValidator
import kotlinx.serialization.Serializable

@Serializable
data class CreateAppPayload(
    @StringPropertyValidator(regex = "[A-Za-z0-9\\.\\-]+")
    @Schema("Id of the App", "com.example.app")
    val bundleId: String,
    @Schema("Name of the App", "Example app")
    val name: String,
)
