/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.server.controllers;

import app.keyconnect.api.client.model.BlockchainAccountTransaction;
import app.keyconnect.api.client.model.SubmitTransactionRequest;
import app.keyconnect.api.client.model.SubmitTransactionResult;
import app.keyconnect.server.factories.BlockchainGatewayFactory;
import app.keyconnect.server.gateways.exceptions.UnknownNetworkException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BlockchainTransactionController {
    private final BlockchainGatewayFactory blockchainGatewayFactory;

    public BlockchainTransactionController(BlockchainGatewayFactory blockchainGatewayFactory) {
        this.blockchainGatewayFactory = blockchainGatewayFactory;
    }

    @GetMapping(path={"/v1/blockchains/{chainId}/transactions/{hash}"}, produces={"application/json"})
    public ResponseEntity<BlockchainAccountTransaction> getTransaction(@PathVariable(value="chainId") String chainId, @PathVariable(value="hash") String hash, @RequestParam(value="network", required=false, defaultValue="mainnet") String network) throws UnknownNetworkException {
        return ResponseEntity.ok((Object)this.blockchainGatewayFactory.getGateway(chainId).getTransaction(network, hash));
    }

    @PostMapping(path={"/v1/blockchains/{chainId}/transactions"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<SubmitTransactionResult> submitTransaction(@PathVariable(value="chainId") String chainId, @RequestParam(value="network", required=false, defaultValue="mainnet") String network, @RequestBody SubmitTransactionRequest submitTransactionRequest) throws UnknownNetworkException {
        return ResponseEntity.accepted().body((Object)this.blockchainGatewayFactory.getGateway(chainId).submitTransaction(network, submitTransactionRequest));
    }
}

