/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.server.controllers;

import app.keyconnect.server.repository.TestRepo;
import app.keyconnect.server.repository.entities.TestObject;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnProperty(name={"runtime-mode"}, havingValue="test")
public class TestController {
    private final TestRepo testRepo;

    public TestController(TestRepo testRepo) {
        this.testRepo = testRepo;
    }

    @PostMapping(path={"/api/v1/test"}, produces={"application/json"})
    public ResponseEntity<TestObject> putTestObject(@RequestParam(value="value") String value) {
        TestObject testObject = new TestObject(value);
        this.testRepo.save((Object)testObject);
        return ResponseEntity.ok((Object)testObject);
    }

    @GetMapping(path={"/api/v1/test"}, produces={"application/json"})
    public ResponseEntity<TestObject> getTestObject(@RequestParam(value="id") String id) {
        Optional maybeObject = this.testRepo.findById((Object)id);
        return ResponseEntity.of((Optional)maybeObject);
    }
}

