/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.server.gateways;

import app.keyconnect.api.client.model.BlockchainAccountInfo;
import app.keyconnect.api.client.model.BlockchainAccountPaymentItem;
import app.keyconnect.api.client.model.BlockchainAccountPayments;
import app.keyconnect.api.client.model.BlockchainAccountTransaction;
import app.keyconnect.api.client.model.BlockchainAccountTransactionItem;
import app.keyconnect.api.client.model.BlockchainAccountTransactions;
import app.keyconnect.api.client.model.BlockchainFee;
import app.keyconnect.api.client.model.BlockchainNetworkServerStatus;
import app.keyconnect.api.client.model.CurrencyValue;
import app.keyconnect.api.client.model.SubmitTransactionRequest;
import app.keyconnect.api.client.model.SubmitTransactionResult;
import app.keyconnect.server.factories.configuration.BlockchainNetworkConfiguration;
import app.keyconnect.server.factories.configuration.BlockchainsConfiguration;
import app.keyconnect.server.factories.configuration.YamlConfiguration;
import app.keyconnect.server.gateways.BlockchainGateway;
import app.keyconnect.server.gateways.exceptions.EthTransactionsCursorMustBePageNumberException;
import app.keyconnect.server.gateways.exceptions.FailedToSubmitEthTransactionException;
import app.keyconnect.server.gateways.exceptions.UnknownNetworkException;
import app.keyconnect.server.gateways.exceptions.UnsupportedNetworkForEthTransactionsException;
import app.keyconnect.server.utils.EtherscanUtil;
import app.keyconnect.server.utils.models.EtherscanResponse;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.http.HttpService;

public class EthereumGateway
implements BlockchainGateway {
    private static final BigDecimal ETH_SCALE = BigDecimal.valueOf(1000000000000000000L);
    private static final Logger logger = LoggerFactory.getLogger(EthereumGateway.class);
    public static final String CHAIN_ID = "eth";
    public static final int SCALE = 18;
    public static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_UP;
    private final BlockchainsConfiguration configuration;
    private final Map<String, Web3j> serverClients;
    private final LoadingCache<String, EthBlock> latestEthBlockCache;
    private EtherscanUtil etherscanUtil;

    public EthereumGateway(YamlConfiguration configuration, EtherscanUtil etherscanUtil) {
        this.configuration = configuration.getBlockchains().stream().filter(b -> b.getType().equalsIgnoreCase(CHAIN_ID)).findFirst().orElse(new BlockchainsConfiguration());
        this.etherscanUtil = etherscanUtil;
        this.serverClients = new ConcurrentHashMap(this.configuration.getNetworks().size());
        this.configuration.getNetworks().stream().map(BlockchainNetworkConfiguration::getAddress).distinct().forEach(a -> {
            Web3j client = Web3j.build((Web3jService)new HttpService(a));
            this.serverClients.put(a, client);
        });
        this.latestEthBlockCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getChainId() {
        return CHAIN_ID;
    }

    public String[] getNetworks() {
        return (String[])this.configuration.getNetworks().stream().map(BlockchainNetworkConfiguration::getGroup).distinct().toArray(String[]::new);
    }

    public BlockchainNetworkServerStatus[] getNetworkServerStatus(String network) {
        List eligibleNetworks = this.configuration.getNetworks().stream().filter(n -> n.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        return (BlockchainNetworkServerStatus[])eligibleNetworks.stream().map(n -> {
            String serverUrl = n.getAddress();
            Web3j client = (Web3j)this.serverClients.get(serverUrl);
            try {
                EthBlock latestEthBlock = (EthBlock)client.ethGetBlockByNumber(DefaultBlockParameter.valueOf((String)"latest"), false).sendAsync().get(30L, TimeUnit.SECONDS);
                return new BlockchainNetworkServerStatus().status(latestEthBlock.getBlock().getHash() != null ? BlockchainNetworkServerStatus.StatusEnum.HEALTHY : BlockchainNetworkServerStatus.StatusEnum.UNHEALTHY).host(this.toHost(serverUrl)).lastCheck(Instant.now().toString());
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.warn("Unable to get latest block to obtain status for network=" + n, (Throwable)e);
                return new BlockchainNetworkServerStatus().status(BlockchainNetworkServerStatus.StatusEnum.UNHEALTHY).host(this.toHost(serverUrl)).lastCheck(Instant.now().toString());
            }
        }).toArray(BlockchainNetworkServerStatus[]::new);
    }

    public BlockchainFee getFee(String network) {
        List eligibleNetworks = this.configuration.getNetworks().stream().filter(n -> n.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        for (BlockchainNetworkConfiguration eligibleNetwork : eligibleNetworks) {
            String serverUrl = eligibleNetwork.getAddress();
            try {
                Web3j client = (Web3j)this.serverClients.get(serverUrl);
                EthGasPrice gasPrice = (EthGasPrice)client.ethGasPrice().sendAsync().get(30L, TimeUnit.SECONDS);
                return new BlockchainFee().server(this.toHost(serverUrl)).network(network).chainId(BlockchainFee.ChainIdEnum.ETH).fee(new CurrencyValue().currency(CurrencyValue.CurrencyEnum.GAS).amount(gasPrice.getGasPrice().toString()));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.warn("Unable to get eth.fee, network=" + network, (Throwable)e);
            }
        }
        return null;
    }

    public BlockchainAccountInfo getAccount(String network, String accountId) throws UnknownNetworkException {
        List eligibleNetworks = this.configuration.getNetworks().stream().filter(n -> n.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        if (eligibleNetworks.size() == 0) {
            throw new UnknownNetworkException(CHAIN_ID, network);
        }
        BlockchainAccountInfo accountInfo = new BlockchainAccountInfo().chainId(BlockchainAccountInfo.ChainIdEnum.ETH).accountId(accountId).network(network);
        for (BlockchainNetworkConfiguration eligibleNetwork : eligibleNetworks) {
            String serverUrl = eligibleNetwork.getAddress();
            Web3j client = (Web3j)this.serverClients.get(serverUrl);
            try {
                EthGetBalance balance = (EthGetBalance)client.ethGetBalance(accountId, DefaultBlockParameter.valueOf((String)"latest")).sendAsync().get(30L, TimeUnit.SECONDS);
                return accountInfo.server(this.toHost(serverUrl)).balance(new CurrencyValue().amount(new BigDecimal(balance.getBalance()).divide(ETH_SCALE, 18, ROUNDING_MODE).toString()).currency(CurrencyValue.CurrencyEnum.ETH));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.warn("Unable to get eth.accountInfo, network=" + eligibleNetwork, (Throwable)e);
            }
        }
        return accountInfo;
    }

    private boolean isInteger(String s) {
        return this.isInteger(s, 10);
    }

    private boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }

    public BlockchainAccountTransactions getTransactions(String accountId, String network, int limit, String cursor) throws UnknownNetworkException {
        if (!"mainnet".equalsIgnoreCase(network)) {
            throw new UnsupportedNetworkForEthTransactionsException();
        }
        if (!(Strings.isNullOrEmpty((String)cursor) || "null".equalsIgnoreCase(cursor) || this.isInteger(cursor))) {
            throw new EthTransactionsCursorMustBePageNumberException();
        }
        String pageNumber = Strings.isNullOrEmpty((String)cursor) || "null".equalsIgnoreCase(cursor) ? "1" : cursor;
        int iCursor = Integer.parseInt(pageNumber);
        List eligibleNetworks = this.configuration.getNetworks().stream().filter(n -> n.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        List transactionItems = null;
        for (BlockchainNetworkConfiguration eligibleNetwork : eligibleNetworks) {
            String latestBlockNumber;
            String serverUrl = eligibleNetwork.getAddress();
            try {
                latestBlockNumber = ((EthBlock)this.latestEthBlockCache.get((Object)serverUrl)).getBlock().getNumber().toString();
            }
            catch (ExecutionException e) {
                logger.warn("Unable to get latest block to get all transactions, account=" + accountId + ", network=" + network, (Throwable)e);
                continue;
            }
            EtherscanResponse transactions = this.etherscanUtil.getTransactionsForAccount(network, accountId, latestBlockNumber, pageNumber, String.valueOf(limit));
            transactionItems = Arrays.stream(transactions.getResult()).map(t -> {
                BigDecimal amountInEth = new BigDecimal(t.getValue()).divide(ETH_SCALE, 18, RoundingMode.DOWN);
                return new BlockchainAccountTransactionItem().amount(new CurrencyValue().amount(amountInEth.toString()).currency(CurrencyValue.CurrencyEnum.ETH)).sourceAccount(t.getFrom()).destinationAccount(t.getTo()).fee(new CurrencyValue().amount(t.getGas()).currency(CurrencyValue.CurrencyEnum.GAS)).type("transaction").hash(t.getHash()).status("ok");
            }).collect(Collectors.toList());
        }
        return new BlockchainAccountTransactions().accountId(accountId).network(network).server("https://api.etherscan.io").chainId(BlockchainAccountTransactions.ChainIdEnum.ETH).cursor(String.valueOf(iCursor + 1)).transactions(transactionItems);
    }

    public BlockchainAccountPayments getPayments(String accountId, String network, int limit, String cursor) throws UnknownNetworkException {
        BlockchainAccountTransactions blockchainAccountTransactions = this.getTransactions(accountId, network, limit, cursor);
        List transactions = blockchainAccountTransactions.getTransactions() != null ? blockchainAccountTransactions.getTransactions() : new ArrayList(0);
        return new BlockchainAccountPayments().accountId(accountId).network(network).server(blockchainAccountTransactions.getServer()).chainId(BlockchainAccountPayments.ChainIdEnum.ETH).cursor(blockchainAccountTransactions.getCursor()).payments(transactions.stream().filter(t -> "transaction".equalsIgnoreCase(t.getType())).map(t -> new BlockchainAccountPaymentItem().amount(t.getAmount()).fee(t.getFee()).sourceAccount(t.getSourceAccount()).destinationAccount(t.getDestinationAccount()).destinationTag(t.getDestinationTag()).hash(t.getHash()).status(t.getStatus())).collect(Collectors.toList()));
    }

    public BlockchainAccountTransaction getTransaction(String network, String hash) throws UnknownNetworkException {
        List eligibleNetworks = this.configuration.getNetworks().stream().filter(n -> n.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        for (BlockchainNetworkConfiguration eligibleNetwork : eligibleNetworks) {
            String serverUrl = eligibleNetwork.getAddress();
            Web3j client = (Web3j)this.serverClients.get(serverUrl);
            try {
                EthTransaction ethTransaction = (EthTransaction)client.ethGetTransactionByHash(hash).sendAsync().get(30L, TimeUnit.SECONDS);
                Transaction transaction = (Transaction)ethTransaction.getTransaction().get();
                BigDecimal amountInEth = new BigDecimal(transaction.getValue()).divide(ETH_SCALE, 18, RoundingMode.DOWN);
                return new BlockchainAccountTransaction().network(network).server(this.toHost(serverUrl)).chainId(BlockchainAccountTransaction.ChainIdEnum.ETH).transaction(new BlockchainAccountTransactionItem().amount(new CurrencyValue().amount(amountInEth.toString()).currency(CurrencyValue.CurrencyEnum.ETH)).sourceAccount(transaction.getFrom()).destinationAccount(transaction.getTo()).fee(new CurrencyValue().amount(transaction.getGas().toString()).currency(CurrencyValue.CurrencyEnum.GAS)).type("transaction").hash(transaction.getHash()).status(this.determineStatus(serverUrl, transaction.getBlockNumber())));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.warn("Unable to get eth.getTransaction, network=" + network + ", hash=" + hash, (Throwable)e);
            }
        }
        return null;
    }

    private String toHost(String url) {
        try {
            return new URI(url).getHost();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String determineStatus(String serverUrl, BigInteger transactionBlockNumber) throws ExecutionException {
        EthBlock latestBlock = (EthBlock)this.latestEthBlockCache.get((Object)serverUrl);
        int comparedToLatestBlock = latestBlock.getBlock().getNumber().compareTo(transactionBlockNumber);
        if (comparedToLatestBlock > 0) {
            return "ok";
        }
        return "unknown";
    }

    public SubmitTransactionResult submitTransaction(String network, SubmitTransactionRequest submitTransactionRequest) throws UnknownNetworkException {
        List eligibleNetworks = this.configuration.getNetworks().stream().filter(n -> n.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        for (BlockchainNetworkConfiguration eligibleNetwork : eligibleNetworks) {
            EthSendTransaction response;
            String serverUrl = eligibleNetwork.getAddress();
            Web3j client = (Web3j)this.serverClients.get(serverUrl);
            try {
                response = (EthSendTransaction)client.ethSendRawTransaction(submitTransactionRequest.getTransaction()).sendAsync().get(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.warn("Unable to send transaction network=" + network, (Throwable)e);
                continue;
            }
            return new SubmitTransactionResult().server(serverUrl).transaction(new BlockchainAccountTransactionItem().hash(response.getTransactionHash())).network(network).chainId(SubmitTransactionResult.ChainIdEnum.ETH);
        }
        throw new FailedToSubmitEthTransactionException();
    }
}

