/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.server.gateways;

import app.keyconnect.api.client.model.BlockchainAccountInfo;
import app.keyconnect.api.client.model.BlockchainAccountPaymentItem;
import app.keyconnect.api.client.model.BlockchainAccountPayments;
import app.keyconnect.api.client.model.BlockchainAccountTransaction;
import app.keyconnect.api.client.model.BlockchainAccountTransactionItem;
import app.keyconnect.api.client.model.BlockchainAccountTransactions;
import app.keyconnect.api.client.model.BlockchainFee;
import app.keyconnect.api.client.model.BlockchainNetworkServerStatus;
import app.keyconnect.api.client.model.CurrencyValue;
import app.keyconnect.api.client.model.SubmitTransactionRequest;
import app.keyconnect.api.client.model.SubmitTransactionResult;
import app.keyconnect.rippled.api.client.PublicRippledClient;
import app.keyconnect.rippled.api.client.config.PublicRippledClientConfig;
import app.keyconnect.rippled.api.client.model.AccountInfoResponse;
import app.keyconnect.rippled.api.client.model.AccountTransaction;
import app.keyconnect.rippled.api.client.model.AccountTransactionMarker;
import app.keyconnect.rippled.api.client.model.AccountTransactionResponse;
import app.keyconnect.rippled.api.client.model.FeeResponse;
import app.keyconnect.rippled.api.client.model.ServerInfoResponse;
import app.keyconnect.rippled.api.client.model.SubmitTransactionResponse;
import app.keyconnect.rippled.api.client.model.TransactionResponse;
import app.keyconnect.rippled.api.client.model.TransactionResult;
import app.keyconnect.server.controllers.exceptions.InvalidCursorException;
import app.keyconnect.server.factories.configuration.BlockchainNetworkConfiguration;
import app.keyconnect.server.factories.configuration.BlockchainsConfiguration;
import app.keyconnect.server.factories.configuration.YamlConfiguration;
import app.keyconnect.server.gateways.BlockchainGateway;
import app.keyconnect.server.gateways.exceptions.UnknownNetworkException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class XrpGateway
implements BlockchainGateway {
    private static final Logger logger = LoggerFactory.getLogger(XrpGateway.class);
    public static final String CHAIN_ID = "xrp";
    public static final BigDecimal DROPS_PER_XRP = BigDecimal.valueOf(100000L);
    private static final Duration SERVER_INFO_CACHE_EXPIRY = Duration.of(30L, ChronoUnit.SECONDS);
    private final BlockchainsConfiguration configuration;
    private final Map<String, PublicRippledClient> serverClients;
    private final LoadingCache<String, ServerInfoResponse> serverInfoCache;
    private final LoadingCache<String, FeeResponse> networkFeeCache;
    private final LoadingCache<String, AccountInfoResponse> walletAccountInfoCache;

    public XrpGateway(YamlConfiguration configuration, Supplier<RestTemplate> restTemplateSupplier) {
        this.configuration = configuration.getBlockchains().stream().filter(b -> b.getType().equalsIgnoreCase(CHAIN_ID)).findFirst().get();
        this.serverClients = new ConcurrentHashMap(this.configuration.getNetworks().size());
        this.configuration.getNetworks().stream().map(BlockchainNetworkConfiguration::getAddress).distinct().forEach(a -> {
            PublicRippledClient client = new PublicRippledClient((RestTemplate)restTemplateSupplier.get(), PublicRippledClientConfig.builder().jsonRpcEndpoint(a).build());
            this.serverClients.put(a, client);
        });
        this.serverInfoCache = CacheBuilder.newBuilder().expireAfterWrite(SERVER_INFO_CACHE_EXPIRY).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
        this.walletAccountInfoCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.of(30L, ChronoUnit.SECONDS)).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
        this.networkFeeCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.of(1L, ChronoUnit.MINUTES)).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getChainId() {
        return CHAIN_ID;
    }

    public String[] getNetworks() {
        return (String[])this.configuration.getNetworks().stream().map(BlockchainNetworkConfiguration::getGroup).distinct().toArray(String[]::new);
    }

    public BlockchainNetworkServerStatus[] getNetworkServerStatus(String network) throws UnknownNetworkException {
        List foundNetworks = this.configuration.getNetworks().stream().filter(n -> n.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        if (foundNetworks.size() == 0) {
            throw new UnknownNetworkException(CHAIN_ID, network);
        }
        return (BlockchainNetworkServerStatus[])foundNetworks.stream().map(c -> {
            try {
                ServerInfoResponse serverInfoResponse = (ServerInfoResponse)this.serverInfoCache.get((Object)c.getAddress());
                return new BlockchainNetworkServerStatus().status(serverInfoResponse.getResult().getStatus().equalsIgnoreCase("success") ? BlockchainNetworkServerStatus.StatusEnum.HEALTHY : BlockchainNetworkServerStatus.StatusEnum.UNHEALTHY).host(this.toURI(c)).lastCheck(Instant.now().toString());
            }
            catch (Throwable e) {
                logger.warn("Unable to get serverInfo to obtain status for network=" + c, e);
                return new BlockchainNetworkServerStatus().status(BlockchainNetworkServerStatus.StatusEnum.UNHEALTHY).host(this.toURI(c)).lastCheck(Instant.now().toString());
            }
        }).toArray(BlockchainNetworkServerStatus[]::new);
    }

    public BlockchainFee getFee(String network) throws UnknownNetworkException {
        List eligibleNetworks = this.configuration.getNetworks().stream().filter(n -> n.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        if (eligibleNetworks.size() == 0) {
            throw new UnknownNetworkException(CHAIN_ID, network);
        }
        for (BlockchainNetworkConfiguration eligibleNetwork : eligibleNetworks) {
            String serverUrl = eligibleNetwork.getAddress();
            try {
                FeeResponse feeResponse = (FeeResponse)this.networkFeeCache.get((Object)serverUrl);
                CurrencyValue fee = new CurrencyValue().amount(feeResponse.getResult().getDrops().getMinimumFee()).currency(CurrencyValue.CurrencyEnum.DROPS);
                return new BlockchainFee().chainId(BlockchainFee.ChainIdEnum.XRP).fee(fee).network(network).server(serverUrl);
            }
            catch (ExecutionException e) {
                logger.warn("Unable to get xrp.fee, network=" + network, (Throwable)e);
            }
        }
        return null;
    }

    public BlockchainAccountInfo getAccount(String network, String accountId) throws UnknownNetworkException {
        List eligibleNetworks = this.configuration.getNetworks().stream().filter(n -> n.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        if (eligibleNetworks.size() == 0) {
            throw new UnknownNetworkException(CHAIN_ID, network);
        }
        AccountInfoResponse accountInfoResponse = null;
        BlockchainNetworkConfiguration selectedNetwork = null;
        for (BlockchainNetworkConfiguration eligibleNetwork : eligibleNetworks) {
            String networkAddress = eligibleNetwork.getAddress();
            String key = networkAddress + "|" + accountId;
            try {
                accountInfoResponse = (AccountInfoResponse)this.walletAccountInfoCache.get((Object)key);
                selectedNetwork = eligibleNetwork;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        BlockchainAccountInfo accountInfo = new BlockchainAccountInfo().chainId(BlockchainAccountInfo.ChainIdEnum.XRP).accountId(accountId).network(network);
        if (selectedNetwork != null) {
            accountInfo.setServer(selectedNetwork.getAddress());
        }
        if (accountInfoResponse != null && accountInfoResponse.getResult() != null && accountInfoResponse.getResult().getAccountData() != null) {
            if (accountInfoResponse.getResult().getAccountData().getBalance() != null) {
                BigDecimal balanceInXrp = new BigDecimal(accountInfoResponse.getResult().getAccountData().getBalance()).divide(DROPS_PER_XRP, RoundingMode.DOWN);
                accountInfo.setBalance(new CurrencyValue().amount(balanceInXrp.toPlainString()).currency(CurrencyValue.CurrencyEnum.XRP));
            }
            accountInfo.setLastTransactionId(accountInfoResponse.getResult().getAccountData().getPreviousTxnID());
        }
        return accountInfo;
    }

    public BlockchainAccountTransactions getTransactions(String accountId, String network, int limit, String cursor) throws UnknownNetworkException {
        List selectedNetworks = this.configuration.getNetworks().stream().filter(c -> c.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        if (selectedNetworks.size() == 0) {
            throw new UnknownNetworkException(CHAIN_ID, network);
        }
        PublicRippledClient client = (PublicRippledClient)this.serverClients.get(((BlockchainNetworkConfiguration)selectedNetworks.get(0)).getAddress());
        AccountTransactionMarker requestMarker = null;
        if (StringUtils.isNotBlank((CharSequence)cursor) && ((String)cursor).contains(":")) {
            String[] markerLedgerAndSeq = ((String)cursor).split(":");
            try {
                requestMarker = new AccountTransactionMarker().ledger(Integer.valueOf(markerLedgerAndSeq[0])).seq(Integer.valueOf(markerLedgerAndSeq[1]));
            }
            catch (NumberFormatException e) {
                throw new InvalidCursorException();
            }
        }
        AccountTransactionResponse accountTransactionsResponse = client.getAccountTransactions(accountId, limit, requestMarker);
        List transactions = accountTransactionsResponse.getResult().getTransactions();
        AccountTransactionMarker responseMarker = accountTransactionsResponse.getResult().getMarker();
        cursor = responseMarker != null ? responseMarker.getLedger() + ":" + responseMarker.getSeq() : null;
        return new BlockchainAccountTransactions().accountId(accountId).network(network).server(((BlockchainNetworkConfiguration)selectedNetworks.get(0)).getAddress()).chainId(BlockchainAccountTransactions.ChainIdEnum.XRP).cursor((String)cursor).transactions(transactions.stream().map(t -> {
            AccountTransaction tx = t.getTx();
            return new BlockchainAccountTransactionItem().amount(new CurrencyValue().amount(tx.getAmount()).currency(CurrencyValue.CurrencyEnum.DROPS)).sourceAccount(tx.getAccount()).destinationAccount(tx.getDestination()).destinationTag(String.valueOf(tx.getDestinationTag())).fee(new CurrencyValue().amount(tx.getFee()).currency(CurrencyValue.CurrencyEnum.DROPS)).type(tx.getTransactionType()).hash(tx.getHash()).status(this.toSimpleStatus(t.getMeta().getTransactionResult()));
        }).collect(Collectors.toList()));
    }

    public BlockchainAccountPayments getPayments(String accountId, String network, int limit, String cursor) throws UnknownNetworkException {
        BlockchainAccountTransactions blockchainAccountTransactions = this.getTransactions(accountId, network, limit, cursor);
        List transactions = blockchainAccountTransactions.getTransactions() != null ? blockchainAccountTransactions.getTransactions() : new ArrayList(0);
        return new BlockchainAccountPayments().accountId(accountId).network(network).server(blockchainAccountTransactions.getServer()).chainId(BlockchainAccountPayments.ChainIdEnum.XRP).cursor(blockchainAccountTransactions.getCursor()).payments(transactions.stream().filter(t -> "payment".equalsIgnoreCase(t.getType())).map(t -> new BlockchainAccountPaymentItem().amount(t.getAmount()).fee(t.getFee()).sourceAccount(t.getSourceAccount()).destinationAccount(t.getDestinationAccount()).destinationTag(t.getDestinationTag()).hash(t.getHash()).status(t.getStatus())).collect(Collectors.toList()));
    }

    public BlockchainAccountTransaction getTransaction(String network, String hash) throws UnknownNetworkException {
        List selectedNetworks = this.configuration.getNetworks().stream().filter(c -> c.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        if (selectedNetworks.size() == 0) {
            throw new UnknownNetworkException(CHAIN_ID, network);
        }
        PublicRippledClient client = (PublicRippledClient)this.serverClients.get(((BlockchainNetworkConfiguration)selectedNetworks.get(0)).getAddress());
        TransactionResponse transaction = client.getTransaction(hash);
        TransactionResult tx = transaction.getResult();
        return new BlockchainAccountTransaction().network(network).server(((BlockchainNetworkConfiguration)selectedNetworks.get(0)).getAddress()).chainId(BlockchainAccountTransaction.ChainIdEnum.XRP).transaction(new BlockchainAccountTransactionItem().amount(new CurrencyValue().amount(tx.getAmount()).currency(CurrencyValue.CurrencyEnum.DROPS)).sourceAccount(tx.getAccount()).destinationAccount(tx.getDestination()).destinationTag(String.valueOf(tx.getDestinationTag())).fee(new CurrencyValue().amount(tx.getFee()).currency(CurrencyValue.CurrencyEnum.DROPS)).type(tx.getTransactionType()).hash(tx.getHash()).status(this.toSimpleStatus(tx.getMeta().getTransactionResult())));
    }

    public SubmitTransactionResult submitTransaction(String network, SubmitTransactionRequest submitTransactionRequest) throws UnknownNetworkException {
        List selectedNetworks = this.configuration.getNetworks().stream().filter(c -> c.getGroup().equalsIgnoreCase(network)).collect(Collectors.toList());
        if (selectedNetworks.size() == 0) {
            throw new UnknownNetworkException(CHAIN_ID, network);
        }
        PublicRippledClient client = (PublicRippledClient)this.serverClients.get(((BlockchainNetworkConfiguration)selectedNetworks.get(0)).getAddress());
        SubmitTransactionResponse submitTransaction = client.submitTransaction(submitTransactionRequest.getTransaction());
        AccountTransaction tx = submitTransaction.getResult().getTxJson();
        return new SubmitTransactionResult().chainId(SubmitTransactionResult.ChainIdEnum.XRP).network(network).server(((BlockchainNetworkConfiguration)selectedNetworks.get(0)).getAddress()).transaction(new BlockchainAccountTransactionItem().amount(new CurrencyValue().amount(tx.getAmount()).currency(CurrencyValue.CurrencyEnum.DROPS)).sourceAccount(tx.getAccount()).destinationAccount(tx.getDestination()).destinationTag(String.valueOf(tx.getDestinationTag())).fee(new CurrencyValue().amount(tx.getFee()).currency(CurrencyValue.CurrencyEnum.DROPS)).type(tx.getTransactionType()).hash(tx.getHash()).status(this.toSimpleStatus(tx.getMeta().getTransactionResult())));
    }

    private String toSimpleStatus(String transactionResult) {
        if (transactionResult.startsWith("tes") && transactionResult.endsWith("SUCCESS")) {
            return "success";
        }
        if (transactionResult.startsWith("tef") || transactionResult.startsWith("tec") || transactionResult.startsWith("tem")) {
            return "failure";
        }
        if (transactionResult.startsWith("tel") || transactionResult.startsWith("ter")) {
            return "pending";
        }
        return transactionResult;
    }

    private String toURI(BlockchainNetworkConfiguration c) {
        try {
            return new URI(c.getAddress()).getHost();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

