/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.server.utils;

import app.keyconnect.server.utils.models.EtherscanResponse;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class EtherscanUtil {
    private final RestTemplate restTemplate;
    private final String token;
    private final RateLimiter rateLimiter;
    public static final String ETHERSCAN_TXN_BASE_URI = "https://api.etherscan.io/api?module=account&action=txlist&address={address}&startblock=0&endblock={endBlock}&sort=desc&page={page}&offset={offset}&apikey={token}";

    public EtherscanUtil(RestTemplate restTemplate, String token) {
        this.restTemplate = restTemplate;
        this.token = token;
        this.rateLimiter = RateLimiter.create((double)4.0);
    }

    public EtherscanResponse getTransactionsForAccount(String network, String address, String latestBlock, String pageNumber, String pageSize) {
        if (!network.equalsIgnoreCase("mainnet")) {
            return new EtherscanResponse();
        }
        boolean acquired = this.rateLimiter.tryAcquire(30L, TimeUnit.SECONDS);
        if (acquired) {
            ResponseEntity response = this.restTemplate.getForEntity(ETHERSCAN_TXN_BASE_URI, EtherscanResponse.class, new Object[]{address, latestBlock, pageNumber, pageSize, this.token});
            return (EtherscanResponse)response.getBody();
        }
        throw new IllegalStateException("Timeout while waiting >30 seconds for permit");
    }
}

