/*
 * Kntrl API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 0.10.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package app.kntrl.client.openapi.api;

import app.kntrl.client.openapi.infra.ApiCallback;
import app.kntrl.client.openapi.infra.ApiClient;
import app.kntrl.client.openapi.infra.ApiException;
import app.kntrl.client.openapi.infra.ApiResponse;
import app.kntrl.client.openapi.infra.Configuration;
import app.kntrl.client.openapi.infra.Pair;
import app.kntrl.client.openapi.infra.ProgressRequestBody;
import app.kntrl.client.openapi.infra.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import app.kntrl.client.openapi.model.ClientErr;
import app.kntrl.client.openapi.model.IntegrationErr;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class CustomTokenApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomTokenApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomTokenApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createCustomBinaryToken
     * @param body  (required)
     * @param secret  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCustomBinaryTokenCall(String body, String secret, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/tokens/custom/binary";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (secret != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("secret", secret));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "access-token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createCustomBinaryTokenValidateBeforeCall(String body, String secret, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createCustomBinaryToken(Async)");
        }
        

        okhttp3.Call localVarCall = createCustomBinaryTokenCall(body, secret, _callback);
        return localVarCall;

    }

    /**
     * (Backend API) Create binary token
     * Creates binary token signed with specified secret. When secret is null - use app secret (specified in kntrl.json5) with SHA256withRSA algorithm. Otherwise - use secret from query and sign with HmacSHA256 algorithm. 
     * @param body  (required)
     * @param secret  (optional)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public String createCustomBinaryToken(String body, String secret) throws ApiException {
        ApiResponse<String> localVarResp = createCustomBinaryTokenWithHttpInfo(body, secret);
        return localVarResp.getData();
    }

    /**
     * (Backend API) Create binary token
     * Creates binary token signed with specified secret. When secret is null - use app secret (specified in kntrl.json5) with SHA256withRSA algorithm. Otherwise - use secret from query and sign with HmacSHA256 algorithm. 
     * @param body  (required)
     * @param secret  (optional)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> createCustomBinaryTokenWithHttpInfo(String body, String secret) throws ApiException {
        okhttp3.Call localVarCall = createCustomBinaryTokenValidateBeforeCall(body, secret, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * (Backend API) Create binary token (asynchronously)
     * Creates binary token signed with specified secret. When secret is null - use app secret (specified in kntrl.json5) with SHA256withRSA algorithm. Otherwise - use secret from query and sign with HmacSHA256 algorithm. 
     * @param body  (required)
     * @param secret  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCustomBinaryTokenAsync(String body, String secret, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = createCustomBinaryTokenValidateBeforeCall(body, secret, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createCustomJwtToken
     * @param requestBody  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCustomJwtTokenCall(Map<String, Object> requestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/api/tokens/custom/jwt";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "access-token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createCustomJwtTokenValidateBeforeCall(Map<String, Object> requestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling createCustomJwtToken(Async)");
        }
        

        okhttp3.Call localVarCall = createCustomJwtTokenCall(requestBody, _callback);
        return localVarCall;

    }

    /**
     * (Backend API) Create JWT token
     * Creates JWT token signed with RSA256 key. RSA key is generated from app secret (specified in kntrl.json5) 
     * @param requestBody  (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public String createCustomJwtToken(Map<String, Object> requestBody) throws ApiException {
        ApiResponse<String> localVarResp = createCustomJwtTokenWithHttpInfo(requestBody);
        return localVarResp.getData();
    }

    /**
     * (Backend API) Create JWT token
     * Creates JWT token signed with RSA256 key. RSA key is generated from app secret (specified in kntrl.json5) 
     * @param requestBody  (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> createCustomJwtTokenWithHttpInfo(Map<String, Object> requestBody) throws ApiException {
        okhttp3.Call localVarCall = createCustomJwtTokenValidateBeforeCall(requestBody, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * (Backend API) Create JWT token (asynchronously)
     * Creates JWT token signed with RSA256 key. RSA key is generated from app secret (specified in kntrl.json5) 
     * @param requestBody  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCustomJwtTokenAsync(Map<String, Object> requestBody, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = createCustomJwtTokenValidateBeforeCall(requestBody, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getCustomJwtPublicKey
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCustomJwtPublicKeyCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/tokens/custom/jwt/public-key";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCustomJwtPublicKeyValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getCustomJwtPublicKeyCall(_callback);
        return localVarCall;

    }

    /**
     * Get JWT public key
     * RSA256 public key generated from app-secret from config used for signature validation. Can be used to verify jwt tokens locally. 
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public String getCustomJwtPublicKey() throws ApiException {
        ApiResponse<String> localVarResp = getCustomJwtPublicKeyWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get JWT public key
     * RSA256 public key generated from app-secret from config used for signature validation. Can be used to verify jwt tokens locally. 
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> getCustomJwtPublicKeyWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getCustomJwtPublicKeyValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get JWT public key (asynchronously)
     * RSA256 public key generated from app-secret from config used for signature validation. Can be used to verify jwt tokens locally. 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCustomJwtPublicKeyAsync(final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCustomJwtPublicKeyValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for parseCustomBinaryToken
     * @param body  (required)
     * @param secret  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call parseCustomBinaryTokenCall(String body, String secret, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/tokens/custom/binary/parse";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (secret != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("secret", secret));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call parseCustomBinaryTokenValidateBeforeCall(String body, String secret, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling parseCustomBinaryToken(Async)");
        }
        

        okhttp3.Call localVarCall = parseCustomBinaryTokenCall(body, secret, _callback);
        return localVarCall;

    }

    /**
     * Parse binary token
     * Validates token signature and extracts token data. See /binary API for details. 
     * @param body  (required)
     * @param secret  (optional)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public String parseCustomBinaryToken(String body, String secret) throws ApiException {
        ApiResponse<String> localVarResp = parseCustomBinaryTokenWithHttpInfo(body, secret);
        return localVarResp.getData();
    }

    /**
     * Parse binary token
     * Validates token signature and extracts token data. See /binary API for details. 
     * @param body  (required)
     * @param secret  (optional)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> parseCustomBinaryTokenWithHttpInfo(String body, String secret) throws ApiException {
        okhttp3.Call localVarCall = parseCustomBinaryTokenValidateBeforeCall(body, secret, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Parse binary token (asynchronously)
     * Validates token signature and extracts token data. See /binary API for details. 
     * @param body  (required)
     * @param secret  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call parseCustomBinaryTokenAsync(String body, String secret, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = parseCustomBinaryTokenValidateBeforeCall(body, secret, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for parseCustomJwtToken
     * @param body  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call parseCustomJwtTokenCall(String body, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/tokens/custom/jwt/parse";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call parseCustomJwtTokenValidateBeforeCall(String body, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling parseCustomJwtToken(Async)");
        }
        

        okhttp3.Call localVarCall = parseCustomJwtTokenCall(body, _callback);
        return localVarCall;

    }

    /**
     * Parse JWT token
     * Validates token signature, expiration time and extracts token data. See /jwt API for details. 
     * @param body  (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public String parseCustomJwtToken(String body) throws ApiException {
        ApiResponse<String> localVarResp = parseCustomJwtTokenWithHttpInfo(body);
        return localVarResp.getData();
    }

    /**
     * Parse JWT token
     * Validates token signature, expiration time and extracts token data. See /jwt API for details. 
     * @param body  (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> parseCustomJwtTokenWithHttpInfo(String body) throws ApiException {
        okhttp3.Call localVarCall = parseCustomJwtTokenValidateBeforeCall(body, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Parse JWT token (asynchronously)
     * Validates token signature, expiration time and extracts token data. See /jwt API for details. 
     * @param body  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call parseCustomJwtTokenAsync(String body, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = parseCustomJwtTokenValidateBeforeCall(body, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
