/*
 * Kntrl API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 0.10.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package app.kntrl.client.openapi.api;

import app.kntrl.client.openapi.infra.ApiCallback;
import app.kntrl.client.openapi.infra.ApiClient;
import app.kntrl.client.openapi.infra.ApiException;
import app.kntrl.client.openapi.infra.ApiResponse;
import app.kntrl.client.openapi.infra.Configuration;
import app.kntrl.client.openapi.infra.Pair;
import app.kntrl.client.openapi.infra.ProgressRequestBody;
import app.kntrl.client.openapi.infra.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import app.kntrl.client.openapi.model.AuthenticateReq;
import app.kntrl.client.openapi.model.AuthenticateRes;
import app.kntrl.client.openapi.model.ClientErr;
import app.kntrl.client.openapi.model.ConfirmSessionAuthsReq;
import app.kntrl.client.openapi.model.FindSessionsRes;
import app.kntrl.client.openapi.model.IntegrationErr;
import app.kntrl.client.openapi.model.NewSessionReq;
import app.kntrl.client.openapi.model.Session;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class SessionApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SessionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SessionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for authenticate
     * @param authenticateReq  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call authenticateCall(AuthenticateReq authenticateReq, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = authenticateReq;

        // create path and map variables
        String localVarPath = "/api/session";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "access-token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call authenticateValidateBeforeCall(AuthenticateReq authenticateReq, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'authenticateReq' is set
        if (authenticateReq == null) {
            throw new ApiException("Missing the required parameter 'authenticateReq' when calling authenticate(Async)");
        }
        

        okhttp3.Call localVarCall = authenticateCall(authenticateReq, _callback);
        return localVarCall;

    }

    /**
     * Authenticate session
     * 
     * @param authenticateReq  (required)
     * @return AuthenticateRes
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public AuthenticateRes authenticate(AuthenticateReq authenticateReq) throws ApiException {
        ApiResponse<AuthenticateRes> localVarResp = authenticateWithHttpInfo(authenticateReq);
        return localVarResp.getData();
    }

    /**
     * Authenticate session
     * 
     * @param authenticateReq  (required)
     * @return ApiResponse&lt;AuthenticateRes&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AuthenticateRes> authenticateWithHttpInfo(AuthenticateReq authenticateReq) throws ApiException {
        okhttp3.Call localVarCall = authenticateValidateBeforeCall(authenticateReq, null);
        Type localVarReturnType = new TypeToken<AuthenticateRes>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Authenticate session (asynchronously)
     * 
     * @param authenticateReq  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call authenticateAsync(AuthenticateReq authenticateReq, final ApiCallback<AuthenticateRes> _callback) throws ApiException {

        okhttp3.Call localVarCall = authenticateValidateBeforeCall(authenticateReq, _callback);
        Type localVarReturnType = new TypeToken<AuthenticateRes>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for confirmSessionAuths
     * @param confirmSessionAuthsReq  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call confirmSessionAuthsCall(ConfirmSessionAuthsReq confirmSessionAuthsReq, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = confirmSessionAuthsReq;

        // create path and map variables
        String localVarPath = "/api/session/auth/confirm";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "access-token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call confirmSessionAuthsValidateBeforeCall(ConfirmSessionAuthsReq confirmSessionAuthsReq, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'confirmSessionAuthsReq' is set
        if (confirmSessionAuthsReq == null) {
            throw new ApiException("Missing the required parameter 'confirmSessionAuthsReq' when calling confirmSessionAuths(Async)");
        }
        

        okhttp3.Call localVarCall = confirmSessionAuthsCall(confirmSessionAuthsReq, _callback);
        return localVarCall;

    }

    /**
     * Confirm with code
     * Confirm auth with received code. To get code id, check response of sign in / sign up / authenticate API. 
     * @param confirmSessionAuthsReq  (required)
     * @return AuthenticateRes
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public AuthenticateRes confirmSessionAuths(ConfirmSessionAuthsReq confirmSessionAuthsReq) throws ApiException {
        ApiResponse<AuthenticateRes> localVarResp = confirmSessionAuthsWithHttpInfo(confirmSessionAuthsReq);
        return localVarResp.getData();
    }

    /**
     * Confirm with code
     * Confirm auth with received code. To get code id, check response of sign in / sign up / authenticate API. 
     * @param confirmSessionAuthsReq  (required)
     * @return ApiResponse&lt;AuthenticateRes&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AuthenticateRes> confirmSessionAuthsWithHttpInfo(ConfirmSessionAuthsReq confirmSessionAuthsReq) throws ApiException {
        okhttp3.Call localVarCall = confirmSessionAuthsValidateBeforeCall(confirmSessionAuthsReq, null);
        Type localVarReturnType = new TypeToken<AuthenticateRes>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Confirm with code (asynchronously)
     * Confirm auth with received code. To get code id, check response of sign in / sign up / authenticate API. 
     * @param confirmSessionAuthsReq  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call confirmSessionAuthsAsync(ConfirmSessionAuthsReq confirmSessionAuthsReq, final ApiCallback<AuthenticateRes> _callback) throws ApiException {

        okhttp3.Call localVarCall = confirmSessionAuthsValidateBeforeCall(confirmSessionAuthsReq, _callback);
        Type localVarReturnType = new TypeToken<AuthenticateRes>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for delSession
     * @param sessionId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call delSessionCall(String sessionId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/session/{session-id}"
            .replaceAll("\\{" + "session-id" + "\\}", localVarApiClient.escapeString(sessionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "access-token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call delSessionValidateBeforeCall(String sessionId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'sessionId' is set
        if (sessionId == null) {
            throw new ApiException("Missing the required parameter 'sessionId' when calling delSession(Async)");
        }
        

        okhttp3.Call localVarCall = delSessionCall(sessionId, _callback);
        return localVarCall;

    }

    /**
     * Sign out another session
     * 
     * @param sessionId  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public Object delSession(String sessionId) throws ApiException {
        ApiResponse<Object> localVarResp = delSessionWithHttpInfo(sessionId);
        return localVarResp.getData();
    }

    /**
     * Sign out another session
     * 
     * @param sessionId  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> delSessionWithHttpInfo(String sessionId) throws ApiException {
        okhttp3.Call localVarCall = delSessionValidateBeforeCall(sessionId, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Sign out another session (asynchronously)
     * 
     * @param sessionId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call delSessionAsync(String sessionId, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = delSessionValidateBeforeCall(sessionId, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAll
     * @param entry  (optional)
     * @param userId  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllCall(String entry, String userId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/session/all";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (entry != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("entry", entry));
        }

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userId", userId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "access-token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllValidateBeforeCall(String entry, String userId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAllCall(entry, userId, _callback);
        return localVarCall;

    }

    /**
     * List sessions
     * 
     * @param entry  (optional)
     * @param userId  (optional)
     * @return FindSessionsRes
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public FindSessionsRes getAll(String entry, String userId) throws ApiException {
        ApiResponse<FindSessionsRes> localVarResp = getAllWithHttpInfo(entry, userId);
        return localVarResp.getData();
    }

    /**
     * List sessions
     * 
     * @param entry  (optional)
     * @param userId  (optional)
     * @return ApiResponse&lt;FindSessionsRes&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FindSessionsRes> getAllWithHttpInfo(String entry, String userId) throws ApiException {
        okhttp3.Call localVarCall = getAllValidateBeforeCall(entry, userId, null);
        Type localVarReturnType = new TypeToken<FindSessionsRes>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List sessions (asynchronously)
     * 
     * @param entry  (optional)
     * @param userId  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllAsync(String entry, String userId, final ApiCallback<FindSessionsRes> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllValidateBeforeCall(entry, userId, _callback);
        Type localVarReturnType = new TypeToken<FindSessionsRes>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSession
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSessionCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/session";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "access-token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSessionValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getSessionCall(_callback);
        return localVarCall;

    }

    /**
     * Get session
     * Get current session data. 
     * @return Session
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public Session getSession() throws ApiException {
        ApiResponse<Session> localVarResp = getSessionWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get session
     * Get current session data. 
     * @return ApiResponse&lt;Session&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Session> getSessionWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getSessionValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Session>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get session (asynchronously)
     * Get current session data. 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSessionAsync(final ApiCallback<Session> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSessionValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Session>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for newSession
     * @param newSessionReq  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call newSessionCall(NewSessionReq newSessionReq, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = newSessionReq;

        // create path and map variables
        String localVarPath = "/api/session";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "access-token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call newSessionValidateBeforeCall(NewSessionReq newSessionReq, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'newSessionReq' is set
        if (newSessionReq == null) {
            throw new ApiException("Missing the required parameter 'newSessionReq' when calling newSession(Async)");
        }
        

        okhttp3.Call localVarCall = newSessionCall(newSessionReq, _callback);
        return localVarCall;

    }

    /**
     * New session
     * Create new session. if session entry requires another entry, access token must be provided. 
     * @param newSessionReq  (required)
     * @return AuthenticateRes
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public AuthenticateRes newSession(NewSessionReq newSessionReq) throws ApiException {
        ApiResponse<AuthenticateRes> localVarResp = newSessionWithHttpInfo(newSessionReq);
        return localVarResp.getData();
    }

    /**
     * New session
     * Create new session. if session entry requires another entry, access token must be provided. 
     * @param newSessionReq  (required)
     * @return ApiResponse&lt;AuthenticateRes&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AuthenticateRes> newSessionWithHttpInfo(NewSessionReq newSessionReq) throws ApiException {
        okhttp3.Call localVarCall = newSessionValidateBeforeCall(newSessionReq, null);
        Type localVarReturnType = new TypeToken<AuthenticateRes>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * New session (asynchronously)
     * Create new session. if session entry requires another entry, access token must be provided. 
     * @param newSessionReq  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call newSessionAsync(NewSessionReq newSessionReq, final ApiCallback<AuthenticateRes> _callback) throws ApiException {

        okhttp3.Call localVarCall = newSessionValidateBeforeCall(newSessionReq, _callback);
        Type localVarReturnType = new TypeToken<AuthenticateRes>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for signOut
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call signOutCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/session";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "access-token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call signOutValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = signOutCall(_callback);
        return localVarCall;

    }

    /**
     * Sign out current session
     * 
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public Object signOut() throws ApiException {
        ApiResponse<Object> localVarResp = signOutWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Sign out current session
     * 
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> signOutWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = signOutValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Sign out current session (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 4XX </td><td> Client error </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> Server error </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call signOutAsync(final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = signOutValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
