/*
 * Kntrl API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 0.10.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package app.kntrl.client.openapi.model;

import java.util.Objects;
import java.util.Arrays;
import app.kntrl.client.openapi.model.CodeCfg;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import app.kntrl.client.openapi.infra.JSON;

/**
 * Authentication implementation config
 */
@ApiModel(description = "Authentication implementation config")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class RemoteAuthCfg {
  public static final String SERIALIZED_NAME_REMOTE = "remote";
  @SerializedName(SERIALIZED_NAME_REMOTE)
  private String remote;

  public static final String SERIALIZED_NAME_REQUIRES_AUTH = "requiresAuth";
  @SerializedName(SERIALIZED_NAME_REQUIRES_AUTH)
  private List<List<String>> requiresAuth = null;

  public static final String SERIALIZED_NAME_SKIP_ON_FAIL = "skipOnFail";
  @SerializedName(SERIALIZED_NAME_SKIP_ON_FAIL)
  private Boolean skipOnFail = false;

  public static final String SERIALIZED_NAME_RATE_LIMITER = "rateLimiter";
  @SerializedName(SERIALIZED_NAME_RATE_LIMITER)
  private String rateLimiter;

  public static final String SERIALIZED_NAME_BURN_QUOTA = "burnQuota";
  @SerializedName(SERIALIZED_NAME_BURN_QUOTA)
  private Double burnQuota = 0.0d;

  public static final String SERIALIZED_NAME_QUERY = "query";
  @SerializedName(SERIALIZED_NAME_QUERY)
  private Map<String, String> query = null;

  public static final String SERIALIZED_NAME_HEADERS = "headers";
  @SerializedName(SERIALIZED_NAME_HEADERS)
  private Map<String, String> headers = null;

  public static final String SERIALIZED_NAME_CODE = "code";
  @SerializedName(SERIALIZED_NAME_CODE)
  private CodeCfg code;

  public RemoteAuthCfg() {
  }

  public RemoteAuthCfg remote(String remote) {
    
    this.remote = remote;
    return this;
  }

   /**
   * Path to the API that implements plugin.
   * @return remote
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Path to the API that implements plugin.")

  public String getRemote() {
    return remote;
  }


  public void setRemote(String remote) {
    this.remote = remote;
  }


  public RemoteAuthCfg requiresAuth(List<List<String>> requiresAuth) {
    
    this.requiresAuth = requiresAuth;
    return this;
  }

  public RemoteAuthCfg addRequiresAuthItem(List<String> requiresAuthItem) {
    if (this.requiresAuth == null) {
      this.requiresAuth = new ArrayList<>();
    }
    this.requiresAuth.add(requiresAuthItem);
    return this;
  }

   /**
   * If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -&gt; require specified auth to be enabled before this. - array of strings -&gt; require any of listed auths to be enabled - array of arrays of strings -&gt; works as &#x60;[ [ \&quot;auth1\&quot; and \&quot;auth2\&quot; ] or [ \&quot;auth1\&quot; and \&quot;auth2\&quot; ] ]&#x60;
   * @return requiresAuth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -> require specified auth to be enabled before this. - array of strings -> require any of listed auths to be enabled - array of arrays of strings -> works as `[ [ \"auth1\" and \"auth2\" ] or [ \"auth1\" and \"auth2\" ] ]`")

  public List<List<String>> getRequiresAuth() {
    return requiresAuth;
  }


  public void setRequiresAuth(List<List<String>> requiresAuth) {
    this.requiresAuth = requiresAuth;
  }


  public RemoteAuthCfg skipOnFail(Boolean skipOnFail) {
    
    this.skipOnFail = skipOnFail;
    return this;
  }

   /**
   * When this is set to true app will attempt next auth in case of error on current. It&#39;s works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.
   * @return skipOnFail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "When this is set to true app will attempt next auth in case of error on current. It's works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.")

  public Boolean getSkipOnFail() {
    return skipOnFail;
  }


  public void setSkipOnFail(Boolean skipOnFail) {
    this.skipOnFail = skipOnFail;
  }


  public RemoteAuthCfg rateLimiter(String rateLimiter) {
    
    this.rateLimiter = rateLimiter;
    return this;
  }

   /**
   * Apply rate limiter for this auth.
   * @return rateLimiter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Apply rate limiter for this auth.")

  public String getRateLimiter() {
    return rateLimiter;
  }


  public void setRateLimiter(String rateLimiter) {
    this.rateLimiter = rateLimiter;
  }


  public RemoteAuthCfg burnQuota(Double burnQuota) {
    
    this.burnQuota = burnQuota;
    return this;
  }

   /**
   * Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified
   * @return burnQuota
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified")

  public Double getBurnQuota() {
    return burnQuota;
  }


  public void setBurnQuota(Double burnQuota) {
    this.burnQuota = burnQuota;
  }


  public RemoteAuthCfg query(Map<String, String> query) {
    
    this.query = query;
    return this;
  }

  public RemoteAuthCfg putQueryItem(String key, String queryItem) {
    if (this.query == null) {
      this.query = new HashMap<>();
    }
    this.query.put(key, queryItem);
    return this;
  }

   /**
   * Add query params after &#x60;?&#x60; symbol in url. 
   * @return query
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Add query params after `?` symbol in url. ")

  public Map<String, String> getQuery() {
    return query;
  }


  public void setQuery(Map<String, String> query) {
    this.query = query;
  }


  public RemoteAuthCfg headers(Map<String, String> headers) {
    
    this.headers = headers;
    return this;
  }

  public RemoteAuthCfg putHeadersItem(String key, String headersItem) {
    if (this.headers == null) {
      this.headers = new HashMap<>();
    }
    this.headers.put(key, headersItem);
    return this;
  }

   /**
   * Add headers to request. 
   * @return headers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Add headers to request. ")

  public Map<String, String> getHeaders() {
    return headers;
  }


  public void setHeaders(Map<String, String> headers) {
    this.headers = headers;
  }


  public RemoteAuthCfg code(CodeCfg code) {
    
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public CodeCfg getCode() {
    return code;
  }


  public void setCode(CodeCfg code) {
    this.code = code;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public RemoteAuthCfg putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RemoteAuthCfg remoteAuthCfg = (RemoteAuthCfg) o;
    return Objects.equals(this.remote, remoteAuthCfg.remote) &&
        Objects.equals(this.requiresAuth, remoteAuthCfg.requiresAuth) &&
        Objects.equals(this.skipOnFail, remoteAuthCfg.skipOnFail) &&
        Objects.equals(this.rateLimiter, remoteAuthCfg.rateLimiter) &&
        Objects.equals(this.burnQuota, remoteAuthCfg.burnQuota) &&
        Objects.equals(this.query, remoteAuthCfg.query) &&
        Objects.equals(this.headers, remoteAuthCfg.headers) &&
        Objects.equals(this.code, remoteAuthCfg.code)&&
        Objects.equals(this.additionalProperties, remoteAuthCfg.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(remote, requiresAuth, skipOnFail, rateLimiter, burnQuota, query, headers, code, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RemoteAuthCfg {\n");
    sb.append("    remote: ").append(toIndentedString(remote)).append("\n");
    sb.append("    requiresAuth: ").append(toIndentedString(requiresAuth)).append("\n");
    sb.append("    skipOnFail: ").append(toIndentedString(skipOnFail)).append("\n");
    sb.append("    rateLimiter: ").append(toIndentedString(rateLimiter)).append("\n");
    sb.append("    burnQuota: ").append(toIndentedString(burnQuota)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("remote");
    openapiFields.add("requiresAuth");
    openapiFields.add("skipOnFail");
    openapiFields.add("rateLimiter");
    openapiFields.add("burnQuota");
    openapiFields.add("query");
    openapiFields.add("headers");
    openapiFields.add("code");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("remote");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to RemoteAuthCfg
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (RemoteAuthCfg.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in RemoteAuthCfg is not found in the empty JSON string", RemoteAuthCfg.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : RemoteAuthCfg.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if ((jsonObj.get("remote") != null && !jsonObj.get("remote").isJsonNull()) && !jsonObj.get("remote").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `remote` to be a primitive type in the JSON string but got `%s`", jsonObj.get("remote").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("requiresAuth") != null && !jsonObj.get("requiresAuth").isJsonNull()) && !jsonObj.get("requiresAuth").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `requiresAuth` to be an array in the JSON string but got `%s`", jsonObj.get("requiresAuth").toString()));
      }
      if ((jsonObj.get("rateLimiter") != null && !jsonObj.get("rateLimiter").isJsonNull()) && !jsonObj.get("rateLimiter").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `rateLimiter` to be a primitive type in the JSON string but got `%s`", jsonObj.get("rateLimiter").toString()));
      }
      // validate the optional field `code`
      if (jsonObj.get("code") != null && !jsonObj.get("code").isJsonNull()) {
        CodeCfg.validateJsonObject(jsonObj.getAsJsonObject("code"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RemoteAuthCfg.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RemoteAuthCfg' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RemoteAuthCfg> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RemoteAuthCfg.class));

       return (TypeAdapter<T>) new TypeAdapter<RemoteAuthCfg>() {
           @Override
           public void write(JsonWriter out, RemoteAuthCfg value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public RemoteAuthCfg read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             RemoteAuthCfg instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RemoteAuthCfg given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RemoteAuthCfg
  * @throws IOException if the JSON string is invalid with respect to RemoteAuthCfg
  */
  public static RemoteAuthCfg fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RemoteAuthCfg.class);
  }

 /**
  * Convert an instance of RemoteAuthCfg to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

