/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Short-living token used for authentication.")
public class AccessTokenCfg {
    public static final String SERIALIZED_NAME_COOKIE = "cookie";
    @SerializedName(value="cookie")
    private Boolean cookie = false;
    public static final String SERIALIZED_NAME_CACHE = "cache";
    @SerializedName(value="cache")
    private CacheEnum cache;
    public static final String SERIALIZED_NAME_CACHE_UNAUTHENTICATED = "cacheUnauthenticated";
    @SerializedName(value="cacheUnauthenticated")
    private Boolean cacheUnauthenticated = false;
    public static final String SERIALIZED_NAME_TTL = "ttl";
    @SerializedName(value="ttl")
    private String ttl = "1d";
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AccessTokenCfg cookie(Boolean cookie) {
        this.cookie = cookie;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Send token in `access_token` cookie")
    public Boolean getCookie() {
        return this.cookie;
    }

    public void setCookie(Boolean cookie) {
        this.cookie = cookie;
    }

    public AccessTokenCfg cache(CacheEnum cache) {
        this.cache = cache;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If not null - access token contains signed session data, so it's not required to request session database for access check.")
    public CacheEnum getCache() {
        return this.cache;
    }

    public void setCache(CacheEnum cache) {
        this.cache = cache;
    }

    public AccessTokenCfg cacheUnauthenticated(Boolean cacheUnauthenticated) {
        this.cacheUnauthenticated = cacheUnauthenticated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="By default, unauthenticated sessions can't be cached.")
    public Boolean getCacheUnauthenticated() {
        return this.cacheUnauthenticated;
    }

    public void setCacheUnauthenticated(Boolean cacheUnauthenticated) {
        this.cacheUnauthenticated = cacheUnauthenticated;
    }

    public AccessTokenCfg ttl(String ttl) {
        this.ttl = ttl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1d", value="Lifetime for access token. 1d, 30m, etc. ")
    public String getTtl() {
        return this.ttl;
    }

    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public AccessTokenCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessTokenCfg accessTokenCfg = (AccessTokenCfg)o;
        return Objects.equals(this.cookie, accessTokenCfg.cookie) && Objects.equals((Object)this.cache, (Object)accessTokenCfg.cache) && Objects.equals(this.cacheUnauthenticated, accessTokenCfg.cacheUnauthenticated) && Objects.equals(this.ttl, accessTokenCfg.ttl) && Objects.equals(this.additionalProperties, accessTokenCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cookie, this.cache, this.cacheUnauthenticated, this.ttl, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessTokenCfg {\n");
        sb.append("    cookie: ").append(this.toIndentedString(this.cookie)).append("\n");
        sb.append("    cache: ").append(this.toIndentedString((Object)this.cache)).append("\n");
        sb.append("    cacheUnauthenticated: ").append(this.toIndentedString(this.cacheUnauthenticated)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccessTokenCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CACHE) != null && !jsonObj.get(SERIALIZED_NAME_CACHE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CACHE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cache` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CACHE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TTL) != null && !jsonObj.get(SERIALIZED_NAME_TTL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TTL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ttl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TTL).toString()));
        }
    }

    public static AccessTokenCfg fromJson(String jsonString) throws IOException {
        return (AccessTokenCfg)JSON.getGson().fromJson(jsonString, AccessTokenCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COOKIE);
        openapiFields.add(SERIALIZED_NAME_CACHE);
        openapiFields.add(SERIALIZED_NAME_CACHE_UNAUTHENTICATED);
        openapiFields.add(SERIALIZED_NAME_TTL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AccessTokenCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccessTokenCfg.class));
            return new TypeAdapter<AccessTokenCfg>(){

                public void write(JsonWriter out, AccessTokenCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public AccessTokenCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AccessTokenCfg.validateJsonObject(jsonObj);
                    AccessTokenCfg instance = (AccessTokenCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CacheEnum {
        JWT("JWT"),
        BINARY("BINARY");

        private String value;

        private CacheEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CacheEnum fromValue(String value) {
            for (CacheEnum b : CacheEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CacheEnum> {
            public void write(JsonWriter jsonWriter, CacheEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CacheEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CacheEnum.fromValue(value);
            }
        }
    }
}

