/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import app.kntrl.client.openapi.model.EntryCfgAccessToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configuration for app entry.")
public class EntryCfg {
    public static final String SERIALIZED_NAME_FACTORS_REQUIRED = "factorsRequired";
    @SerializedName(value="factorsRequired")
    private Map<String, List<String>> factorsRequired = null;
    public static final String SERIALIZED_NAME_FACTORS_OPTIONAL = "factorsOptional";
    @SerializedName(value="factorsOptional")
    private Map<String, List<String>> factorsOptional = null;
    public static final String SERIALIZED_NAME_REQUIRES_ENTRY = "requiresEntry";
    @SerializedName(value="requiresEntry")
    private List<String> requiresEntry = null;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "accessToken";
    @SerializedName(value="accessToken")
    private EntryCfgAccessToken accessToken;
    public static final String SERIALIZED_NAME_TTL = "ttl";
    @SerializedName(value="ttl")
    private String ttl;
    public static final String SERIALIZED_NAME_EDIT_ACCOUNT = "editAccount";
    @SerializedName(value="editAccount")
    private Boolean editAccount = false;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EntryCfg factorsRequired(Map<String, List<String>> factorsRequired) {
        this.factorsRequired = factorsRequired;
        return this;
    }

    public EntryCfg putFactorsRequiredItem(String key, List<String> factorsRequiredItem) {
        if (this.factorsRequired == null) {
            this.factorsRequired = new HashMap<String, List<String>>();
        }
        this.factorsRequired.put(key, factorsRequiredItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"first\":[\"password\",\"facebook\",\"email\"]}", value="Specifies factors that always required to be authenticated.  Usually it's main auth method (e.g. password) + social login (e.g. facebook) + reserve auth option in case of lost/forgotten main auth credentials (e.g. secret questions or email auth).  These factors are always required even when user hasn't enabled them explicitly.  ")
    public Map<String, List<String>> getFactorsRequired() {
        return this.factorsRequired;
    }

    public void setFactorsRequired(Map<String, List<String>> factorsRequired) {
        this.factorsRequired = factorsRequired;
    }

    public EntryCfg factorsOptional(Map<String, List<String>> factorsOptional) {
        this.factorsOptional = factorsOptional;
        return this;
    }

    public EntryCfg putFactorsOptionalItem(String key, List<String> factorsOptionalItem) {
        if (this.factorsOptional == null) {
            this.factorsOptional = new HashMap<String, List<String>>();
        }
        this.factorsOptional.put(key, factorsOptionalItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"second\":[\"sms\"]}", value="This factors can be skipped if user hasn't enabled them. Used for optional 2FA. E.g. If user added mobile phone -> use it for 2FA otherwise skip 2FA. ")
    public Map<String, List<String>> getFactorsOptional() {
        return this.factorsOptional;
    }

    public void setFactorsOptional(Map<String, List<String>> factorsOptional) {
        this.factorsOptional = factorsOptional;
    }

    public EntryCfg requiresEntry(List<String> requiresEntry) {
        this.requiresEntry = requiresEntry;
        return this;
    }

    public EntryCfg addRequiresEntryItem(String requiresEntryItem) {
        if (this.requiresEntry == null) {
            this.requiresEntry = new ArrayList<String>();
        }
        this.requiresEntry.add(requiresEntryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Require user to be already signed in by one of the listed entries. Usually it used for action confirmation, e.g. \"payment\" that requires confirmation by sms, requires user to be already signed in (e.g. with entry \"app\".")
    public List<String> getRequiresEntry() {
        return this.requiresEntry;
    }

    public void setRequiresEntry(List<String> requiresEntry) {
        this.requiresEntry = requiresEntry;
    }

    public EntryCfg accessToken(EntryCfgAccessToken accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EntryCfgAccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(EntryCfgAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public EntryCfg ttl(String ttl) {
        this.ttl = ttl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3M", value="Max lifetime of session. ")
    public String getTtl() {
        return this.ttl;
    }

    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public EntryCfg editAccount(Boolean editAccount) {
        this.editAccount = editAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is this session allowed to add/remove new auth, enable/disable factors, etc.?")
    public Boolean getEditAccount() {
        return this.editAccount;
    }

    public void setEditAccount(Boolean editAccount) {
        this.editAccount = editAccount;
    }

    public EntryCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryCfg entryCfg = (EntryCfg)o;
        return Objects.equals(this.factorsRequired, entryCfg.factorsRequired) && Objects.equals(this.factorsOptional, entryCfg.factorsOptional) && Objects.equals(this.requiresEntry, entryCfg.requiresEntry) && Objects.equals(this.accessToken, entryCfg.accessToken) && Objects.equals(this.ttl, entryCfg.ttl) && Objects.equals(this.editAccount, entryCfg.editAccount) && Objects.equals(this.additionalProperties, entryCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.factorsRequired, this.factorsOptional, this.requiresEntry, this.accessToken, this.ttl, this.editAccount, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntryCfg {\n");
        sb.append("    factorsRequired: ").append(this.toIndentedString(this.factorsRequired)).append("\n");
        sb.append("    factorsOptional: ").append(this.toIndentedString(this.factorsOptional)).append("\n");
        sb.append("    requiresEntry: ").append(this.toIndentedString(this.requiresEntry)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("    editAccount: ").append(this.toIndentedString(this.editAccount)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in EntryCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRES_ENTRY) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRES_ENTRY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUIRES_ENTRY).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requiresEntry` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRES_ENTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).isJsonNull()) {
            EntryCfgAccessToken.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS_TOKEN));
        }
        if (jsonObj.get(SERIALIZED_NAME_TTL) != null && !jsonObj.get(SERIALIZED_NAME_TTL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TTL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ttl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TTL).toString()));
        }
    }

    public static EntryCfg fromJson(String jsonString) throws IOException {
        return (EntryCfg)JSON.getGson().fromJson(jsonString, EntryCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FACTORS_REQUIRED);
        openapiFields.add(SERIALIZED_NAME_FACTORS_OPTIONAL);
        openapiFields.add(SERIALIZED_NAME_REQUIRES_ENTRY);
        openapiFields.add(SERIALIZED_NAME_ACCESS_TOKEN);
        openapiFields.add(SERIALIZED_NAME_TTL);
        openapiFields.add(SERIALIZED_NAME_EDIT_ACCOUNT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!EntryCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EntryCfg.class));
            return new TypeAdapter<EntryCfg>(){

                public void write(JsonWriter out, EntryCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public EntryCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    EntryCfg.validateJsonObject(jsonObj);
                    EntryCfg instance = (EntryCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

