/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Requirements for password")
public class PasswordStrengthRequirements {
    public static final String SERIALIZED_NAME_MIN_LENGTH = "minLength";
    @SerializedName(value="minLength")
    private Integer minLength = 6;
    public static final String SERIALIZED_NAME_REQUIRE_NUMBER = "requireNumber";
    @SerializedName(value="requireNumber")
    private Boolean requireNumber = false;
    public static final String SERIALIZED_NAME_REQUIRE_SYMBOL = "requireSymbol";
    @SerializedName(value="requireSymbol")
    private Boolean requireSymbol = false;
    public static final String SERIALIZED_NAME_REQUIRE_UPPER_CASE = "requireUpperCase";
    @SerializedName(value="requireUpperCase")
    private Boolean requireUpperCase = false;
    public static final String SERIALIZED_NAME_FORBID_COMMON_PASSWORDS = "forbidCommonPasswords";
    @SerializedName(value="forbidCommonPasswords")
    private Boolean forbidCommonPasswords = false;
    public static final String SERIALIZED_NAME_FORBID_LOGIN_AS_PASSWORD = "forbidLoginAsPassword";
    @SerializedName(value="forbidLoginAsPassword")
    private Boolean forbidLoginAsPassword = false;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PasswordStrengthRequirements minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimal length of password")
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public PasswordStrengthRequirements requireNumber(Boolean requireNumber) {
        this.requireNumber = requireNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Require password to contain at least one digit.")
    public Boolean getRequireNumber() {
        return this.requireNumber;
    }

    public void setRequireNumber(Boolean requireNumber) {
        this.requireNumber = requireNumber;
    }

    public PasswordStrengthRequirements requireSymbol(Boolean requireSymbol) {
        this.requireSymbol = requireSymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Require password to contain at least one symbol e.g. @, !, &...")
    public Boolean getRequireSymbol() {
        return this.requireSymbol;
    }

    public void setRequireSymbol(Boolean requireSymbol) {
        this.requireSymbol = requireSymbol;
    }

    public PasswordStrengthRequirements requireUpperCase(Boolean requireUpperCase) {
        this.requireUpperCase = requireUpperCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This requires password to contain both lowercase and uppercase letters.")
    public Boolean getRequireUpperCase() {
        return this.requireUpperCase;
    }

    public void setRequireUpperCase(Boolean requireUpperCase) {
        this.requireUpperCase = requireUpperCase;
    }

    public PasswordStrengthRequirements forbidCommonPasswords(Boolean forbidCommonPasswords) {
        this.forbidCommonPasswords = forbidCommonPasswords;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Password will be checked against table 1,000,000 of most overused passwords.")
    public Boolean getForbidCommonPasswords() {
        return this.forbidCommonPasswords;
    }

    public void setForbidCommonPasswords(Boolean forbidCommonPasswords) {
        this.forbidCommonPasswords = forbidCommonPasswords;
    }

    public PasswordStrengthRequirements forbidLoginAsPassword(Boolean forbidLoginAsPassword) {
        this.forbidLoginAsPassword = forbidLoginAsPassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rejects passwords that match username, email, anything that used as a login according to logins config.")
    public Boolean getForbidLoginAsPassword() {
        return this.forbidLoginAsPassword;
    }

    public void setForbidLoginAsPassword(Boolean forbidLoginAsPassword) {
        this.forbidLoginAsPassword = forbidLoginAsPassword;
    }

    public PasswordStrengthRequirements putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordStrengthRequirements passwordStrengthRequirements = (PasswordStrengthRequirements)o;
        return Objects.equals(this.minLength, passwordStrengthRequirements.minLength) && Objects.equals(this.requireNumber, passwordStrengthRequirements.requireNumber) && Objects.equals(this.requireSymbol, passwordStrengthRequirements.requireSymbol) && Objects.equals(this.requireUpperCase, passwordStrengthRequirements.requireUpperCase) && Objects.equals(this.forbidCommonPasswords, passwordStrengthRequirements.forbidCommonPasswords) && Objects.equals(this.forbidLoginAsPassword, passwordStrengthRequirements.forbidLoginAsPassword) && Objects.equals(this.additionalProperties, passwordStrengthRequirements.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.minLength, this.requireNumber, this.requireSymbol, this.requireUpperCase, this.forbidCommonPasswords, this.forbidLoginAsPassword, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordStrengthRequirements {\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    requireNumber: ").append(this.toIndentedString(this.requireNumber)).append("\n");
        sb.append("    requireSymbol: ").append(this.toIndentedString(this.requireSymbol)).append("\n");
        sb.append("    requireUpperCase: ").append(this.toIndentedString(this.requireUpperCase)).append("\n");
        sb.append("    forbidCommonPasswords: ").append(this.toIndentedString(this.forbidCommonPasswords)).append("\n");
        sb.append("    forbidLoginAsPassword: ").append(this.toIndentedString(this.forbidLoginAsPassword)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PasswordStrengthRequirements is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
    }

    public static PasswordStrengthRequirements fromJson(String jsonString) throws IOException {
        return (PasswordStrengthRequirements)JSON.getGson().fromJson(jsonString, PasswordStrengthRequirements.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MIN_LENGTH);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_UPPER_CASE);
        openapiFields.add(SERIALIZED_NAME_FORBID_COMMON_PASSWORDS);
        openapiFields.add(SERIALIZED_NAME_FORBID_LOGIN_AS_PASSWORD);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!PasswordStrengthRequirements.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PasswordStrengthRequirements.class));
            return new TypeAdapter<PasswordStrengthRequirements>(){

                public void write(JsonWriter out, PasswordStrengthRequirements value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public PasswordStrengthRequirements read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PasswordStrengthRequirements.validateJsonObject(jsonObj);
                    PasswordStrengthRequirements instance = (PasswordStrengthRequirements)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

