/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import app.kntrl.client.openapi.model.CodeCfg;
import app.kntrl.client.openapi.model.OAuthCfgExchangeAuthCode;
import app.kntrl.client.openapi.model.OAuthCfgUserInfo;
import app.kntrl.client.openapi.model.PasswordHistoryCfg;
import app.kntrl.client.openapi.model.PasswordStrengthRequirements;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ShAppCfgAuthsValue {
    public static final String SERIALIZED_NAME_REMOTE = "remote";
    @SerializedName(value="remote")
    private String remote;
    public static final String SERIALIZED_NAME_REQUIRES_AUTH = "requiresAuth";
    @SerializedName(value="requiresAuth")
    private List<List<String>> requiresAuth = null;
    public static final String SERIALIZED_NAME_SKIP_ON_FAIL = "skipOnFail";
    @SerializedName(value="skipOnFail")
    private Boolean skipOnFail = false;
    public static final String SERIALIZED_NAME_RATE_LIMITER = "rateLimiter";
    @SerializedName(value="rateLimiter")
    private String rateLimiter;
    public static final String SERIALIZED_NAME_BURN_QUOTA = "burnQuota";
    @SerializedName(value="burnQuota")
    private Double burnQuota = 0.0;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private Map<String, String> query = null;
    public static final String SERIALIZED_NAME_HEADERS = "headers";
    @SerializedName(value="headers")
    private Map<String, String> headers = null;
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private CodeCfg code;
    public static final String SERIALIZED_NAME_CODE_TTL = "codeTtl";
    @SerializedName(value="codeTtl")
    private String codeTtl = "10m";
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private List<String> scopes = null;
    public static final String SERIALIZED_NAME_SERVER = "server";
    @SerializedName(value="server")
    private String server;
    public static final String SERIALIZED_NAME_SENDER = "sender";
    @SerializedName(value="sender")
    private String sender;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_CONFIRMATION_URL = "confirmationUrl";
    @SerializedName(value="confirmationUrl")
    private String confirmationUrl;
    public static final String SERIALIZED_NAME_TEMPLATES = "templates";
    @SerializedName(value="templates")
    private Map<String, String> templates = null;
    public static final String SERIALIZED_NAME_TEMPLATE_PARAMS = "templateParams";
    @SerializedName(value="templateParams")
    private Map<String, Object> templateParams = null;
    public static final String SERIALIZED_NAME_IP_BYTES_TO_IGNORE = "ipBytesToIgnore";
    @SerializedName(value="ipBytesToIgnore")
    private Integer ipBytesToIgnore = 0;
    public static final String SERIALIZED_NAME_HISTORY_SIZE = "historySize";
    @SerializedName(value="historySize")
    private Integer historySize = 10;
    public static final String SERIALIZED_NAME_EXCHANGE_AUTH_CODE = "exchangeAuthCode";
    @SerializedName(value="exchangeAuthCode")
    private OAuthCfgExchangeAuthCode exchangeAuthCode;
    public static final String SERIALIZED_NAME_USER_INFO = "userInfo";
    @SerializedName(value="userInfo")
    private OAuthCfgUserInfo userInfo;
    public static final String SERIALIZED_NAME_EXTRACT_LOGIN = "extractLogin";
    @SerializedName(value="extractLogin")
    private String extractLogin;
    public static final String SERIALIZED_NAME_EXTRACT_PUBLIC_DATA = "extractPublicData";
    @SerializedName(value="extractPublicData")
    private Map<String, String> extractPublicData = null;
    public static final String SERIALIZED_NAME_MAX_LENGTH = "maxLength";
    @SerializedName(value="maxLength")
    private Integer maxLength = 256;
    public static final String SERIALIZED_NAME_MIN_LENGTH = "minLength";
    @SerializedName(value="minLength")
    private Integer minLength = 3;
    public static final String SERIALIZED_NAME_REQUIRE_NUMBER = "requireNumber";
    @SerializedName(value="requireNumber")
    private Boolean requireNumber = false;
    public static final String SERIALIZED_NAME_REQUIRE_SYMBOL = "requireSymbol";
    @SerializedName(value="requireSymbol")
    private Boolean requireSymbol = false;
    public static final String SERIALIZED_NAME_REQUIRE_UPPER_CASE = "requireUpperCase";
    @SerializedName(value="requireUpperCase")
    private Boolean requireUpperCase = false;
    public static final String SERIALIZED_NAME_FORBID_COMMON_PASSWORDS = "forbidCommonPasswords";
    @SerializedName(value="forbidCommonPasswords")
    private Boolean forbidCommonPasswords = false;
    public static final String SERIALIZED_NAME_FORBID_LOGIN_AS_PASSWORD = "forbidLoginAsPassword";
    @SerializedName(value="forbidLoginAsPassword")
    private Boolean forbidLoginAsPassword = false;
    public static final String SERIALIZED_NAME_FORBID_REUSING_PASSWORD = "forbidReusingPassword";
    @SerializedName(value="forbidReusingPassword")
    private PasswordHistoryCfg forbidReusingPassword;
    public static final String SERIALIZED_NAME_STRENGTH = "strength";
    @SerializedName(value="strength")
    private Map<String, PasswordStrengthRequirements> strength = null;
    public static final String SERIALIZED_NAME_LOWERCASE = "lowercase";
    @SerializedName(value="lowercase")
    private Boolean lowercase = true;
    public static final String SERIALIZED_NAME_REMOVE_SYMBOLS = "removeSymbols";
    @SerializedName(value="removeSymbols")
    private Boolean removeSymbols = true;
    public static final String SERIALIZED_NAME_REMOVE_SPACES = "removeSpaces";
    @SerializedName(value="removeSpaces")
    private Boolean removeSpaces = true;
    public static final String SERIALIZED_NAME_ANSWERS_REQUIRED = "answersRequired";
    @SerializedName(value="answersRequired")
    private Integer answersRequired = 2;
    public static final String SERIALIZED_NAME_MAX_ANSWERS = "maxAnswers";
    @SerializedName(value="maxAnswers")
    private Integer maxAnswers = 10;
    public static final String SERIALIZED_NAME_ENCRYPT_KEY = "encryptKey";
    @SerializedName(value="encryptKey")
    private String encryptKey = "<change_me>";
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ShAppCfgAuthsValue remote(String remote) {
        this.remote = remote;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to the API that implements plugin.")
    public String getRemote() {
        return this.remote;
    }

    public void setRemote(String remote) {
        this.remote = remote;
    }

    public ShAppCfgAuthsValue requiresAuth(List<List<String>> requiresAuth) {
        this.requiresAuth = requiresAuth;
        return this;
    }

    public ShAppCfgAuthsValue addRequiresAuthItem(List<String> requiresAuthItem) {
        if (this.requiresAuth == null) {
            this.requiresAuth = new ArrayList<List<String>>();
        }
        this.requiresAuth.add(requiresAuthItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -> require specified auth to be enabled before this. - array of strings -> require any of listed auths to be enabled - array of arrays of strings -> works as `[ [ \"auth1\" and \"auth2\" ] or [ \"auth1\" and \"auth2\" ] ]`")
    public List<List<String>> getRequiresAuth() {
        return this.requiresAuth;
    }

    public void setRequiresAuth(List<List<String>> requiresAuth) {
        this.requiresAuth = requiresAuth;
    }

    public ShAppCfgAuthsValue skipOnFail(Boolean skipOnFail) {
        this.skipOnFail = skipOnFail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When this is set to true app will attempt next auth in case of error on current. It's works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.")
    public Boolean getSkipOnFail() {
        return this.skipOnFail;
    }

    public void setSkipOnFail(Boolean skipOnFail) {
        this.skipOnFail = skipOnFail;
    }

    public ShAppCfgAuthsValue rateLimiter(String rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply rate limiter for this auth.")
    public String getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(String rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public ShAppCfgAuthsValue burnQuota(Double burnQuota) {
        this.burnQuota = burnQuota;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified")
    public Double getBurnQuota() {
        return this.burnQuota;
    }

    public void setBurnQuota(Double burnQuota) {
        this.burnQuota = burnQuota;
    }

    public ShAppCfgAuthsValue query(Map<String, String> query) {
        this.query = query;
        return this;
    }

    public ShAppCfgAuthsValue putQueryItem(String key, String queryItem) {
        if (this.query == null) {
            this.query = new HashMap<String, String>();
        }
        this.query.put(key, queryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Add query params after `?` symbol in url. ")
    public Map<String, String> getQuery() {
        return this.query;
    }

    public void setQuery(Map<String, String> query) {
        this.query = query;
    }

    public ShAppCfgAuthsValue headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public ShAppCfgAuthsValue putHeadersItem(String key, String headersItem) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, headersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Add headers to request. ")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public ShAppCfgAuthsValue code(CodeCfg code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CodeCfg getCode() {
        return this.code;
    }

    public void setCode(CodeCfg code) {
        this.code = code;
    }

    public ShAppCfgAuthsValue codeTtl(String codeTtl) {
        this.codeTtl = codeTtl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authorization code lifetime. ")
    public String getCodeTtl() {
        return this.codeTtl;
    }

    public void setCodeTtl(String codeTtl) {
        this.codeTtl = codeTtl;
    }

    public ShAppCfgAuthsValue scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ShAppCfgAuthsValue addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ShAppCfgAuthsValue server(String server) {
        this.server = server;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Email server address/IP.")
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public ShAppCfgAuthsValue sender(String sender) {
        this.sender = sender;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Email address of sender.")
    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public ShAppCfgAuthsValue username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SMTP username.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ShAppCfgAuthsValue password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SMTP password.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ShAppCfgAuthsValue confirmationUrl(String confirmationUrl) {
        this.confirmationUrl = confirmationUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If not null, server will create template param `confirmationUrl` that will contain query parameters with confirmation code, session id, etc.")
    public String getConfirmationUrl() {
        return this.confirmationUrl;
    }

    public void setConfirmationUrl(String confirmationUrl) {
        this.confirmationUrl = confirmationUrl;
    }

    public ShAppCfgAuthsValue templates(Map<String, String> templates) {
        this.templates = templates;
        return this;
    }

    public ShAppCfgAuthsValue putTemplatesItem(String key, String templatesItem) {
        if (this.templates == null) {
            this.templates = new HashMap<String, String>();
        }
        this.templates.put(key, templatesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"welcome\":\"./welcome.html.hbs\",\"restoreAccess\":\"./restore.html.hbs\"}", value="List of email templates. Key - is name of a template (can be used lately on frontend), value - is path to the template. App uses handlebars templates to generate emails. See docs here https://handlebarsjs.com  Email templates receives `confirmationUrl`, `action`, `user`, `session`, `codeId`, `code`, `codeExpiresInMinutes`, `lang`, `headers` as template params, e.g. you can print user id as `{{user.id}}`.  Template engine also provides `i18n` helper for localisation. E.g. `{{i18n 'confirmationButton' default='Confirm'}}` searches key `confirmationButton` in files specified by `i18n.dir` config.  Use `{{err ERR_CODE msg='Localised message (if null, will be taken from i18n file)' devMsg='dev message'}}` to raise an error in a template.  It allows setting subject of email using `title` html tag, e.g. `<title>Email subject</title>`.  ")
    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public void setTemplates(Map<String, String> templates) {
        this.templates = templates;
    }

    public ShAppCfgAuthsValue templateParams(Map<String, Object> templateParams) {
        this.templateParams = templateParams;
        return this;
    }

    public ShAppCfgAuthsValue putTemplateParamsItem(String key, Object templateParamsItem) {
        if (this.templateParams == null) {
            this.templateParams = new HashMap<String, Object>();
        }
        this.templateParams.put(key, templateParamsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Additional params for templates that can be passed in request. Key - is a name of additional parameter, value - is a default value for this parameter (when no value present in request) ")
    public Map<String, Object> getTemplateParams() {
        return this.templateParams;
    }

    public void setTemplateParams(Map<String, Object> templateParams) {
        this.templateParams = templateParams;
    }

    public ShAppCfgAuthsValue ipBytesToIgnore(Integer ipBytesToIgnore) {
        this.ipBytesToIgnore = ipBytesToIgnore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This allows to drop last bytes of IP. So it allows to authenticate factor when ip has rough match, e.g. the same country, same city, or same internet provider.")
    public Integer getIpBytesToIgnore() {
        return this.ipBytesToIgnore;
    }

    public void setIpBytesToIgnore(Integer ipBytesToIgnore) {
        this.ipBytesToIgnore = ipBytesToIgnore;
    }

    public ShAppCfgAuthsValue historySize(Integer historySize) {
        this.historySize = historySize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="History of IP addresses user used to sign-in. Authenticated when user attempts to sign in with one of stored IPs.")
    public Integer getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(Integer historySize) {
        this.historySize = historySize;
    }

    public ShAppCfgAuthsValue exchangeAuthCode(OAuthCfgExchangeAuthCode exchangeAuthCode) {
        this.exchangeAuthCode = exchangeAuthCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OAuthCfgExchangeAuthCode getExchangeAuthCode() {
        return this.exchangeAuthCode;
    }

    public void setExchangeAuthCode(OAuthCfgExchangeAuthCode exchangeAuthCode) {
        this.exchangeAuthCode = exchangeAuthCode;
    }

    public ShAppCfgAuthsValue userInfo(OAuthCfgUserInfo userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OAuthCfgUserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(OAuthCfgUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public ShAppCfgAuthsValue extractLogin(String extractLogin) {
        this.extractLogin = extractLogin;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="access_token.user_id", value="Json path for login in the exchangeAuthCode or userInfo endpoint response. e.g. `access_token.user.id` extracts user login from `{ \"access_token\": { \"user\": { \"id\": \"...\" } } }` ")
    public String getExtractLogin() {
        return this.extractLogin;
    }

    public void setExtractLogin(String extractLogin) {
        this.extractLogin = extractLogin;
    }

    public ShAppCfgAuthsValue extractPublicData(Map<String, String> extractPublicData) {
        this.extractPublicData = extractPublicData;
        return this;
    }

    public ShAppCfgAuthsValue putExtractPublicDataItem(String key, String extractPublicDataItem) {
        if (this.extractPublicData == null) {
            this.extractPublicData = new HashMap<String, String>();
        }
        this.extractPublicData.put(key, extractPublicDataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"photoUrl:\":\"access_token.user_photo_url\",\"name\":\"access_token.full_name\"}", value="Can fill public data from the exchangeAuthCode or userInfo endpoint response. ")
    public Map<String, String> getExtractPublicData() {
        return this.extractPublicData;
    }

    public void setExtractPublicData(Map<String, String> extractPublicData) {
        this.extractPublicData = extractPublicData;
    }

    public ShAppCfgAuthsValue maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Max length of answer.")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public ShAppCfgAuthsValue minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Min length of answer. Length are checked after all answer transformation.")
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public ShAppCfgAuthsValue requireNumber(Boolean requireNumber) {
        this.requireNumber = requireNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Require password to contain at least one digit.")
    public Boolean getRequireNumber() {
        return this.requireNumber;
    }

    public void setRequireNumber(Boolean requireNumber) {
        this.requireNumber = requireNumber;
    }

    public ShAppCfgAuthsValue requireSymbol(Boolean requireSymbol) {
        this.requireSymbol = requireSymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Require password to contain at least one symbol e.g. @, !, &...")
    public Boolean getRequireSymbol() {
        return this.requireSymbol;
    }

    public void setRequireSymbol(Boolean requireSymbol) {
        this.requireSymbol = requireSymbol;
    }

    public ShAppCfgAuthsValue requireUpperCase(Boolean requireUpperCase) {
        this.requireUpperCase = requireUpperCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This requires password to contain both lowercase and uppercase letters.")
    public Boolean getRequireUpperCase() {
        return this.requireUpperCase;
    }

    public void setRequireUpperCase(Boolean requireUpperCase) {
        this.requireUpperCase = requireUpperCase;
    }

    public ShAppCfgAuthsValue forbidCommonPasswords(Boolean forbidCommonPasswords) {
        this.forbidCommonPasswords = forbidCommonPasswords;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Password will be checked against table 1,000,000 of most overused passwords.")
    public Boolean getForbidCommonPasswords() {
        return this.forbidCommonPasswords;
    }

    public void setForbidCommonPasswords(Boolean forbidCommonPasswords) {
        this.forbidCommonPasswords = forbidCommonPasswords;
    }

    public ShAppCfgAuthsValue forbidLoginAsPassword(Boolean forbidLoginAsPassword) {
        this.forbidLoginAsPassword = forbidLoginAsPassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rejects passwords that match username, email, anything that used as a login according to logins config.")
    public Boolean getForbidLoginAsPassword() {
        return this.forbidLoginAsPassword;
    }

    public void setForbidLoginAsPassword(Boolean forbidLoginAsPassword) {
        this.forbidLoginAsPassword = forbidLoginAsPassword;
    }

    public ShAppCfgAuthsValue forbidReusingPassword(PasswordHistoryCfg forbidReusingPassword) {
        this.forbidReusingPassword = forbidReusingPassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PasswordHistoryCfg getForbidReusingPassword() {
        return this.forbidReusingPassword;
    }

    public void setForbidReusingPassword(PasswordHistoryCfg forbidReusingPassword) {
        this.forbidReusingPassword = forbidReusingPassword;
    }

    public ShAppCfgAuthsValue strength(Map<String, PasswordStrengthRequirements> strength) {
        this.strength = strength;
        return this;
    }

    public ShAppCfgAuthsValue putStrengthItem(String key, PasswordStrengthRequirements strengthItem) {
        if (this.strength == null) {
            this.strength = new HashMap<String, PasswordStrengthRequirements>();
        }
        this.strength.put(key, strengthItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows to calculate password strength based on mentioned criteria. Requirements will be checked one by one until first failed. ")
    public Map<String, PasswordStrengthRequirements> getStrength() {
        return this.strength;
    }

    public void setStrength(Map<String, PasswordStrengthRequirements> strength) {
        this.strength = strength;
    }

    public ShAppCfgAuthsValue lowercase(Boolean lowercase) {
        this.lowercase = lowercase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Transform user answer to lowercase letters. This allows user still pass a check when he wrote name or city with different cases. `false` means strict match, so \"John\" != \"john\"")
    public Boolean getLowercase() {
        return this.lowercase;
    }

    public void setLowercase(Boolean lowercase) {
        this.lowercase = lowercase;
    }

    public ShAppCfgAuthsValue removeSymbols(Boolean removeSymbols) {
        this.removeSymbols = removeSymbols;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remove all non-letters from user answer.")
    public Boolean getRemoveSymbols() {
        return this.removeSymbols;
    }

    public void setRemoveSymbols(Boolean removeSymbols) {
        this.removeSymbols = removeSymbols;
    }

    public ShAppCfgAuthsValue removeSpaces(Boolean removeSpaces) {
        this.removeSpaces = removeSpaces;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remove all spaces from user answer.")
    public Boolean getRemoveSpaces() {
        return this.removeSpaces;
    }

    public void setRemoveSpaces(Boolean removeSpaces) {
        this.removeSpaces = removeSpaces;
    }

    public ShAppCfgAuthsValue answersRequired(Integer answersRequired) {
        this.answersRequired = answersRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Min number of answers required to pass this check.")
    public Integer getAnswersRequired() {
        return this.answersRequired;
    }

    public void setAnswersRequired(Integer answersRequired) {
        this.answersRequired = answersRequired;
    }

    public ShAppCfgAuthsValue maxAnswers(Integer maxAnswers) {
        this.maxAnswers = maxAnswers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Max answers that user can save.")
    public Integer getMaxAnswers() {
        return this.maxAnswers;
    }

    public void setMaxAnswers(Integer maxAnswers) {
        this.maxAnswers = maxAnswers;
    }

    public ShAppCfgAuthsValue encryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getEncryptKey() {
        return this.encryptKey;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public ShAppCfgAuthsValue putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShAppCfgAuthsValue shAppCfgAuthsValue = (ShAppCfgAuthsValue)o;
        return Objects.equals(this.remote, shAppCfgAuthsValue.remote) && Objects.equals(this.requiresAuth, shAppCfgAuthsValue.requiresAuth) && Objects.equals(this.skipOnFail, shAppCfgAuthsValue.skipOnFail) && Objects.equals(this.rateLimiter, shAppCfgAuthsValue.rateLimiter) && Objects.equals(this.burnQuota, shAppCfgAuthsValue.burnQuota) && Objects.equals(this.query, shAppCfgAuthsValue.query) && Objects.equals(this.headers, shAppCfgAuthsValue.headers) && Objects.equals(this.code, shAppCfgAuthsValue.code) && Objects.equals(this.codeTtl, shAppCfgAuthsValue.codeTtl) && Objects.equals(this.scopes, shAppCfgAuthsValue.scopes) && Objects.equals(this.server, shAppCfgAuthsValue.server) && Objects.equals(this.sender, shAppCfgAuthsValue.sender) && Objects.equals(this.username, shAppCfgAuthsValue.username) && Objects.equals(this.password, shAppCfgAuthsValue.password) && Objects.equals(this.confirmationUrl, shAppCfgAuthsValue.confirmationUrl) && Objects.equals(this.templates, shAppCfgAuthsValue.templates) && Objects.equals(this.templateParams, shAppCfgAuthsValue.templateParams) && Objects.equals(this.ipBytesToIgnore, shAppCfgAuthsValue.ipBytesToIgnore) && Objects.equals(this.historySize, shAppCfgAuthsValue.historySize) && Objects.equals(this.exchangeAuthCode, shAppCfgAuthsValue.exchangeAuthCode) && Objects.equals(this.userInfo, shAppCfgAuthsValue.userInfo) && Objects.equals(this.extractLogin, shAppCfgAuthsValue.extractLogin) && Objects.equals(this.extractPublicData, shAppCfgAuthsValue.extractPublicData) && Objects.equals(this.maxLength, shAppCfgAuthsValue.maxLength) && Objects.equals(this.minLength, shAppCfgAuthsValue.minLength) && Objects.equals(this.requireNumber, shAppCfgAuthsValue.requireNumber) && Objects.equals(this.requireSymbol, shAppCfgAuthsValue.requireSymbol) && Objects.equals(this.requireUpperCase, shAppCfgAuthsValue.requireUpperCase) && Objects.equals(this.forbidCommonPasswords, shAppCfgAuthsValue.forbidCommonPasswords) && Objects.equals(this.forbidLoginAsPassword, shAppCfgAuthsValue.forbidLoginAsPassword) && Objects.equals(this.forbidReusingPassword, shAppCfgAuthsValue.forbidReusingPassword) && Objects.equals(this.strength, shAppCfgAuthsValue.strength) && Objects.equals(this.lowercase, shAppCfgAuthsValue.lowercase) && Objects.equals(this.removeSymbols, shAppCfgAuthsValue.removeSymbols) && Objects.equals(this.removeSpaces, shAppCfgAuthsValue.removeSpaces) && Objects.equals(this.answersRequired, shAppCfgAuthsValue.answersRequired) && Objects.equals(this.maxAnswers, shAppCfgAuthsValue.maxAnswers) && Objects.equals(this.encryptKey, shAppCfgAuthsValue.encryptKey) && Objects.equals(this.additionalProperties, shAppCfgAuthsValue.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.remote, this.requiresAuth, this.skipOnFail, this.rateLimiter, this.burnQuota, this.query, this.headers, this.code, this.codeTtl, this.scopes, this.server, this.sender, this.username, this.password, this.confirmationUrl, this.templates, this.templateParams, this.ipBytesToIgnore, this.historySize, this.exchangeAuthCode, this.userInfo, this.extractLogin, this.extractPublicData, this.maxLength, this.minLength, this.requireNumber, this.requireSymbol, this.requireUpperCase, this.forbidCommonPasswords, this.forbidLoginAsPassword, this.forbidReusingPassword, this.strength, this.lowercase, this.removeSymbols, this.removeSpaces, this.answersRequired, this.maxAnswers, this.encryptKey, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShAppCfgAuthsValue {\n");
        sb.append("    remote: ").append(this.toIndentedString(this.remote)).append("\n");
        sb.append("    requiresAuth: ").append(this.toIndentedString(this.requiresAuth)).append("\n");
        sb.append("    skipOnFail: ").append(this.toIndentedString(this.skipOnFail)).append("\n");
        sb.append("    rateLimiter: ").append(this.toIndentedString(this.rateLimiter)).append("\n");
        sb.append("    burnQuota: ").append(this.toIndentedString(this.burnQuota)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    codeTtl: ").append(this.toIndentedString(this.codeTtl)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    server: ").append(this.toIndentedString(this.server)).append("\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    confirmationUrl: ").append(this.toIndentedString(this.confirmationUrl)).append("\n");
        sb.append("    templates: ").append(this.toIndentedString(this.templates)).append("\n");
        sb.append("    templateParams: ").append(this.toIndentedString(this.templateParams)).append("\n");
        sb.append("    ipBytesToIgnore: ").append(this.toIndentedString(this.ipBytesToIgnore)).append("\n");
        sb.append("    historySize: ").append(this.toIndentedString(this.historySize)).append("\n");
        sb.append("    exchangeAuthCode: ").append(this.toIndentedString(this.exchangeAuthCode)).append("\n");
        sb.append("    userInfo: ").append(this.toIndentedString(this.userInfo)).append("\n");
        sb.append("    extractLogin: ").append(this.toIndentedString(this.extractLogin)).append("\n");
        sb.append("    extractPublicData: ").append(this.toIndentedString(this.extractPublicData)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    requireNumber: ").append(this.toIndentedString(this.requireNumber)).append("\n");
        sb.append("    requireSymbol: ").append(this.toIndentedString(this.requireSymbol)).append("\n");
        sb.append("    requireUpperCase: ").append(this.toIndentedString(this.requireUpperCase)).append("\n");
        sb.append("    forbidCommonPasswords: ").append(this.toIndentedString(this.forbidCommonPasswords)).append("\n");
        sb.append("    forbidLoginAsPassword: ").append(this.toIndentedString(this.forbidLoginAsPassword)).append("\n");
        sb.append("    forbidReusingPassword: ").append(this.toIndentedString(this.forbidReusingPassword)).append("\n");
        sb.append("    strength: ").append(this.toIndentedString(this.strength)).append("\n");
        sb.append("    lowercase: ").append(this.toIndentedString(this.lowercase)).append("\n");
        sb.append("    removeSymbols: ").append(this.toIndentedString(this.removeSymbols)).append("\n");
        sb.append("    removeSpaces: ").append(this.toIndentedString(this.removeSpaces)).append("\n");
        sb.append("    answersRequired: ").append(this.toIndentedString(this.answersRequired)).append("\n");
        sb.append("    maxAnswers: ").append(this.toIndentedString(this.maxAnswers)).append("\n");
        sb.append("    encryptKey: ").append(this.toIndentedString(this.encryptKey)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ShAppCfgAuthsValue is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REMOTE) != null && !jsonObj.get(SERIALIZED_NAME_REMOTE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REMOTE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `remote` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REMOTE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requiresAuth` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RATE_LIMITER) != null && !jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rateLimiter` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CODE).isJsonNull()) {
            CodeCfg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_CODE_TTL) != null && !jsonObj.get(SERIALIZED_NAME_CODE_TTL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CODE_TTL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `codeTtl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CODE_TTL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPES) != null && !jsonObj.get(SERIALIZED_NAME_SCOPES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCOPES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `scopes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVER) != null && !jsonObj.get(SERIALIZED_NAME_SERVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SERVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `server` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SENDER) != null && !jsonObj.get(SERIALIZED_NAME_SENDER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SENDER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sender` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SENDER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIRMATION_URL) != null && !jsonObj.get(SERIALIZED_NAME_CONFIRMATION_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONFIRMATION_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `confirmationUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIRMATION_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXCHANGE_AUTH_CODE) != null && !jsonObj.get(SERIALIZED_NAME_EXCHANGE_AUTH_CODE).isJsonNull()) {
            OAuthCfgExchangeAuthCode.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EXCHANGE_AUTH_CODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER_INFO) != null && !jsonObj.get(SERIALIZED_NAME_USER_INFO).isJsonNull()) {
            OAuthCfgUserInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_USER_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTRACT_LOGIN) != null && !jsonObj.get(SERIALIZED_NAME_EXTRACT_LOGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXTRACT_LOGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `extractLogin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTRACT_LOGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORBID_REUSING_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_FORBID_REUSING_PASSWORD).isJsonNull()) {
            PasswordHistoryCfg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FORBID_REUSING_PASSWORD));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENCRYPT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_ENCRYPT_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENCRYPT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `encryptKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENCRYPT_KEY).toString()));
        }
    }

    public static ShAppCfgAuthsValue fromJson(String jsonString) throws IOException {
        return (ShAppCfgAuthsValue)JSON.getGson().fromJson(jsonString, ShAppCfgAuthsValue.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_REMOTE);
        openapiFields.add(SERIALIZED_NAME_REQUIRES_AUTH);
        openapiFields.add(SERIALIZED_NAME_SKIP_ON_FAIL);
        openapiFields.add(SERIALIZED_NAME_RATE_LIMITER);
        openapiFields.add(SERIALIZED_NAME_BURN_QUOTA);
        openapiFields.add(SERIALIZED_NAME_QUERY);
        openapiFields.add(SERIALIZED_NAME_HEADERS);
        openapiFields.add(SERIALIZED_NAME_CODE);
        openapiFields.add(SERIALIZED_NAME_CODE_TTL);
        openapiFields.add(SERIALIZED_NAME_SCOPES);
        openapiFields.add(SERIALIZED_NAME_SERVER);
        openapiFields.add(SERIALIZED_NAME_SENDER);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiFields.add(SERIALIZED_NAME_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_CONFIRMATION_URL);
        openapiFields.add(SERIALIZED_NAME_TEMPLATES);
        openapiFields.add(SERIALIZED_NAME_TEMPLATE_PARAMS);
        openapiFields.add(SERIALIZED_NAME_IP_BYTES_TO_IGNORE);
        openapiFields.add(SERIALIZED_NAME_HISTORY_SIZE);
        openapiFields.add(SERIALIZED_NAME_EXCHANGE_AUTH_CODE);
        openapiFields.add(SERIALIZED_NAME_USER_INFO);
        openapiFields.add(SERIALIZED_NAME_EXTRACT_LOGIN);
        openapiFields.add(SERIALIZED_NAME_EXTRACT_PUBLIC_DATA);
        openapiFields.add(SERIALIZED_NAME_MAX_LENGTH);
        openapiFields.add(SERIALIZED_NAME_MIN_LENGTH);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_UPPER_CASE);
        openapiFields.add(SERIALIZED_NAME_FORBID_COMMON_PASSWORDS);
        openapiFields.add(SERIALIZED_NAME_FORBID_LOGIN_AS_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_FORBID_REUSING_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_STRENGTH);
        openapiFields.add(SERIALIZED_NAME_LOWERCASE);
        openapiFields.add(SERIALIZED_NAME_REMOVE_SYMBOLS);
        openapiFields.add(SERIALIZED_NAME_REMOVE_SPACES);
        openapiFields.add(SERIALIZED_NAME_ANSWERS_REQUIRED);
        openapiFields.add(SERIALIZED_NAME_MAX_ANSWERS);
        openapiFields.add(SERIALIZED_NAME_ENCRYPT_KEY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ShAppCfgAuthsValue.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ShAppCfgAuthsValue.class));
            return new TypeAdapter<ShAppCfgAuthsValue>(){

                public void write(JsonWriter out, ShAppCfgAuthsValue value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ShAppCfgAuthsValue read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ShAppCfgAuthsValue.validateJsonObject(jsonObj);
                    ShAppCfgAuthsValue instance = (ShAppCfgAuthsValue)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

