/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class QuestionsAuthCfg {
    public static final String SERIALIZED_NAME_REQUIRES_AUTH = "requiresAuth";
    @SerializedName(value="requiresAuth")
    private List<List<String>> requiresAuth = null;
    public static final String SERIALIZED_NAME_SKIP_ON_FAIL = "skipOnFail";
    @SerializedName(value="skipOnFail")
    private Boolean skipOnFail = false;
    public static final String SERIALIZED_NAME_RATE_LIMITER = "rateLimiter";
    @SerializedName(value="rateLimiter")
    private String rateLimiter;
    public static final String SERIALIZED_NAME_BURN_QUOTA = "burnQuota";
    @SerializedName(value="burnQuota")
    private Double burnQuota = 0.0;
    public static final String SERIALIZED_NAME_LOWERCASE = "lowercase";
    @SerializedName(value="lowercase")
    private Boolean lowercase = true;
    public static final String SERIALIZED_NAME_REMOVE_SYMBOLS = "removeSymbols";
    @SerializedName(value="removeSymbols")
    private Boolean removeSymbols = true;
    public static final String SERIALIZED_NAME_REMOVE_SPACES = "removeSpaces";
    @SerializedName(value="removeSpaces")
    private Boolean removeSpaces = true;
    public static final String SERIALIZED_NAME_MIN_LENGTH = "minLength";
    @SerializedName(value="minLength")
    private Integer minLength = 3;
    public static final String SERIALIZED_NAME_MAX_LENGTH = "maxLength";
    @SerializedName(value="maxLength")
    private Integer maxLength = 256;
    public static final String SERIALIZED_NAME_ANSWERS_REQUIRED = "answersRequired";
    @SerializedName(value="answersRequired")
    private Integer answersRequired = 2;
    public static final String SERIALIZED_NAME_MAX_ANSWERS = "maxAnswers";
    @SerializedName(value="maxAnswers")
    private Integer maxAnswers = 10;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public QuestionsAuthCfg requiresAuth(List<List<String>> requiresAuth) {
        this.requiresAuth = requiresAuth;
        return this;
    }

    public QuestionsAuthCfg addRequiresAuthItem(List<String> requiresAuthItem) {
        if (this.requiresAuth == null) {
            this.requiresAuth = new ArrayList<List<String>>();
        }
        this.requiresAuth.add(requiresAuthItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -> require specified auth to be enabled before this. - array of strings -> require any of listed auths to be enabled - array of arrays of strings -> works as `[ [ \"auth1\" and \"auth2\" ] or [ \"auth1\" and \"auth2\" ] ]`")
    public List<List<String>> getRequiresAuth() {
        return this.requiresAuth;
    }

    public void setRequiresAuth(List<List<String>> requiresAuth) {
        this.requiresAuth = requiresAuth;
    }

    public QuestionsAuthCfg skipOnFail(Boolean skipOnFail) {
        this.skipOnFail = skipOnFail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When this is set to true app will attempt next auth in case of error on current. It's works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.")
    public Boolean getSkipOnFail() {
        return this.skipOnFail;
    }

    public void setSkipOnFail(Boolean skipOnFail) {
        this.skipOnFail = skipOnFail;
    }

    public QuestionsAuthCfg rateLimiter(String rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply rate limiter for this auth.")
    public String getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(String rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public QuestionsAuthCfg burnQuota(Double burnQuota) {
        this.burnQuota = burnQuota;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified")
    public Double getBurnQuota() {
        return this.burnQuota;
    }

    public void setBurnQuota(Double burnQuota) {
        this.burnQuota = burnQuota;
    }

    public QuestionsAuthCfg lowercase(Boolean lowercase) {
        this.lowercase = lowercase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Transform user answer to lowercase letters. This allows user still pass a check when he wrote name or city with different cases. `false` means strict match, so \"John\" != \"john\"")
    public Boolean getLowercase() {
        return this.lowercase;
    }

    public void setLowercase(Boolean lowercase) {
        this.lowercase = lowercase;
    }

    public QuestionsAuthCfg removeSymbols(Boolean removeSymbols) {
        this.removeSymbols = removeSymbols;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remove all non-letters from user answer.")
    public Boolean getRemoveSymbols() {
        return this.removeSymbols;
    }

    public void setRemoveSymbols(Boolean removeSymbols) {
        this.removeSymbols = removeSymbols;
    }

    public QuestionsAuthCfg removeSpaces(Boolean removeSpaces) {
        this.removeSpaces = removeSpaces;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remove all spaces from user answer.")
    public Boolean getRemoveSpaces() {
        return this.removeSpaces;
    }

    public void setRemoveSpaces(Boolean removeSpaces) {
        this.removeSpaces = removeSpaces;
    }

    public QuestionsAuthCfg minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Min length of answer. Length are checked after all answer transformation.")
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public QuestionsAuthCfg maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Max length of answer.")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public QuestionsAuthCfg answersRequired(Integer answersRequired) {
        this.answersRequired = answersRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Min number of answers required to pass this check.")
    public Integer getAnswersRequired() {
        return this.answersRequired;
    }

    public void setAnswersRequired(Integer answersRequired) {
        this.answersRequired = answersRequired;
    }

    public QuestionsAuthCfg maxAnswers(Integer maxAnswers) {
        this.maxAnswers = maxAnswers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Max answers that user can save.")
    public Integer getMaxAnswers() {
        return this.maxAnswers;
    }

    public void setMaxAnswers(Integer maxAnswers) {
        this.maxAnswers = maxAnswers;
    }

    public QuestionsAuthCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestionsAuthCfg questionsAuthCfg = (QuestionsAuthCfg)o;
        return Objects.equals(this.requiresAuth, questionsAuthCfg.requiresAuth) && Objects.equals(this.skipOnFail, questionsAuthCfg.skipOnFail) && Objects.equals(this.rateLimiter, questionsAuthCfg.rateLimiter) && Objects.equals(this.burnQuota, questionsAuthCfg.burnQuota) && Objects.equals(this.lowercase, questionsAuthCfg.lowercase) && Objects.equals(this.removeSymbols, questionsAuthCfg.removeSymbols) && Objects.equals(this.removeSpaces, questionsAuthCfg.removeSpaces) && Objects.equals(this.minLength, questionsAuthCfg.minLength) && Objects.equals(this.maxLength, questionsAuthCfg.maxLength) && Objects.equals(this.answersRequired, questionsAuthCfg.answersRequired) && Objects.equals(this.maxAnswers, questionsAuthCfg.maxAnswers) && Objects.equals(this.additionalProperties, questionsAuthCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.requiresAuth, this.skipOnFail, this.rateLimiter, this.burnQuota, this.lowercase, this.removeSymbols, this.removeSpaces, this.minLength, this.maxLength, this.answersRequired, this.maxAnswers, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QuestionsAuthCfg {\n");
        sb.append("    requiresAuth: ").append(this.toIndentedString(this.requiresAuth)).append("\n");
        sb.append("    skipOnFail: ").append(this.toIndentedString(this.skipOnFail)).append("\n");
        sb.append("    rateLimiter: ").append(this.toIndentedString(this.rateLimiter)).append("\n");
        sb.append("    burnQuota: ").append(this.toIndentedString(this.burnQuota)).append("\n");
        sb.append("    lowercase: ").append(this.toIndentedString(this.lowercase)).append("\n");
        sb.append("    removeSymbols: ").append(this.toIndentedString(this.removeSymbols)).append("\n");
        sb.append("    removeSpaces: ").append(this.toIndentedString(this.removeSpaces)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("    answersRequired: ").append(this.toIndentedString(this.answersRequired)).append("\n");
        sb.append("    maxAnswers: ").append(this.toIndentedString(this.maxAnswers)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in QuestionsAuthCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requiresAuth` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RATE_LIMITER) != null && !jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rateLimiter` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).toString()));
        }
    }

    public static QuestionsAuthCfg fromJson(String jsonString) throws IOException {
        return (QuestionsAuthCfg)JSON.getGson().fromJson(jsonString, QuestionsAuthCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_REQUIRES_AUTH);
        openapiFields.add(SERIALIZED_NAME_SKIP_ON_FAIL);
        openapiFields.add(SERIALIZED_NAME_RATE_LIMITER);
        openapiFields.add(SERIALIZED_NAME_BURN_QUOTA);
        openapiFields.add(SERIALIZED_NAME_LOWERCASE);
        openapiFields.add(SERIALIZED_NAME_REMOVE_SYMBOLS);
        openapiFields.add(SERIALIZED_NAME_REMOVE_SPACES);
        openapiFields.add(SERIALIZED_NAME_MIN_LENGTH);
        openapiFields.add(SERIALIZED_NAME_MAX_LENGTH);
        openapiFields.add(SERIALIZED_NAME_ANSWERS_REQUIRED);
        openapiFields.add(SERIALIZED_NAME_MAX_ANSWERS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!QuestionsAuthCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(QuestionsAuthCfg.class));
            return new TypeAdapter<QuestionsAuthCfg>(){

                public void write(JsonWriter out, QuestionsAuthCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public QuestionsAuthCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    QuestionsAuthCfg.validateJsonObject(jsonObj);
                    QuestionsAuthCfg instance = (QuestionsAuthCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

