/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import app.kntrl.client.openapi.model.EntryCfg;
import app.kntrl.client.openapi.model.I18nCfg;
import app.kntrl.client.openapi.model.RateLimiterCfg;
import app.kntrl.client.openapi.model.ShAppCfgAuthsValue;
import app.kntrl.client.openapi.model.ShDbsCfg;
import app.kntrl.client.openapi.model.ShHttpCfg;
import app.kntrl.client.openapi.model.TokenCfg;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class ShAppCfg {
    public static final String SERIALIZED_NAME_HTTP = "http";
    @SerializedName(value="http")
    private ShHttpCfg http;
    public static final String SERIALIZED_NAME_LOGINS = "logins";
    @SerializedName(value="logins")
    private Set<String> logins = null;
    public static final String SERIALIZED_NAME_LOGIN_REQUIREMENTS = "loginRequirements";
    @SerializedName(value="loginRequirements")
    private Map<String, String> loginRequirements = null;
    public static final String SERIALIZED_NAME_AUTHS = "auths";
    @SerializedName(value="auths")
    private Map<String, ShAppCfgAuthsValue> auths = null;
    public static final String SERIALIZED_NAME_ENTRIES = "entries";
    @SerializedName(value="entries")
    private Map<String, EntryCfg> entries = null;
    public static final String SERIALIZED_NAME_DB = "db";
    @SerializedName(value="db")
    private ShDbsCfg db;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private TokenCfg token;
    public static final String SERIALIZED_NAME_RATE_LIMITERS = "rateLimiters";
    @SerializedName(value="rateLimiters")
    private Map<String, RateLimiterCfg> rateLimiters = null;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_HEALTH_CHECK_KEY = "healthCheckKey";
    @SerializedName(value="healthCheckKey")
    private String healthCheckKey;
    public static final String SERIALIZED_NAME_I18N = "i18n";
    @SerializedName(value="i18n")
    private I18nCfg i18n;
    public static final String SERIALIZED_NAME_$_SCHEMA = "$schema";
    @SerializedName(value="$schema")
    private String $schema = "./kntrl.schema.json";
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ShAppCfg http(ShHttpCfg http) {
        this.http = http;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ShHttpCfg getHttp() {
        return this.http;
    }

    public void setHttp(ShHttpCfg http) {
        this.http = http;
    }

    public ShAppCfg logins(Set<String> logins) {
        this.logins = logins;
        return this;
    }

    public ShAppCfg addLoginsItem(String loginsItem) {
        if (this.logins == null) {
            this.logins = new LinkedHashSet<String>();
        }
        this.logins.add(loginsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"username\",\"facebook\",\"email\"]", value="Types of logins that can be used for identification.  If the login type is not specified in the auth config - it will be considered a simple login: the user can set any name. E.g. username.  If the login type is specified in the auth config, this login will be generated by the corresponding authenticator. E.g. email, phone or facebook account id.  ")
    public Set<String> getLogins() {
        return this.logins;
    }

    public void setLogins(Set<String> logins) {
        this.logins = logins;
    }

    public ShAppCfg loginRequirements(Map<String, String> loginRequirements) {
        this.loginRequirements = loginRequirements;
        return this;
    }

    public ShAppCfg putLoginRequirementsItem(String key, String loginRequirementsItem) {
        if (this.loginRequirements == null) {
            this.loginRequirements = new HashMap<String, String>();
        }
        this.loginRequirements.put(key, loginRequirementsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"username\":\"[\\\\w\\\\-.]{3,45}\"}", value="Regexes to validate logins. ")
    public Map<String, String> getLoginRequirements() {
        return this.loginRequirements;
    }

    public void setLoginRequirements(Map<String, String> loginRequirements) {
        this.loginRequirements = loginRequirements;
    }

    public ShAppCfg auths(Map<String, ShAppCfgAuthsValue> auths) {
        this.auths = auths;
        return this;
    }

    public ShAppCfg putAuthsItem(String key, ShAppCfgAuthsValue authsItem) {
        if (this.auths == null) {
            this.auths = new HashMap<String, ShAppCfgAuthsValue>();
        }
        this.auths.put(key, authsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"email\":{},\"password\":{},\"facebook\":{\"builtin\":\"oauth\"}}", value="List of auth names and auth configs  To use builtin auths (not a plugin or remote) follow the example: `\"password\": { ... }` or `\"anyAuthName\": { \"builtin\": \"password\", ... }`  Available built-in auths: - `password`, `email`, `questions`, `ip` - `oauth`, `oauth/facebook/openid`, `oauth/google/openid` - `appSecret`  ")
    public Map<String, ShAppCfgAuthsValue> getAuths() {
        return this.auths;
    }

    public void setAuths(Map<String, ShAppCfgAuthsValue> auths) {
        this.auths = auths;
    }

    public ShAppCfg entries(Map<String, EntryCfg> entries) {
        this.entries = entries;
        return this;
    }

    public ShAppCfg putEntriesItem(String key, EntryCfg entriesItem) {
        if (this.entries == null) {
            this.entries = new HashMap<String, EntryCfg>();
        }
        this.entries.put(key, entriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of app entries. Entry usually represents UI used for signing in/up or additional authentication before action. E.g.: - app: main entry that requests user login/email + password and 2fa (if enabled) - api: entry that allows user to generate API keys and connect third-party app - action: additional authentication (e.g. code from sms) requested before e.g. payment ")
    public Map<String, EntryCfg> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<String, EntryCfg> entries) {
        this.entries = entries;
    }

    public ShAppCfg db(ShDbsCfg db) {
        this.db = db;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ShDbsCfg getDb() {
        return this.db;
    }

    public void setDb(ShDbsCfg db) {
        this.db = db;
    }

    public ShAppCfg token(TokenCfg token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TokenCfg getToken() {
        return this.token;
    }

    public void setToken(TokenCfg token) {
        this.token = token;
    }

    public ShAppCfg rateLimiters(Map<String, RateLimiterCfg> rateLimiters) {
        this.rateLimiters = rateLimiters;
        return this;
    }

    public ShAppCfg putRateLimitersItem(String key, RateLimiterCfg rateLimitersItem) {
        if (this.rateLimiters == null) {
            this.rateLimiters = new HashMap<String, RateLimiterCfg>();
        }
        this.rateLimiters.put(key, rateLimitersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of rate limiters ")
    public Map<String, RateLimiterCfg> getRateLimiters() {
        return this.rateLimiters;
    }

    public void setRateLimiters(Map<String, RateLimiterCfg> rateLimiters) {
        this.rateLimiters = rateLimiters;
    }

    public ShAppCfg secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key that app uses for RSA certificate generation used for token signature. If `null` - app will generate secret automatically during startup.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ShAppCfg healthCheckKey(String healthCheckKey) {
        this.healthCheckKey = healthCheckKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set this key if you want to restrict access to the health-check.")
    public String getHealthCheckKey() {
        return this.healthCheckKey;
    }

    public void setHealthCheckKey(String healthCheckKey) {
        this.healthCheckKey = healthCheckKey;
    }

    public ShAppCfg i18n(I18nCfg i18n) {
        this.i18n = i18n;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public I18nCfg getI18n() {
        return this.i18n;
    }

    public void setI18n(I18nCfg i18n) {
        this.i18n = i18n;
    }

    public ShAppCfg $schema(String $schema) {
        this.$schema = $schema;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String get$Schema() {
        return this.$schema;
    }

    public void set$Schema(String $schema) {
        this.$schema = $schema;
    }

    public ShAppCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShAppCfg shAppCfg = (ShAppCfg)o;
        return Objects.equals(this.http, shAppCfg.http) && Objects.equals(this.logins, shAppCfg.logins) && Objects.equals(this.loginRequirements, shAppCfg.loginRequirements) && Objects.equals(this.auths, shAppCfg.auths) && Objects.equals(this.entries, shAppCfg.entries) && Objects.equals(this.db, shAppCfg.db) && Objects.equals(this.token, shAppCfg.token) && Objects.equals(this.rateLimiters, shAppCfg.rateLimiters) && Objects.equals(this.secret, shAppCfg.secret) && Objects.equals(this.healthCheckKey, shAppCfg.healthCheckKey) && Objects.equals(this.i18n, shAppCfg.i18n) && Objects.equals(this.$schema, shAppCfg.$schema) && Objects.equals(this.additionalProperties, shAppCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.http, this.logins, this.loginRequirements, this.auths, this.entries, this.db, this.token, this.rateLimiters, this.secret, this.healthCheckKey, this.i18n, this.$schema, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShAppCfg {\n");
        sb.append("    http: ").append(this.toIndentedString(this.http)).append("\n");
        sb.append("    logins: ").append(this.toIndentedString(this.logins)).append("\n");
        sb.append("    loginRequirements: ").append(this.toIndentedString(this.loginRequirements)).append("\n");
        sb.append("    auths: ").append(this.toIndentedString(this.auths)).append("\n");
        sb.append("    entries: ").append(this.toIndentedString(this.entries)).append("\n");
        sb.append("    db: ").append(this.toIndentedString(this.db)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    rateLimiters: ").append(this.toIndentedString(this.rateLimiters)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    healthCheckKey: ").append(this.toIndentedString(this.healthCheckKey)).append("\n");
        sb.append("    i18n: ").append(this.toIndentedString(this.i18n)).append("\n");
        sb.append("    $schema: ").append(this.toIndentedString(this.$schema)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ShAppCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HTTP) != null && !jsonObj.get(SERIALIZED_NAME_HTTP).isJsonNull()) {
            ShHttpCfg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_HTTP));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOGINS) != null && !jsonObj.get(SERIALIZED_NAME_LOGINS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LOGINS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `logins` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOGINS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DB) != null && !jsonObj.get(SERIALIZED_NAME_DB).isJsonNull()) {
            ShDbsCfg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DB));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_TOKEN).isJsonNull()) {
            TokenCfg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRET) != null && !jsonObj.get(SERIALIZED_NAME_SECRET).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECRET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secret` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRET).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HEALTH_CHECK_KEY) != null && !jsonObj.get(SERIALIZED_NAME_HEALTH_CHECK_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HEALTH_CHECK_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `healthCheckKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HEALTH_CHECK_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_I18N) != null && !jsonObj.get(SERIALIZED_NAME_I18N).isJsonNull()) {
            I18nCfg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_I18N));
        }
        if (jsonObj.get(SERIALIZED_NAME_$_SCHEMA) != null && !jsonObj.get(SERIALIZED_NAME_$_SCHEMA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_$_SCHEMA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `$schema` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_$_SCHEMA).toString()));
        }
    }

    public static ShAppCfg fromJson(String jsonString) throws IOException {
        return (ShAppCfg)JSON.getGson().fromJson(jsonString, ShAppCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HTTP);
        openapiFields.add(SERIALIZED_NAME_LOGINS);
        openapiFields.add(SERIALIZED_NAME_LOGIN_REQUIREMENTS);
        openapiFields.add(SERIALIZED_NAME_AUTHS);
        openapiFields.add(SERIALIZED_NAME_ENTRIES);
        openapiFields.add(SERIALIZED_NAME_DB);
        openapiFields.add(SERIALIZED_NAME_TOKEN);
        openapiFields.add(SERIALIZED_NAME_RATE_LIMITERS);
        openapiFields.add(SERIALIZED_NAME_SECRET);
        openapiFields.add(SERIALIZED_NAME_HEALTH_CHECK_KEY);
        openapiFields.add(SERIALIZED_NAME_I18N);
        openapiFields.add(SERIALIZED_NAME_$_SCHEMA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ShAppCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ShAppCfg.class));
            return new TypeAdapter<ShAppCfg>(){

                public void write(JsonWriter out, ShAppCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ShAppCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ShAppCfg.validateJsonObject(jsonObj);
                    ShAppCfg instance = (ShAppCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

